/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.activity;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.Activity;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class ActivityFacade
extends AbstractFacade<Activity> {
    private static final Logger LOGGER = Logger.getLogger(ActivityFacade.class.getName());
    public static final String NEW_PROJECT = " created a new project named ";
    public static final String NEW_DATA = " added a new dataset named ";
    public static final String UPDATE_DATASET_DESCRIPTION = " updated dataset description for ";
    public static final String SHARED_DATA = " shared dataset ";
    public static final String UNSHARED_DATA = " unshared dataset ";
    public static final String NEW_MEMBER = " added a member ";
    public static final String CHANGE_ROLE = " changed the role of ";
    public static final String CHANGE_DATASET_PERMISSION = " changed dataset permission ";
    public static final String CHANGE_DATASET_SHARE_PERMISSION = " changed dataset share permission ";
    public static final String REMOVED_MEMBER = " removed team member ";
    public static final String RAN_JOB = " ran a job named ";
    public static final String ADDED_SERVICE = " added new service ";
    public static final String PROJECT_DESC_CHANGED = " changed project description ";
    public static final String PROJECT_RETENTION_CHANGED = " changed project retention ";
    public static final String CREATED_JOB = " created a new job named ";
    public static final String DELETED_JOB = " deleted a job named ";
    public static final String SCHEDULED_JOB = " scheduled a job named ";
    public static final String EXECUTED_JOB = " ran a job used as input file ";
    public static final String CREATED_FEATURESTORE = " created a new feature store named ";
    public static final String CREATED_FEATUREGROUP = " created a new feature group named ";
    public static final String CREATED_TRAINING_DATASET = " created a new training dataset named ";
    public static final String DELETED_FEATUREGROUP = " deleted a feature group named ";
    public static final String DELETED_TRAINING_DATASET = " deleted a training dataset named ";
    public static final String CREATED_NEW_VERSION_OF_FEATUREGROUP = " created a new version of a feature group named ";
    public static final String EDITED_FEATUREGROUP = " edited feature group named ";
    public static final String EDITED_TRAINING_DATASET = " edited training dataset named ";
    public static final String ADDED_FEATURESTORE_STORAGE_CONNECTOR = " added a storage connector for the featurestore with name: ";
    public static final String REMOVED_FEATURESTORE_STORAGE_CONNECTOR = " added a storage connector for the featurestore with name: ";
    public static final String REMOVED_FEATURESTORE_STORAGE_CONNECTOR_ID = " added a storage connector for the featurestore with id: ";
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public ActivityFacade() {
        super(Activity.class);
    }

    public void persistActivity(Activity activity) {
        this.em.persist((Object)activity);
    }

    public void removeActivity(Activity activity) {
        this.em.remove((Object)activity);
    }

    public long getTotalCount() {
        TypedQuery q = this.em.createNamedQuery("Activity.countAll", Long.class);
        return (Long)q.getSingleResult();
    }

    public long getProjectCount(Project project) {
        TypedQuery q = this.em.createNamedQuery("Activity.countPerProject", Long.class);
        q.setParameter("project", (Object)project);
        return (Long)q.getSingleResult();
    }

    public Activity activityByID(int id) {
        TypedQuery query = this.em.createNamedQuery("Activity.findById", Activity.class).setParameter("id", (Object)id);
        Activity activity = null;
        try {
            activity = (Activity)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, e.getMessage());
        }
        return activity;
    }

    public Activity lastActivityOnProject(Project project) {
        TypedQuery query = this.em.createNamedQuery("Activity.findByProject", Activity.class);
        query.setParameter("project", (Object)project);
        query.setMaxResults(1);
        try {
            return (Activity)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.SEVERE, "No activity returned for project " + project + ", while its creation should always be there!", e);
            return null;
        }
    }

    public void persistActivity(String activity, Project project, Users user, ActivityFlag flag) {
        Activity a = new Activity();
        a.setActivity(activity);
        a.setProject(project);
        a.setFlag(flag);
        a.setUser(user);
        a.setTimestamp(new Date());
        this.em.persist((Object)a);
    }

    public void persistActivity(String activity, Project project, String email, ActivityFlag flag) {
        Users user;
        TypedQuery userQuery = this.em.createNamedQuery("Users.findByEmail", Users.class);
        userQuery.setParameter("email", (Object)email);
        try {
            user = (Users)userQuery.getSingleResult();
        }
        catch (NoResultException e) {
            throw new IllegalArgumentException("No user found with email " + email + " when trying to persist activity for that user.", e);
        }
        this.persistActivity(activity, project, user, flag);
    }

    public List<Activity> getAllActivities() {
        TypedQuery q = this.em.createNamedQuery("Activity.findAll", Activity.class);
        return q.getResultList();
    }

    public List<Activity> getAllActivityByProject(Project project) {
        TypedQuery q = this.em.createNamedQuery("Activity.findByProject", Activity.class);
        q.setParameter("project", (Object)project);
        return q.getResultList();
    }

    public Activity getActivityByIdAndProject(Project project, Integer id) {
        TypedQuery q = this.em.createNamedQuery("Activity.findByIdAndProject", Activity.class);
        q.setParameter("id", (Object)id);
        q.setParameter("project", (Object)project);
        Activity activity = null;
        try {
            activity = (Activity)q.getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, e.getMessage());
        }
        return activity;
    }

    public List<Activity> getAllActivityByUser(Users user) {
        TypedQuery q = this.em.createNamedQuery("Activity.findByUser", Activity.class);
        q.setParameter("user", (Object)user);
        return q.getResultList();
    }

    public Activity getActivityByIdAndUser(Users user, Integer id) {
        TypedQuery q = this.em.createNamedQuery("Activity.findByIdAndUser", Activity.class);
        q.setParameter("id", (Object)id);
        q.setParameter("user", (Object)user);
        Activity activity = null;
        try {
            activity = (Activity)q.getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, e.getMessage());
        }
        return activity;
    }

    public List<Activity> getPaginatedActivityByUser(Integer offset, Integer limit, Users user) {
        TypedQuery q = this.em.createNamedQuery("Activity.findByUser", Activity.class);
        q.setParameter("user", (Object)user);
        this.setOffsetAndLim(offset, limit, (Query)q);
        return q.getResultList();
    }

    public List<Activity> getPaginatedActivity(Integer offset, Integer limit) {
        TypedQuery q = this.em.createNamedQuery("Activity.findAll", Activity.class);
        this.setOffsetAndLim(offset, limit, (Query)q);
        return q.getResultList();
    }

    public List<Activity> getPaginatedActivityForProject(Integer offset, Integer limit, Project project) {
        TypedQuery q = this.em.createNamedQuery("Activity.findByProject", Activity.class);
        q.setParameter("project", (Object)project);
        this.setOffsetAndLim(offset, limit, (Query)q);
        return q.getResultList();
    }

    public List<Activity> findAllTeamActivity(String flag) {
        TypedQuery query = this.em.createNamedQuery("Activity.findByFlag", Activity.class).setParameter("flag", (Object)flag);
        return query.getResultList();
    }

    public AbstractFacade.CollectionInfo findAllByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT u FROM Activity u ", filter, sort, "u.project = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(u.id) FROM Activity u ", filter, sort, "u.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, Activity.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Activity.class).setParameter("project", (Object)project);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    public AbstractFacade.CollectionInfo findAllByUser(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Users user) {
        String queryStr = this.buildQuery("SELECT u FROM Activity u ", filter, sort, "u.user = :user ");
        String queryCountStr = this.buildQuery("SELECT COUNT(u.id) FROM Activity u ", filter, sort, "u.user = :user ");
        TypedQuery query = this.em.createQuery(queryStr, Activity.class).setParameter("user", (Object)user);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Activity.class).setParameter("user", (Object)user);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setFilter(filter, query);
        this.setFilter(filter, queryCount);
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        List<ActivityFlag> activityFlags = this.getEnumValues(filterBy, ActivityFlag.class);
        q.setParameter(filterBy.getField(), activityFlags);
    }

    public static enum Filters {
        FLAG("FLAG", "u.flag IN :flag ", "flag", "PROJECT"),
        FLAG_NEQ("FLAG_NEQ", "u.flag NOT IN :flag_neq ", "flag_neq", "PROJECT");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "u.id ", "ASC"),
        FLAG("FLAG", "u.flag ", "ASC"),
        DATE_CREATED("DATE_CREATED", "u.timestamp ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

