/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobDTO;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobFacade;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsController;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnController;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.HivePartitions;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturegroupController {
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private OnDemandFeaturegroupController onDemandFeaturegroupController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturestoreJobFacade featurestoreJobFacade;
    @EJB
    private JobFacade jobFacade;
    @EJB
    private StatisticColumnController statisticColumnController;
    @EJB
    private StatisticColumnFacade statisticColumnFacade;
    @EJB
    private FeaturestoreInputValidation featurestoreInputValidation;
    @EJB
    private CachedFeaturegroupFacade cachedFeaturegroupFacade;
    @EJB
    private HopsFSProvenanceController fsController;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private StatisticsController statisticsController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private InodeController inodeController;

    public List<FeaturegroupDTO> getFeaturegroupsForFeaturestore(Featurestore featurestore, Project project, Users user) throws FeaturestoreException, ServiceException {
        List<Featuregroup> featuregroups = this.featuregroupFacade.findByFeaturestore(featurestore);
        ArrayList<FeaturegroupDTO> featuregroupDTOS = new ArrayList<FeaturegroupDTO>();
        for (Featuregroup featuregroup : featuregroups) {
            featuregroupDTOS.add(this.convertFeaturegrouptoDTO(featuregroup, project, user));
        }
        return featuregroupDTOS;
    }

    public FeaturegroupDTO clearFeaturegroup(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, SQLException, ProvenanceException, IOException, ServiceException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                FeaturegroupDTO featuregroupDTO = this.convertFeaturegrouptoDTO(featuregroup, project, user);
                this.deleteFeaturegroup(featuregroup, project, user);
                return this.createFeaturegroupNoValidation(featuregroup.getFeaturestore(), featuregroupDTO, project, user);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CLEAR_OPERATION_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public FeaturegroupDTO createFeaturegroup(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, ServiceException, SQLException, ProvenanceException, IOException {
        if (featuregroupDTO.getVersion() == null) {
            List<Featuregroup> fgPrevious = this.featuregroupFacade.findByNameAndFeaturestoreOrderedDescVersion(featuregroupDTO.getName(), featurestore);
            if (fgPrevious != null && !fgPrevious.isEmpty()) {
                featuregroupDTO.setVersion(fgPrevious.get(0).getVersion() + 1);
            } else {
                featuregroupDTO.setVersion(1);
            }
        }
        this.verifyFeatureGroupInput(featuregroupDTO);
        this.verifyFeaturesNoDefaultValue(featuregroupDTO.getFeatures());
        return this.createFeaturegroupNoValidation(featurestore, featuregroupDTO, project, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeaturegroupDTO createFeaturegroupNoValidation(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, SQLException, ProvenanceException, ServiceException {
        OnDemandFeaturegroup onDemandFeaturegroup = null;
        CachedFeaturegroup cachedFeaturegroup = null;
        if (featuregroupDTO instanceof CachedFeaturegroupDTO) {
            cachedFeaturegroup = this.cachedFeaturegroupController.createCachedFeaturegroup(featurestore, (CachedFeaturegroupDTO)featuregroupDTO, project, user);
        } else {
            onDemandFeaturegroup = this.onDemandFeaturegroupController.createOnDemandFeaturegroup(featurestore, (OnDemandFeaturegroupDTO)featuregroupDTO, project, user);
        }
        Featuregroup featuregroup = this.persistFeaturegroupMetadata(featurestore, user, featuregroupDTO, cachedFeaturegroup, onDemandFeaturegroup);
        this.statisticColumnController.persistStatisticColumns(featuregroup, featuregroupDTO.getStatisticColumns());
        featuregroup.setStatisticColumns(this.statisticColumnFacade.findByFeaturegroup(featuregroup));
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        FeaturegroupDTO completeFeaturegroupDTO = this.convertFeaturegrouptoDTO(featuregroup, project, user);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            String fgPath = Utils.getFeaturestorePath(featurestore.getProject(), this.settings) + "/" + Utils.getFeaturegroupName(featuregroup.getName(), featuregroup.getVersion());
            this.fsController.featuregroupAttachXAttrs(fgPath, completeFeaturegroupDTO, udfso);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        return completeFeaturegroupDTO;
    }

    private List<Jobs> getJobs(List<FeaturestoreJobDTO> jobDTOs, Project project) {
        if (jobDTOs != null) {
            return jobDTOs.stream().filter(jobDTO -> jobDTO != null && !Strings.isNullOrEmpty((String)jobDTO.getJobName())).map(jobDTO -> jobDTO.getJobName()).distinct().map(jobName -> this.jobFacade.findByProjectAndName(project, (String)jobName)).collect(Collectors.toList());
        }
        return new ArrayList<Jobs>();
    }

    private FeaturegroupDTO convertFeaturegrouptoDTO(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, ServiceException {
        String featurestoreName = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                CachedFeaturegroupDTO cachedFeaturegroupDTO = this.cachedFeaturegroupController.convertCachedFeaturegroupToDTO(featuregroup, project, user);
                cachedFeaturegroupDTO.setFeaturestoreName(featurestoreName);
                return cachedFeaturegroupDTO;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                FeaturestoreJdbcConnectorDTO storageConnectorDTO = new FeaturestoreJdbcConnectorDTO(featuregroup.getOnDemandFeaturegroup().getFeaturestoreJdbcConnector());
                return new OnDemandFeaturegroupDTO(featurestoreName, featuregroup, storageConnectorDTO);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public List<FeaturegroupDTO> getFeaturegroupWithNameAndFeaturestore(Featurestore featurestore, String name, Project project, Users user) throws FeaturestoreException, ServiceException {
        List<Featuregroup> featuregroups = this.verifyFeaturegroupName(featurestore, name);
        ArrayList<FeaturegroupDTO> featuregroupDTOS = new ArrayList<FeaturegroupDTO>();
        for (Featuregroup featuregroup : featuregroups) {
            featuregroupDTOS.add(this.convertFeaturegrouptoDTO(featuregroup, project, user));
        }
        return featuregroupDTOS;
    }

    public FeaturegroupDTO getFeaturegroupWithNameVersionAndFeaturestore(Featurestore featurestore, String name, Integer version, Project project, Users user) throws FeaturestoreException, ServiceException {
        Featuregroup featuregroup = this.verifyFeaturegroupNameVersion(featurestore, name, version);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public FeaturegroupDTO getFeaturegroupWithIdAndFeaturestore(Featurestore featurestore, Integer id, Project project, Users user) throws FeaturestoreException, ServiceException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, id);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeaturegroupDTO updateFeaturegroupMetadata(Project project, Users user, Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException, SQLException, ProvenanceException, ServiceException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        this.featurestoreInputValidation.verifyDescription(featuregroupDTO);
        this.featurestoreInputValidation.verifyFeatureGroupFeatureList(featuregroupDTO.getFeatures());
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP) {
            this.cachedFeaturegroupController.updateMetadata(project, user, featuregroup, (CachedFeaturegroupDTO)featuregroupDTO);
        } else if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            this.onDemandFeaturegroupController.updateOnDemandFeaturegroupMetadata(featuregroup.getOnDemandFeaturegroup(), (OnDemandFeaturegroupDTO)featuregroupDTO);
        }
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        featuregroupDTO = this.convertFeaturegrouptoDTO(featuregroup, project, user);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            String fgPath = Utils.getFeaturestorePath(featurestore.getProject(), this.settings) + "/" + Utils.getFeaturegroupName(featuregroupDTO.getName(), featuregroupDTO.getVersion());
            this.fsController.featuregroupAttachXAttrs(fgPath, featuregroupDTO, udfso);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        return featuregroupDTO;
    }

    public FeaturegroupDTO updateFeaturegroupJob(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, ServiceException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public FeaturegroupDTO enableFeaturegroupOnline(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, SQLException, ServiceException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ONLINE_FEATURE_SERVING_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, ", Online feature serving is only supported for featuregroups of type: " + FeaturegroupType.CACHED_FEATURE_GROUP + ", and the user requested to enable feature serving on a featuregroup with type:" + FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        }
        this.cachedFeaturegroupController.enableFeaturegroupOnline(featurestore, featuregroup, project, user);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public FeaturegroupDTO disableFeaturegroupOnline(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, SQLException, ServiceException {
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ONLINE_FEATURE_SERVING_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, ", Online feature serving is only supported for featuregroups of type: " + FeaturegroupType.CACHED_FEATURE_GROUP + ", and the user requested to a feature serving operation on a featuregroup with type:" + FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        }
        this.cachedFeaturegroupController.disableFeaturegroupOnline(featuregroup, project, user);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public FeaturegroupDTO updateFeaturegroupStatsSettings(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, ServiceException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        if (featuregroupDTO.isDescStatsEnabled() != null) {
            this.verifyFeaturegroupStatsSettings(featuregroupDTO.isDescStatsEnabled(), featuregroupDTO.isFeatCorrEnabled(), featuregroupDTO.isFeatHistEnabled());
            featuregroup.setDescStatsEnabled(featuregroupDTO.isDescStatsEnabled().booleanValue());
        } else {
            this.verifyFeaturegroupStatsSettings(featuregroup.isDescStatsEnabled(), featuregroupDTO.isFeatCorrEnabled(), featuregroupDTO.isFeatHistEnabled());
        }
        if (featuregroupDTO.isFeatHistEnabled() != null) {
            featuregroup.setFeatHistEnabled(featuregroupDTO.isFeatHistEnabled().booleanValue());
        }
        if (featuregroupDTO.isFeatCorrEnabled() != null) {
            featuregroup.setFeatCorrEnabled(featuregroupDTO.isFeatCorrEnabled().booleanValue());
        }
        this.statisticColumnController.verifyStatisticColumnsExist(featuregroupDTO, this.convertFeaturegrouptoDTO(featuregroup, project, user).getFeatures());
        this.featuregroupFacade.updateFeaturegroupMetadata(featuregroup);
        this.statisticColumnController.persistStatisticColumns(featuregroup, featuregroupDTO.getStatisticColumns());
        featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public void verifyFeaturegroupStatsSettings(Boolean generalStatistics, Boolean correlations, Boolean histograms) throws FeaturestoreException {
        if (generalStatistics != null && !generalStatistics.booleanValue() && (correlations != null && correlations.booleanValue() || histograms != null && histograms.booleanValue())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STATISTICS_CONFIG, Level.FINE, "correlations and histograms can only be enabled with statistics generally enabled.");
        }
    }

    public boolean featuregroupExists(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) {
        if (!Strings.isNullOrEmpty((String)featuregroupDTO.getName()) && featuregroupDTO.getVersion() != null) {
            return this.featuregroupFacade.findByNameVersionAndFeaturestore(featuregroupDTO.getName(), featuregroupDTO.getVersion(), featurestore).isPresent();
        }
        return false;
    }

    public void deleteFeaturegroup(Featuregroup featuregroup, Project project, Users user) throws SQLException, FeaturestoreException, ServiceException, IOException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                this.statisticsController.deleteStatistics(project, user, featuregroup);
                this.cachedFeaturegroupController.dropHiveFeaturegroup(featuregroup, project, user);
                this.cachedFeaturegroupController.dropMySQLFeaturegroup(featuregroup, project, user);
                break;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                this.onDemandFeaturegroupController.removeOnDemandFeaturegroup(featuregroup.getFeaturestore(), featuregroup, project, user);
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
            }
        }
        this.activityFacade.persistActivity(" deleted a feature group named " + featuregroup.getName(), project, user, ActivityFlag.SERVICE);
    }

    public FeaturegroupPreview getFeaturegroupPreview(Featuregroup featuregroup, Project project, Users user, String partition, boolean online, int limit) throws SQLException, FeaturestoreException, HopsSecurityException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getFeaturegroupPreview(featuregroup, project, user, partition, online, limit);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.PREVIEW_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public List<HivePartitions> getPartitions(Featuregroup featuregroup, Integer offset, Integer limit) throws FeaturestoreException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupFacade.getHiveTablePartitions(featuregroup.getCachedFeaturegroup().getHiveTbls(), offset, limit);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_ONDEMAND_NO_PARTS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public Featuregroup getFeaturegroupById(Featurestore featurestore, Integer featuregroupId) throws FeaturestoreException {
        return this.featuregroupFacade.findByIdAndFeaturestore(featuregroupId, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "Feature group id: " + featuregroupId));
    }

    private List<Featuregroup> verifyFeaturegroupName(Featurestore featurestore, String featureGroupName) {
        List<Featuregroup> featuregroup = this.featuregroupFacade.findByNameAndFeaturestore(featureGroupName, featurestore);
        if (featuregroup == null || featuregroup.isEmpty()) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND + " feature group name " + featureGroupName);
        }
        return featuregroup;
    }

    public Featuregroup verifyFeaturegroupNameVersion(Featurestore featurestore, String featureGroupName, Integer version) throws FeaturestoreException {
        return this.featuregroupFacade.findByNameVersionAndFeaturestore(featureGroupName, version, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "feature group name: " + featureGroupName + " feature group version: " + version));
    }

    public FeaturegroupDTO syncHiveTableWithFeaturestore(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Users user) throws FeaturestoreException {
        if (featuregroupDTO instanceof OnDemandFeaturegroupDTO) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Only cached feature groups can be synced from an existing Hive table, not on-demand feature groups.");
        }
        this.verifyFeatureGroupInput(featuregroupDTO);
        CachedFeaturegroup cachedFeaturegroup = this.cachedFeaturegroupController.syncHiveTableWithFeaturestore(featurestore, (CachedFeaturegroupDTO)featuregroupDTO);
        Featuregroup featuregroup = this.persistFeaturegroupMetadata(featurestore, user, featuregroupDTO, cachedFeaturegroup, null);
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        return featuregroupDTO;
    }

    private Featuregroup persistFeaturegroupMetadata(Featurestore featurestore, Users user, FeaturegroupDTO featuregroupDTO, CachedFeaturegroup cachedFeaturegroup, OnDemandFeaturegroup onDemandFeaturegroup) {
        Featuregroup featuregroup = new Featuregroup();
        featuregroup.setName(featuregroupDTO.getName());
        featuregroup.setFeaturestore(featurestore);
        featuregroup.setCreated(new Date());
        featuregroup.setCreator(user);
        featuregroup.setVersion(featuregroupDTO.getVersion());
        featuregroup.setFeaturegroupType(featuregroupDTO instanceof CachedFeaturegroupDTO ? FeaturegroupType.CACHED_FEATURE_GROUP : FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        featuregroup.setCachedFeaturegroup(cachedFeaturegroup);
        featuregroup.setOnDemandFeaturegroup(onDemandFeaturegroup);
        if (featuregroupDTO.isDescStatsEnabled() != null) {
            featuregroup.setDescStatsEnabled(featuregroupDTO.isDescStatsEnabled().booleanValue());
            featuregroup.setFeatHistEnabled(featuregroupDTO.isFeatHistEnabled() != null && featuregroupDTO.isFeatHistEnabled() != false && featuregroupDTO.isDescStatsEnabled() != false);
            featuregroup.setFeatCorrEnabled(featuregroupDTO.isFeatCorrEnabled() != null && featuregroupDTO.isFeatCorrEnabled() != false && featuregroupDTO.isDescStatsEnabled() != false);
        }
        this.featuregroupFacade.persist(featuregroup);
        return featuregroup;
    }

    public List<FeatureGroupFeatureDTO> getFeatures(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getFeaturesDTO(featuregroup.getCachedFeaturegroup(), featuregroup.getFeaturestore(), project, user);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                return featuregroup.getOnDemandFeaturegroup().getFeatures().stream().map(f -> new FeatureGroupFeatureDTO(f.getName(), f.getType(), f.getPrimary(), null)).collect(Collectors.toList());
            }
        }
        return new ArrayList<FeatureGroupFeatureDTO>();
    }

    public String getFeatureGroupLocation(Featuregroup featureGroup) {
        return this.inodeController.getPath(featureGroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP ? featureGroup.getCachedFeaturegroup().getHiveTbls().getSdId().getInode() : featureGroup.getOnDemandFeaturegroup().getInode());
    }

    private void verifyFeatureGroupInput(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        this.featurestoreInputValidation.verifyUserInput(featureGroupDTO);
        this.verifyFeatureGroupVersion(featureGroupDTO.getVersion());
        this.verifyFeaturegroupStatsSettings(featureGroupDTO.isDescStatsEnabled(), featureGroupDTO.isFeatCorrEnabled(), featureGroupDTO.isFeatHistEnabled());
        this.statisticColumnController.verifyStatisticColumnsExist(featureGroupDTO);
    }

    private void verifyFeatureGroupVersion(Integer version) throws FeaturestoreException {
        if (version == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_VERSION_NOT_PROVIDED.getMessage());
        }
        if (version <= 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_VERSION, Level.FINE, "version cannot be negative or zero");
        }
    }

    void verifyFeaturesNoDefaultValue(List<FeatureGroupFeatureDTO> features) throws FeaturestoreException {
        if (features.stream().anyMatch(f -> f.getDefaultValue() != null)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_GROUP_FEATURE_DEFAULT_VALUE, Level.FINE, "default values for features cannot be set during feature group creation, only allowed for appenedfeatures");
        }
    }
}

