/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors;

import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.redshift.FeaturestoreRedshiftConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.redshift.FeaturestoreRedshiftConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreStorageConnectorController {
    @EJB
    private FeaturestoreHopsfsConnectorController featurestoreHopsfsConnectorController;
    @EJB
    private FeaturestoreJdbcConnectorController featurestoreJdbcConnectorController;
    @EJB
    private FeaturestoreRedshiftConnectorController featurestoreRedshiftConnectorController;
    @EJB
    private FeaturestoreS3ConnectorController featurestoreS3ConnectorController;
    @EJB
    private ProjectTeamFacade projectTeamFacade;

    public List<FeaturestoreStorageConnectorDTO> getAllStorageConnectorsForFeaturestore(Users user, Featurestore featurestore) throws FeaturestoreException {
        ArrayList<FeaturestoreStorageConnectorDTO> featurestoreStorageConnectorDTOS = new ArrayList<FeaturestoreStorageConnectorDTO>();
        featurestoreStorageConnectorDTOS.addAll(this.featurestoreJdbcConnectorController.getJdbcConnectorsForFeaturestore(user, featurestore));
        featurestoreStorageConnectorDTOS.addAll(this.featurestoreRedshiftConnectorController.getConnectorsForFeaturestore(user, featurestore));
        featurestoreStorageConnectorDTOS.addAll(this.featurestoreS3ConnectorController.getS3ConnectorsForFeaturestore(user, featurestore));
        featurestoreStorageConnectorDTOS.addAll(this.featurestoreHopsfsConnectorController.getHopsfsConnectors(featurestore));
        return featurestoreStorageConnectorDTOS;
    }

    public List<FeaturestoreStorageConnectorDTO> getAllStorageConnectorsForFeaturestoreWithType(Users user, Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType) throws FeaturestoreException {
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.getS3ConnectorsForFeaturestore(user, featurestore);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.getJdbcConnectorsForFeaturestore(user, featurestore);
            }
            case REDSHIFT: {
                return this.featurestoreRedshiftConnectorController.getConnectorsForFeaturestore(user, featurestore);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.getHopsfsConnectors(featurestore);
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Unrecognized storage connector type " + (Object)((Object)featurestoreStorageConnectorType) + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.REDSHIFT) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC));
    }

    public FeaturestoreStorageConnectorDTO getStorageConnectorForFeaturestoreWithTypeAndName(Users user, Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType, String storageConnectorName) throws FeaturestoreException {
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.getS3ConnectorWithNameAndFeaturestore(user, featurestore, storageConnectorName);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.getJdbcConnectorWithNameAndFeaturestore(user, featurestore, storageConnectorName);
            }
            case REDSHIFT: {
                return this.featurestoreRedshiftConnectorController.getConnectorsWithNameAndFeaturestore(user, featurestore, storageConnectorName);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.getHopsFsConnectorWithNameAndFeaturestore(featurestore, storageConnectorName);
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Unrecognized storage connector type " + (Object)((Object)featurestoreStorageConnectorType) + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.REDSHIFT) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC));
    }

    public FeaturestoreStorageConnectorDTO createStorageConnectorWithType(Users user, Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType, FeaturestoreStorageConnectorDTO featurestoreStorageConnectorDTO) throws FeaturestoreException, UserException, ProjectException {
        this.validateUser(user, featurestore);
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.createFeaturestoreS3Connector(user, featurestore, (FeaturestoreS3ConnectorDTO)featurestoreStorageConnectorDTO);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.createFeaturestoreJdbcConnector(featurestore, (FeaturestoreJdbcConnectorDTO)featurestoreStorageConnectorDTO);
            }
            case REDSHIFT: {
                return this.featurestoreRedshiftConnectorController.createFeaturestoreRedshiftConnector(user, featurestore, (FeaturestoreRedshiftConnectorDTO)featurestoreStorageConnectorDTO);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.createFeaturestoreHopsfsConnector(featurestore, (FeaturestoreHopsfsConnectorDTO)featurestoreStorageConnectorDTO);
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Unrecognized storage connector type " + (Object)((Object)featurestoreStorageConnectorType) + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.REDSHIFT) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC));
    }

    public FeaturestoreStorageConnectorDTO updateStorageConnectorWithType(Users user, Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType, FeaturestoreStorageConnectorDTO featurestoreStorageConnectorDTO, String storageConnectorName) throws FeaturestoreException, UserException, ProjectException {
        this.validateUser(user, featurestore);
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.updateFeaturestoreS3Connector(user, featurestore, (FeaturestoreS3ConnectorDTO)featurestoreStorageConnectorDTO, storageConnectorName);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.updateFeaturestoreJdbcConnector(featurestore, (FeaturestoreJdbcConnectorDTO)featurestoreStorageConnectorDTO, storageConnectorName);
            }
            case REDSHIFT: {
                return this.featurestoreRedshiftConnectorController.updateFeaturestoreRedshiftConnector(user, featurestore, (FeaturestoreRedshiftConnectorDTO)featurestoreStorageConnectorDTO, storageConnectorName);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.updateFeaturestoreHopsfsConnector(featurestore, (FeaturestoreHopsfsConnectorDTO)featurestoreStorageConnectorDTO, storageConnectorName);
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Unrecognized storage connector type " + (Object)((Object)featurestoreStorageConnectorType) + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.REDSHIFT) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC));
    }

    public void deleteStorageConnectorWithTypeAndId(Users user, FeaturestoreStorageConnectorType featurestoreStorageConnectorType, Integer storageConnectorId, Featurestore featurestore) throws FeaturestoreException, UserException, ProjectException {
        this.validateUser(user, featurestore);
        switch (featurestoreStorageConnectorType) {
            case S3: {
                this.featurestoreS3ConnectorController.removeFeaturestoreS3Connector(user, storageConnectorId);
                break;
            }
            case JDBC: {
                this.featurestoreJdbcConnectorController.removeFeaturestoreJdbcConnector(storageConnectorId);
                break;
            }
            case REDSHIFT: {
                this.featurestoreRedshiftConnectorController.removeFeaturestoreRedshiftConnector(user, storageConnectorId);
                break;
            }
            case HOPSFS: {
                this.featurestoreHopsfsConnectorController.removeFeaturestoreHopsfsConnector(storageConnectorId);
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Unrecognized storage connector type " + (Object)((Object)featurestoreStorageConnectorType) + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.REDSHIFT) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC));
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturestoreJdbcConnectorDTO getOnlineFeaturestoreConnector(Users user, String dbUsername, Featurestore featurestore) throws FeaturestoreException {
        String onlineFeaturestoreConnectorName = dbUsername + "_onlinefeaturestore";
        return (FeaturestoreJdbcConnectorDTO)this.getAllStorageConnectorsForFeaturestoreWithType(user, featurestore, FeaturestoreStorageConnectorType.JDBC).stream().filter(dto -> dto.getName().equalsIgnoreCase(onlineFeaturestoreConnectorName)).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ONLINE_FEATURESTORE_JDBC_CONNECTOR_NOT_FOUND, Level.SEVERE, "Cannot get online featurestore JDBC connector"));
    }

    private void validateUser(Users user, Featurestore featurestore) throws UserException {
        String userRole = this.projectTeamFacade.findCurrentRole(featurestore.getProject(), user);
        if (userRole == null || !userRole.equalsIgnoreCase("Data owner")) {
            throw new UserException(RESTCodes.UserErrorCode.ACCESS_CONTROL, Level.FINE, "Action not allowed. User " + user.getUsername() + " is not member of project ");
        }
    }

    public void deleteStorageConnectorWithTypeAndName(Users user, FeaturestoreStorageConnectorType connectorType, String connectorName, Featurestore featurestore) throws FeaturestoreException, UserException, ProjectException {
        this.validateUser(user, featurestore);
        switch (connectorType) {
            case S3: {
                this.featurestoreS3ConnectorController.removeFeaturestoreS3Connector(user, featurestore, connectorName);
                break;
            }
            case JDBC: {
                this.featurestoreJdbcConnectorController.removeFeaturestoreJdbcConnector(connectorName, featurestore);
                break;
            }
            case REDSHIFT: {
                this.featurestoreRedshiftConnectorController.removeFeaturestoreRedshiftConnector(user, connectorName, featurestore);
                break;
            }
            case HOPSFS: {
                this.featurestoreHopsfsConnectorController.removeFeaturestoreHopsfsConnector(connectorName, featurestore);
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Unrecognized storage connector type " + (Object)((Object)connectorType) + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.REDSHIFT) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC));
            }
        }
    }
}

