/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.redshift.FeaturestoreRedshiftConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlSeeAlso(value={FeaturestoreHopsfsConnectorDTO.class, FeaturestoreJdbcConnectorDTO.class, FeaturestoreRedshiftConnectorDTO.class, FeaturestoreS3ConnectorDTO.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FeaturestoreHopsfsConnectorDTO.class, name="FeaturestoreJobDTO"), @JsonSubTypes.Type(value=FeaturestoreJdbcConnectorDTO.class, name="FeaturestoreJdbcConnectorDTO"), @JsonSubTypes.Type(value=FeaturestoreRedshiftConnectorDTO.class, name="FeaturestoreRedshiftConnectorDTO"), @JsonSubTypes.Type(value=FeaturestoreS3ConnectorDTO.class, name="FeaturestoreS3ConnectorDTO")})
public class FeaturestoreStorageConnectorDTO {
    private Integer id;
    private String description;
    private String name;
    private Integer featurestoreId;
    private FeaturestoreStorageConnectorType storageConnectorType;

    public FeaturestoreStorageConnectorDTO() {
    }

    public FeaturestoreStorageConnectorDTO(Integer id, String description, String name, Integer featurestoreId, FeaturestoreStorageConnectorType featurestoreStorageConnectorType) {
        this.id = id;
        this.description = description;
        this.name = name;
        this.featurestoreId = featurestoreId;
        this.storageConnectorType = featurestoreStorageConnectorType;
    }

    @XmlElement
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public Integer getFeaturestoreId() {
        return this.featurestoreId;
    }

    public void setFeaturestoreId(Integer featurestoreId) {
        this.featurestoreId = featurestoreId;
    }

    @XmlElement
    public FeaturestoreStorageConnectorType getStorageConnectorType() {
        return this.storageConnectorType;
    }

    public void setStorageConnectorType(FeaturestoreStorageConnectorType storageConnectorType) {
        this.storageConnectorType = storageConnectorType;
    }

    public void verifyName() throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)this.name)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_NAME + ", the storage connector name cannot be empty");
        }
        if (this.name.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_NAME + ", the name should be less than " + 1000 + " characters, the provided name was: " + this.name);
        }
    }

    public void verifyDescription() throws FeaturestoreException {
        if (this.description != null && this.description.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_DESCRIPTION + ", the description should be less than: " + 1000);
        }
    }

    public String toString() {
        return "FeaturestoreStorageConnectorDTO{id=" + this.id + ", description='" + this.description + '\'' + ", name='" + this.name + '\'' + ", featurestoreId=" + this.featurestoreId + ", storageConnectorType=" + (Object)((Object)this.storageConnectorType) + '}';
    }
}

