/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorFacade;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnector;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreHopsfsConnectorController {
    @EJB
    private FeaturestoreHopsfsConnectorFacade featurestoreHopsfsConnectorFacade;
    @EJB
    private InodeController inodeController;
    @EJB
    private DatasetController datasetController;

    public FeaturestoreHopsfsConnectorDTO createFeaturestoreHopsfsConnector(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO) throws FeaturestoreException {
        this.verifyUserInput(featurestore, featurestoreHopsfsConnectorDTO);
        Dataset dataset = this.datasetController.getByProjectAndDsName(featurestore.getProject(), null, featurestoreHopsfsConnectorDTO.getDatasetName());
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = new FeaturestoreHopsfsConnector();
        featurestoreHopsfsConnector.setName(featurestoreHopsfsConnectorDTO.getName());
        featurestoreHopsfsConnector.setDescription(featurestoreHopsfsConnectorDTO.getDescription());
        featurestoreHopsfsConnector.setHopsfsDataset(dataset);
        featurestoreHopsfsConnector.setFeaturestore(featurestore);
        this.featurestoreHopsfsConnectorFacade.persist(featurestoreHopsfsConnector);
        return this.convertHopsfsConnectorToDTO(featurestoreHopsfsConnector);
    }

    public FeaturestoreHopsfsConnectorDTO updateFeaturestoreHopsfsConnector(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO, String storageConnectorName) throws FeaturestoreException {
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = this.verifyHopsfStorageConnectorName(featurestore, storageConnectorName);
        if (!Strings.isNullOrEmpty((String)featurestoreHopsfsConnectorDTO.getDatasetName())) {
            this.verifyHopsfsConnectorDatasetName(featurestoreHopsfsConnectorDTO.getDatasetName(), featurestore);
            Dataset dataset = this.datasetController.getByProjectAndDsName(featurestore.getProject(), null, featurestoreHopsfsConnectorDTO.getDatasetName());
            featurestoreHopsfsConnector.setHopsfsDataset(dataset);
        }
        if (!Strings.isNullOrEmpty((String)featurestoreHopsfsConnectorDTO.getName())) {
            this.verifyHopsfsConnectorName(featurestoreHopsfsConnectorDTO.getName(), featurestore, true);
            featurestoreHopsfsConnector.setName(featurestoreHopsfsConnectorDTO.getName());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreHopsfsConnectorDTO.getDescription())) {
            this.verifyHopsfsConnectorDescription(featurestoreHopsfsConnectorDTO.getDescription());
            featurestoreHopsfsConnector.setDescription(featurestoreHopsfsConnectorDTO.getDescription());
        }
        if (featurestore != null) {
            featurestoreHopsfsConnector.setFeaturestore(featurestore);
        }
        FeaturestoreHopsfsConnector updatedFeaturestoreHopsfsConnector = this.featurestoreHopsfsConnectorFacade.updateHopsfsConnector(featurestoreHopsfsConnector);
        return this.convertHopsfsConnectorToDTO(updatedFeaturestoreHopsfsConnector);
    }

    public void createHopsFsBackendForFeaturestoreConnector(Featurestore featurestore, Dataset hopsfsDataset) throws FeaturestoreException {
        String name = hopsfsDataset.getName();
        String description = "HOPSFS backend for storing Training Datasets of the Hopsworks Feature Store";
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO();
        featurestoreHopsfsConnectorDTO.setName(name);
        featurestoreHopsfsConnectorDTO.setDescription(description);
        featurestoreHopsfsConnectorDTO.setDatasetName(hopsfsDataset.getName());
        this.createFeaturestoreHopsfsConnector(featurestore, featurestoreHopsfsConnectorDTO);
    }

    public void removeFeaturestoreHopsfsConnector(Integer featurestoreHopsfsId) {
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = (FeaturestoreHopsfsConnector)this.featurestoreHopsfsConnectorFacade.find(featurestoreHopsfsId);
        if (featurestoreHopsfsConnector != null) {
            this.featurestoreHopsfsConnectorFacade.remove(featurestoreHopsfsConnector);
        }
    }

    public void removeFeaturestoreHopsfsConnector(String featurestoreHopsfsName, Featurestore featurestore) {
        Optional<FeaturestoreHopsfsConnector> featurestoreHopsfsConnector = this.featurestoreHopsfsConnectorFacade.findByNameAndFeaturestore(featurestoreHopsfsName, featurestore);
        if (featurestoreHopsfsConnector.isPresent()) {
            this.featurestoreHopsfsConnectorFacade.remove(featurestoreHopsfsConnector.get());
        }
    }

    private FeaturestoreHopsfsConnector verifyHopsfStorageConnectorName(Featurestore featurestore, String storageConnectorName) throws FeaturestoreException {
        return this.featurestoreHopsfsConnectorFacade.findByNameAndFeaturestore(storageConnectorName, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HopsFs Connector not found HopsFsConnector name: " + storageConnectorName));
    }

    private void verifyHopsfsConnectorName(String name, Featurestore featurestore, Boolean edit) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "Illegal storage connector name, the storage connector name cannot be empty");
        }
        if (name.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "Illegal storage connector name, the name should be less than 1000 characters.");
        }
        if (!edit.booleanValue() && featurestore.getHopsfsConnections().stream().anyMatch(hopsfsCon -> hopsfsCon.getName().equalsIgnoreCase(name))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "Illegal storage connector name, the storage connector name should be unique, there already exists a HOPSFS connector with the same name ");
        }
    }

    private void verifyFeaturestoreInput(Featurestore featurestore) {
        if (featurestore == null) {
            throw new IllegalArgumentException("Featurestore was not found");
        }
    }

    private void verifyHopsfsConnectorDescription(String description) throws FeaturestoreException {
        if (description.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_DESCRIPTION, Level.FINE, "Illegal storage connector description, the description should be less than: 1000");
        }
    }

    private void verifyHopsfsConnectorDatasetName(String datasetName, Featurestore featurestore) throws FeaturestoreException {
        Dataset dataset = this.datasetController.getByProjectAndDsName(featurestore.getProject(), null, datasetName);
        if (dataset == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_HOPSFS_CONNECTOR_DATASET, Level.FINE, "Illegal Hopsfs connector dataset, the dataset could not be found");
        }
    }

    private void verifyUserInput(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO) throws FeaturestoreException {
        if (featurestoreHopsfsConnectorDTO == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        this.verifyFeaturestoreInput(featurestore);
        this.verifyHopsfsConnectorName(featurestoreHopsfsConnectorDTO.getName(), featurestore, false);
        this.verifyHopsfsConnectorDescription(featurestoreHopsfsConnectorDTO.getDescription());
        this.verifyHopsfsConnectorDatasetName(featurestoreHopsfsConnectorDTO.getDatasetName(), featurestore);
    }

    public List<FeaturestoreStorageConnectorDTO> getHopsfsConnectors(Featurestore featurestore) {
        List<FeaturestoreHopsfsConnector> hopsfsConnectors = this.featurestoreHopsfsConnectorFacade.findByFeaturestore(featurestore);
        return hopsfsConnectors.stream().map(hopsfsConnector -> this.convertHopsfsConnectorToDTO((FeaturestoreHopsfsConnector)hopsfsConnector)).collect(Collectors.toList());
    }

    public FeaturestoreStorageConnectorDTO getHopsFsConnectorWithNameAndFeaturestore(Featurestore featurestore, String storageConnectorName) throws FeaturestoreException {
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = this.verifyHopsfStorageConnectorName(featurestore, storageConnectorName);
        return this.convertHopsfsConnectorToDTO(featurestoreHopsfsConnector);
    }

    public FeaturestoreHopsfsConnector getDefaultStorageConnector(Featurestore featurestore) throws FeaturestoreException {
        String connectorName = featurestore.getProject().getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
        return this.featurestoreHopsfsConnectorFacade.findByNameAndFeaturestore(connectorName, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "Could not find default storage connector: " + connectorName));
    }

    private FeaturestoreHopsfsConnectorDTO convertHopsfsConnectorToDTO(FeaturestoreHopsfsConnector featurestoreHopsfsConnector) {
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO(featurestoreHopsfsConnector);
        featurestoreHopsfsConnectorDTO.setHopsfsPath(this.inodeController.getPath(featurestoreHopsfsConnector.getHopsfsDataset().getInode()));
        return featurestoreHopsfsConnectorDTO;
    }
}

