/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.jdbc;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorFacade;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreJdbcConnectorController {
    @EJB
    private FeaturestoreJdbcConnectorFacade featurestoreJdbcConnectorFacade;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private HiveController hiveController;
    @EJB
    private Settings settings;
    @EJB
    private SecretsController secretsController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreJdbcConnectorController.class.getName());

    public FeaturestoreJdbcConnectorDTO createFeaturestoreJdbcConnector(Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException {
        this.verifyUserInput(featurestore, featurestoreJdbcConnectorDTO);
        FeaturestoreJdbcConnector featurestoreJdbcConnector = new FeaturestoreJdbcConnector();
        featurestoreJdbcConnector.setName(featurestoreJdbcConnectorDTO.getName());
        featurestoreJdbcConnector.setDescription(featurestoreJdbcConnectorDTO.getDescription());
        featurestoreJdbcConnector.setFeaturestore(featurestore);
        featurestoreJdbcConnector.setArguments(featurestoreJdbcConnectorDTO.getArguments());
        featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        this.featurestoreJdbcConnectorFacade.persist(featurestoreJdbcConnector);
        return new FeaturestoreJdbcConnectorDTO(featurestoreJdbcConnector);
    }

    public FeaturestoreJdbcConnectorDTO updateFeaturestoreJdbcConnector(Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, String storageConnectorName) throws FeaturestoreException {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = this.verifyJdbcConnectorName(storageConnectorName, featurestore);
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getName())) {
            this.verifyJdbcConnectorName(featurestoreJdbcConnectorDTO, featurestore, true);
            featurestoreJdbcConnector.setName(featurestoreJdbcConnectorDTO.getName());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getDescription())) {
            featurestoreJdbcConnectorDTO.verifyDescription();
            featurestoreJdbcConnector.setDescription(featurestoreJdbcConnectorDTO.getDescription());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getConnectionString())) {
            this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
            featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getArguments())) {
            this.verifyJdbcConnectorArguments(featurestoreJdbcConnectorDTO.getArguments());
            featurestoreJdbcConnector.setArguments(featurestoreJdbcConnectorDTO.getArguments());
        }
        if (featurestore != null) {
            featurestoreJdbcConnector.setFeaturestore(featurestore);
        }
        FeaturestoreJdbcConnector updatedConnector = this.featurestoreJdbcConnectorFacade.updateJdbcConnector(featurestoreJdbcConnector);
        return new FeaturestoreJdbcConnectorDTO(updatedConnector);
    }

    public void createDefaultJdbcConnectorForOfflineFeaturestore(Featurestore featurestore, String databaseName, String description) throws FeaturestoreException {
        try {
            String hiveEndpoint = this.hiveController.getHiveServerInternalEndpoint();
            String connectionString = "jdbc:hive2://" + hiveEndpoint + "/" + databaseName + ";auth=noSasl;ssl=true;twoWay=true;";
            String arguments = "sslTrustStore,trustStorePassword,sslKeyStore,keyStorePassword";
            FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO();
            featurestoreJdbcConnectorDTO.setName(databaseName);
            featurestoreJdbcConnectorDTO.setDescription(description);
            featurestoreJdbcConnectorDTO.setConnectionString(connectionString);
            featurestoreJdbcConnectorDTO.setArguments(arguments);
            this.createFeaturestoreJdbcConnector(featurestore, featurestoreJdbcConnectorDTO);
        }
        catch (ServiceDiscoveryException ex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.JDBC_CONNECTOR_NOT_FOUND, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
        }
    }

    public void removeFeaturestoreJdbcConnector(Integer featurestoreJdbcId) {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = (FeaturestoreJdbcConnector)this.featurestoreJdbcConnectorFacade.find(featurestoreJdbcId);
        if (featurestoreJdbcConnector != null) {
            this.featurestoreJdbcConnectorFacade.remove(featurestoreJdbcConnector);
        }
    }

    public void removeFeaturestoreJdbcConnector(String featurestoreJdbcName, Featurestore featurestore) {
        Optional<FeaturestoreJdbcConnector> featurestoreJdbcConnector = this.featurestoreJdbcConnectorFacade.findByNameAndFeaturestore(featurestoreJdbcName, featurestore);
        featurestoreJdbcConnector.ifPresent(jdbcConnector -> this.featurestoreJdbcConnectorFacade.remove(jdbcConnector));
    }

    private FeaturestoreJdbcConnector verifyJdbcConnectorName(String jdbcConnectorName, Featurestore featurestore) throws FeaturestoreException {
        return this.featurestoreJdbcConnectorFacade.findByNameAndFeaturestore(jdbcConnectorName, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.JDBC_CONNECTOR_NOT_FOUND, Level.FINE, "jdbcConnector name: " + jdbcConnectorName));
    }

    private void verifyJdbcConnectorName(FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, Featurestore featurestore, Boolean edit) throws FeaturestoreException {
        featurestoreJdbcConnectorDTO.verifyName();
        if (!edit.booleanValue() && this.featurestoreJdbcConnectorFacade.findByNameAndFeaturestore(featurestoreJdbcConnectorDTO.getName(), featurestore).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name should be unique, there already exists a JDBC connector with the same name ");
        }
    }

    private void verifyJdbcConnectorConnectionString(String connectionString) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)connectionString) || connectionString.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_STRING, Level.FINE, ", the JDBC connection string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyJdbcConnectorArguments(String arguments) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)arguments) && arguments.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_ARGUMENTS, Level.FINE, "Illegal JDBC Connection Arguments, the JDBC connection arguments should not exceed: 2000 characters");
        }
    }

    private void verifyUserInput(Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException {
        if (featurestoreJdbcConnectorDTO == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        this.verifyJdbcConnectorName(featurestoreJdbcConnectorDTO, featurestore, false);
        featurestoreJdbcConnectorDTO.verifyDescription();
        this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        this.verifyJdbcConnectorArguments(featurestoreJdbcConnectorDTO.getArguments());
    }

    public List<FeaturestoreStorageConnectorDTO> getJdbcConnectorsForFeaturestore(Users user, Featurestore featurestore) throws FeaturestoreException {
        ArrayList<FeaturestoreStorageConnectorDTO> jdbcConnectorDTOs = new ArrayList<FeaturestoreStorageConnectorDTO>();
        List<FeaturestoreJdbcConnector> jdbcConnectors = this.featurestoreJdbcConnectorFacade.findByFeaturestore(featurestore);
        for (FeaturestoreJdbcConnector jdbcConnector : jdbcConnectors) {
            FeaturestoreJdbcConnectorDTO jdbcConnectorDTO = this.replaceOnlineFsConnectorUrl(new FeaturestoreJdbcConnectorDTO(jdbcConnector));
            String userOnlineConnectorName = this.onlineFeaturestoreController.onlineDbUsername(featurestore.getProject(), user) + "_onlinefeaturestore";
            if (jdbcConnectorDTO.getName().equals(userOnlineConnectorName)) {
                this.setPasswordPlainTextForOnlineJdbcConnector(user, jdbcConnectorDTO, featurestore.getProject().getName());
            }
            jdbcConnectorDTOs.add(jdbcConnectorDTO);
        }
        return jdbcConnectorDTOs;
    }

    private FeaturestoreJdbcConnectorDTO getJdbcConnectorDTO(Users user, Featurestore featurestore, FeaturestoreJdbcConnector featurestoreJdbcConnector) throws FeaturestoreException {
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO(featurestoreJdbcConnector);
        if (featurestoreJdbcConnectorDTO.getName().equals(this.onlineFeaturestoreController.onlineDbUsername(featurestore.getProject(), user) + "_onlinefeaturestore")) {
            this.setPasswordPlainTextForOnlineJdbcConnector(user, featurestoreJdbcConnectorDTO, featurestore.getProject().getName());
        }
        return this.replaceOnlineFsConnectorUrl(new FeaturestoreJdbcConnectorDTO(featurestoreJdbcConnector));
    }

    public FeaturestoreJdbcConnectorDTO createJdbcConnectorForOnlineFeaturestore(String onlineDbUsername, Featurestore featurestore, String dbName) throws FeaturestoreException {
        String connectorName = onlineDbUsername + "_onlinefeaturestore";
        if (this.featurestoreJdbcConnectorFacade.findByNameAndFeaturestore(connectorName, featurestore).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "Illegal storage connector name, a storage connector with that name already exists");
        }
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO();
        featurestoreJdbcConnectorDTO.setConnectionString(this.settings.getFeaturestoreJdbcUrl() + dbName + "?useSSL=false&allowPublicKeyRetrieval=true");
        featurestoreJdbcConnectorDTO.setDescription("JDBC connection to Hopsworks Project Online Feature Store NDB Database for user: " + onlineDbUsername);
        featurestoreJdbcConnectorDTO.setArguments("password=<SECRETPASSWORD>,user=" + onlineDbUsername + ",isolationLevel=NONE,batchsize=500");
        featurestoreJdbcConnectorDTO.setStorageConnectorType(FeaturestoreStorageConnectorType.JDBC);
        featurestoreJdbcConnectorDTO.setName(connectorName);
        featurestoreJdbcConnectorDTO.setFeaturestoreId(featurestore.getId());
        return this.createFeaturestoreJdbcConnector(featurestore, featurestoreJdbcConnectorDTO);
    }

    private String getConnectorPlainPasswordFromSecret(Users user, String projectName) {
        String secretName = projectName.concat("_").concat(user.getUsername());
        try {
            SecretPlaintext plaintext = this.secretsController.get(user, secretName);
            return plaintext.getPlaintext();
        }
        catch (UserException e) {
            LOGGER.log(Level.SEVERE, "Could not get the online jdbc connector password for project: " + projectName + ", user: " + user.getEmail());
            return null;
        }
    }

    private void setPasswordPlainTextForOnlineJdbcConnector(Users user, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, String projectName) {
        String connectorPassword = this.getConnectorPlainPasswordFromSecret(user, projectName);
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getArguments()) && !Strings.isNullOrEmpty((String)connectorPassword)) {
            featurestoreJdbcConnectorDTO.setArguments(featurestoreJdbcConnectorDTO.getArguments().replaceFirst("<SECRETPASSWORD>", connectorPassword));
        }
    }

    private FeaturestoreJdbcConnectorDTO replaceOnlineFsConnectorUrl(FeaturestoreJdbcConnectorDTO jdbcConnectorDTO) throws FeaturestoreException {
        String connectionString = "";
        try {
            connectionString = jdbcConnectorDTO.getConnectionString().replace(this.serviceDiscoveryController.constructServiceFQDN(ServiceDiscoveryController.HopsworksService.ONLINEFS_MYSQL), this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.ONLINEFS_MYSQL).getAddress());
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error resolving MySQL DNS name", e.getMessage(), (Throwable)e);
        }
        jdbcConnectorDTO.setConnectionString(connectionString);
        return jdbcConnectorDTO;
    }

    public FeaturestoreStorageConnectorDTO getJdbcConnectorWithNameAndFeaturestore(Users user, Featurestore featurestore, String storageConnectorName) throws FeaturestoreException {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = this.verifyJdbcConnectorName(storageConnectorName, featurestore);
        return this.getJdbcConnectorDTO(user, featurestore, featurestoreJdbcConnector);
    }
}

