/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorFacade;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3ConnectorAccessAndSecretKey;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3ConnectorEncryptionAlgorithm;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreS3ConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreS3ConnectorController.class.getName());
    @EJB
    private FeaturestoreS3ConnectorFacade featurestoreS3ConnectorFacade;
    @EJB
    private Settings settings;
    @EJB
    private SecretsController secretsController;
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private UserFacade userFacade;

    public FeaturestoreS3ConnectorDTO createFeaturestoreS3Connector(Users user, Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException, UserException, ProjectException {
        FeaturestoreS3ConnectorEncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
        this.verifyUserInput(featurestore, featurestoreS3ConnectorDTO);
        FeaturestoreS3Connector featurestoreS3Connector = new FeaturestoreS3Connector();
        featurestoreS3Connector.setDescription(featurestoreS3ConnectorDTO.getDescription());
        featurestoreS3Connector.setName(featurestoreS3ConnectorDTO.getName());
        featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
        featurestoreS3Connector.setFeaturestore(featurestore);
        featurestoreS3Connector.setServerEncryptionAlgorithm(encryptionAlgorithm);
        featurestoreS3Connector.setServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
        featurestoreS3Connector.setIamRole(featurestoreS3ConnectorDTO.getIamRole());
        this.setSecret(user, featurestoreS3ConnectorDTO, featurestoreS3Connector, featurestore);
        this.featurestoreS3ConnectorFacade.persist(featurestoreS3Connector);
        FeaturestoreS3ConnectorDTO createdFeaturestoreS3ConnectorDTO = new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
        createdFeaturestoreS3ConnectorDTO.setAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
        createdFeaturestoreS3ConnectorDTO.setSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        return createdFeaturestoreS3ConnectorDTO;
    }

    private void setSecret(Users user, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, FeaturestoreS3Connector featurestoreS3Connector, Featurestore featurestore) throws UserException, ProjectException {
        if (this.keysNotNullOrEmpty(featurestoreS3ConnectorDTO)) {
            String jsonSecretString = this.createS3AccessAndSecretKeysSecret(featurestoreS3ConnectorDTO.getAccessKey(), featurestoreS3ConnectorDTO.getSecretKey());
            String secretName = this.createSecretName(featurestore.getId(), featurestoreS3ConnectorDTO.getName());
            Integer projectId = featurestore.getProject().getId();
            Secret secret = this.secretsController.createSecretForProject(user, secretName, jsonSecretString, projectId);
            featurestoreS3Connector.setSecret(secret);
        }
    }

    private String createSecretName(Integer featurestoreId, String connectorName) {
        return "s3_" + connectorName.replaceAll(" ", "_").toLowerCase() + "_" + featurestoreId;
    }

    public FeaturestoreS3ConnectorDTO updateFeaturestoreS3Connector(Users user, Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, String storageConnectorName) throws FeaturestoreException, UserException, ProjectException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyS3ConnectorName(storageConnectorName, featurestore);
        FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTOExisting = this.getS3ConnectorWithIdAndFeaturestore(user, featurestoreS3Connector);
        boolean updated = false;
        if (this.shouldUpdate(featurestoreS3ConnectorDTOExisting.getName(), featurestoreS3ConnectorDTO.getName())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Can not update connector name.");
        }
        if (this.shouldUpdate(featurestoreS3ConnectorDTOExisting.getDescription(), featurestoreS3ConnectorDTO.getDescription())) {
            featurestoreS3ConnectorDTO.verifyDescription();
            featurestoreS3Connector.setDescription(featurestoreS3ConnectorDTO.getDescription());
            updated = true;
        }
        if (this.shouldUpdate(featurestoreS3ConnectorDTOExisting.getBucket(), featurestoreS3ConnectorDTO.getBucket())) {
            this.verifyS3ConnectorBucket(featurestoreS3ConnectorDTO.getBucket());
            featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
            updated = true;
        }
        if (this.shouldUpdate(featurestoreS3ConnectorDTOExisting.getIamRole(), featurestoreS3ConnectorDTO.getIamRole())) {
            featurestoreS3Connector.setIamRole(featurestoreS3ConnectorDTO.getIamRole());
            updated = true;
        }
        Secret secret = null;
        if (this.shouldUpdate(featurestoreS3ConnectorDTOExisting.getAccessKey(), featurestoreS3ConnectorDTO.getAccessKey()) || this.shouldUpdate(featurestoreS3ConnectorDTOExisting.getSecretKey(), featurestoreS3ConnectorDTO.getSecretKey())) {
            secret = this.updateSecret(user, featurestoreS3ConnectorDTO, featurestore, featurestoreS3Connector);
            updated = true;
        }
        if (this.shouldUpdate(featurestoreS3ConnectorDTOExisting.getServerEncryptionAlgorithm(), featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm())) {
            if (featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm() != null) {
                FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
                featurestoreS3Connector.setServerEncryptionAlgorithm(serverEncryptionAlgorithm);
                if (serverEncryptionAlgorithm != null && serverEncryptionAlgorithm.isRequiresKey()) {
                    this.verifyS3ConnectorServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
                    featurestoreS3Connector.setServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
                } else {
                    featurestoreS3Connector.setServerEncryptionKey(null);
                }
            } else {
                if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getServerEncryptionKey())) {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, "Illegal server encryption algorithm, encryption algorithm not provided");
                }
                featurestoreS3Connector.setServerEncryptionAlgorithm(null);
                featurestoreS3Connector.setServerEncryptionKey(null);
            }
            updated = true;
        }
        if (updated) {
            this.verifyKeyAndIAMRole(featurestoreS3Connector.getIamRole(), featurestoreS3Connector.getSecret());
            featurestoreS3Connector = this.featurestoreS3ConnectorFacade.updateS3Connector(featurestoreS3Connector);
            if (featurestoreS3Connector.getSecret() == null && secret != null) {
                this.secretsFacade.deleteSecret(secret.getId());
            }
            featurestoreS3ConnectorDTOExisting = this.getS3ConnectorWithIdAndFeaturestore(user, featurestoreS3Connector);
        }
        return featurestoreS3ConnectorDTOExisting;
    }

    private void verifyKeyAndIAMRole(String iamRole, Secret secret) throws FeaturestoreException {
        boolean needPassword;
        boolean bl = needPassword = !this.settings.isIAMRoleConfigured() && Strings.isNullOrEmpty((String)iamRole);
        if (needPassword && secret == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "S3 Access Keys are not set.");
        }
        if (!needPassword && secret != null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "S3 Access Keys are not allowed");
        }
    }

    private Secret updateSecret(Users user, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, Featurestore featurestore, FeaturestoreS3Connector featurestoreS3Connector) throws UserException, FeaturestoreException, ProjectException {
        Secret secret = featurestoreS3Connector.getSecret();
        if (secret != null) {
            this.secretsController.checkCanAccessSecret(secret, user);
        }
        if (secret == null && this.keysNotNullOrEmpty(featurestoreS3ConnectorDTO)) {
            this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
            this.setSecret(user, featurestoreS3ConnectorDTO, featurestoreS3Connector, featurestore);
        } else if (this.keysNotNullOrEmpty(featurestoreS3ConnectorDTO)) {
            try {
                this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
                this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
                String jsonSecretString = this.createS3AccessAndSecretKeysSecret(featurestoreS3ConnectorDTO.getAccessKey(), featurestoreS3ConnectorDTO.getSecretKey());
                secret.setSecret(this.secretsController.encryptSecret(jsonSecretString));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secret.getId().getName(), (Throwable)e);
            }
        } else {
            featurestoreS3Connector.setSecret(null);
        }
        return secret;
    }

    private boolean shouldUpdate(String oldVal, String newVal) {
        return oldVal == null && newVal != null || oldVal != null && !oldVal.equals(newVal);
    }

    private boolean keysNotNullOrEmpty(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) {
        return !Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getSecretKey()) && !Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getAccessKey());
    }

    public void removeFeaturestoreS3Connector(Users user, Integer featurestoreS3Id) throws ProjectException {
        FeaturestoreS3Connector featurestoreS3Connector = (FeaturestoreS3Connector)this.featurestoreS3ConnectorFacade.find(featurestoreS3Id);
        if (featurestoreS3Connector != null) {
            Secret secret = featurestoreS3Connector.getSecret();
            this.secretsController.checkCanAccessSecret(secret, user);
            this.featurestoreS3ConnectorFacade.remove(featurestoreS3Connector);
            if (secret != null) {
                this.secretsFacade.deleteSecret(secret.getId());
            }
        }
    }

    public void removeFeaturestoreS3Connector(Users user, Featurestore featurestore, String storageConnectorName) throws ProjectException {
        Optional<FeaturestoreS3Connector> featurestoreS3Connector = this.featurestoreS3ConnectorFacade.findByNameAndFeaturestore(storageConnectorName, featurestore);
        if (featurestoreS3Connector.isPresent()) {
            Secret secret = featurestoreS3Connector.get().getSecret();
            this.secretsController.checkCanAccessSecret(secret, user);
            this.featurestoreS3ConnectorFacade.remove(featurestoreS3Connector.get());
            if (secret != null) {
                this.secretsFacade.deleteSecret(secret.getId());
            }
        }
    }

    private FeaturestoreS3Connector verifyS3ConnectorName(String name, Featurestore featurestore) throws FeaturestoreException {
        return this.featurestoreS3ConnectorFacade.findByNameAndFeaturestore(name, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_NOT_FOUND, Level.FINE, "S3 Connector not found, S3 connector with name: " + name));
    }

    private void verifyFeaturestore(Featurestore featurestore) {
        if (featurestore == null) {
            throw new IllegalArgumentException("Featurestore was not found");
        }
    }

    private void verifyS3ConnectorName(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, Featurestore featurestore) throws FeaturestoreException {
        featurestoreS3ConnectorDTO.verifyName();
        if (this.featurestoreS3ConnectorFacade.findByNameAndFeaturestore(featurestoreS3ConnectorDTO.getName(), featurestore).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "Illegal storage connector name, the storage connector name should be unique, there already exists a S3 connector with the same name ");
        }
    }

    private void verifyS3ConnectorBucket(String bucket) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)bucket) || bucket.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_BUCKET, Level.FINE, "Illegal S3 connector bucket, the S3 bucket string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyS3ConnectorAccessKey(String accessKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)accessKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_ACCESS_KEY, Level.FINE, "The S3 access key cannot be empty and must be less than 1000");
        }
        if (accessKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_ACCESS_KEY, Level.FINE, "Illegal S3 connector access key, the S3 access key should not exceed: 1000 characters");
        }
    }

    private void verifyS3ConnectorSecretKey(String secretKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)secretKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SECRET_KEY, Level.FINE, "The S3 secret key cannot be empty and must be less than 1000");
        }
        if (secretKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SECRET_KEY, Level.FINE, "Illegal S3 connector secret key, the S3 secret key should not exceed: 1000 characters");
        }
    }

    private void verifyS3ConnectorServerEncryptionKey(String serverEncryptionKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)serverEncryptionKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_KEY, Level.FINE, "S3 server encryption key cannot be empty");
        }
        if (serverEncryptionKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_KEY, Level.FINE, "Illegal server encryption key provided, the S3 server encryption key should not exceed: 1000 characters");
        }
    }

    private void verifyUserInput(Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        if (featurestoreS3ConnectorDTO == null) {
            throw new IllegalArgumentException("Null input data");
        }
        this.verifyFeaturestore(featurestore);
        this.verifyS3ConnectorName(featurestoreS3ConnectorDTO, featurestore);
        featurestoreS3ConnectorDTO.verifyDescription();
        this.verifyS3ConnectorBucket(featurestoreS3ConnectorDTO.getBucket());
        if (this.settings.isIAMRoleConfigured() || !Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getIamRole())) {
            this.verifySecretAndAccessKeysForIamRole(featurestoreS3ConnectorDTO);
        } else {
            this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        }
        FeaturestoreS3ConnectorEncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
        if (encryptionAlgorithm != null) {
            if (encryptionAlgorithm.isRequiresKey()) {
                this.verifyS3ConnectorServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
            } else {
                featurestoreS3ConnectorDTO.setServerEncryptionKey(null);
            }
        } else if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getServerEncryptionKey())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, "Illegal server encryption algorithm, encryption algorithm not provided");
        }
    }

    private void verifySecretAndAccessKeysForIamRole(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        if (!(!this.settings.isIAMRoleConfigured() && Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getIamRole()) || Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getAccessKey()) && Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getSecretKey()))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_KEYS_FORBIDDEN, Level.FINE, "S3 Access Keys are not allowed");
        }
        if (!this.settings.isIAMRoleConfigured() && Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getIamRole())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "S3 IAM role not set.");
        }
    }

    private FeaturestoreS3ConnectorEncryptionAlgorithm getEncryptionAlgorithm(String s) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgrithm = null;
        try {
            serverEncryptionAlgrithm = FeaturestoreS3ConnectorEncryptionAlgorithm.fromValue((String)s);
        }
        catch (IllegalArgumentException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, "Illegal server encryption algorithm provided, " + e.getMessage());
        }
        return serverEncryptionAlgrithm;
    }

    public String createS3AccessAndSecretKeysSecret(String accessKey, String secretKey) {
        return new JSONObject((Object)new FeaturestoreS3ConnectorAccessAndSecretKey(accessKey, secretKey)).toString();
    }

    public List<FeaturestoreStorageConnectorDTO> getS3ConnectorsForFeaturestore(Users user, Featurestore featurestore) {
        ArrayList<FeaturestoreStorageConnectorDTO> s3ConnectorDTOs = new ArrayList<FeaturestoreStorageConnectorDTO>();
        List<FeaturestoreS3Connector> s3Connectors = this.featurestoreS3ConnectorFacade.findByFeaturestore(featurestore);
        for (FeaturestoreS3Connector s3Connector : s3Connectors) {
            s3ConnectorDTOs.add(this.getS3ConnectorWithIdAndFeaturestore(user, s3Connector));
        }
        return s3ConnectorDTOs;
    }

    public FeaturestoreS3ConnectorDTO getS3ConnectorWithNameAndFeaturestore(Users user, Featurestore featurestore, String name) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyS3ConnectorName(name, featurestore);
        return this.getS3ConnectorWithIdAndFeaturestore(user, featurestoreS3Connector);
    }

    private FeaturestoreS3ConnectorDTO getS3ConnectorWithIdAndFeaturestore(Users user, FeaturestoreS3Connector featurestoreS3Connector) {
        FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO = new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
        if (featurestoreS3Connector.getSecret() != null) {
            FeaturestoreS3ConnectorAccessAndSecretKey accessAndSecretKey = this.getS3AccessAndSecretKeySecretForConnector(user, featurestoreS3Connector);
            this.setAccessAndSecretKeysInDTO(featurestoreS3ConnectorDTO, accessAndSecretKey);
        }
        return featurestoreS3ConnectorDTO;
    }

    private FeaturestoreS3ConnectorAccessAndSecretKey getS3AccessAndSecretKeySecretForConnector(Users user, FeaturestoreS3Connector featurestoreS3Connector) {
        Secret secret = featurestoreS3Connector.getSecret();
        FeaturestoreS3ConnectorAccessAndSecretKey featurestoreS3ConnectorAccessAndSecretKey = new FeaturestoreS3ConnectorAccessAndSecretKey();
        if (secret != null) {
            try {
                Users owner = (Users)this.userFacade.find(secret.getId().getUid());
                SecretPlaintext plainText = this.secretsController.getShared(user, owner.getUsername(), secret.getId().getName());
                featurestoreS3ConnectorAccessAndSecretKey = (FeaturestoreS3ConnectorAccessAndSecretKey)new ObjectMapper().readValue(plainText.getPlaintext(), FeaturestoreS3ConnectorAccessAndSecretKey.class);
            }
            catch (ProjectException | ServiceException | UserException | IOException throwable) {
                // empty catch block
            }
        }
        return featurestoreS3ConnectorAccessAndSecretKey;
    }

    private void setAccessAndSecretKeysInDTO(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, FeaturestoreS3ConnectorAccessAndSecretKey featurestoreS3ConnectorAccessAndSecretKey) {
        featurestoreS3ConnectorDTO.setAccessKey(featurestoreS3ConnectorAccessAndSecretKey.getAccessKey());
        featurestoreS3ConnectorDTO.setSecretKey(featurestoreS3ConnectorAccessAndSecretKey.getSecretKey());
    }
}

