/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.s3;

import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3ConnectorEncryptionAlgorithm;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class FeaturestoreS3ConnectorDTO
extends FeaturestoreStorageConnectorDTO {
    private String accessKey;
    private String secretKey;
    private String bucket;
    private String serverEncryptionAlgorithm;
    private String serverEncryptionKey;
    private String iamRole;
    private String sessionToken;

    public FeaturestoreS3ConnectorDTO() {
        super(null, null, null, null, null);
    }

    public FeaturestoreS3ConnectorDTO(FeaturestoreS3Connector featurestoreS3Connector) {
        super(featurestoreS3Connector.getId(), featurestoreS3Connector.getDescription(), featurestoreS3Connector.getName(), featurestoreS3Connector.getFeaturestore().getId(), FeaturestoreStorageConnectorType.S3);
        this.bucket = featurestoreS3Connector.getBucket();
        this.serverEncryptionAlgorithm = this.getEncryptionAlgorithmName(featurestoreS3Connector.getServerEncryptionAlgorithm());
        this.serverEncryptionKey = featurestoreS3Connector.getServerEncryptionKey();
        this.iamRole = featurestoreS3Connector.getIamRole();
    }

    private String getEncryptionAlgorithmName(FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgorithm) {
        if (serverEncryptionAlgorithm == null) {
            return null;
        }
        return serverEncryptionAlgorithm.getAlgorithm();
    }

    @XmlElement
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @XmlElement
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @XmlElement
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @XmlElement
    public String getServerEncryptionAlgorithm() {
        return this.serverEncryptionAlgorithm;
    }

    public void setServerEncryptionAlgorithm(String serverEncryptionAlgorithm) {
        this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
    }

    @XmlElement
    public String getServerEncryptionKey() {
        return this.serverEncryptionKey;
    }

    public void setServerEncryptionKey(String serverEncryptionKey) {
        this.serverEncryptionKey = serverEncryptionKey;
    }

    @XmlElement
    public String getIamRole() {
        return this.iamRole;
    }

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    @XmlElement
    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String toString() {
        return "FeaturestoreS3ConnectorDTO{accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", bucket='" + this.bucket + '\'' + ", serverEncryptionAlgorithm='" + this.serverEncryptionAlgorithm + '\'' + ", serverEncryptionKey='" + this.serverEncryptionKey + '\'' + '}';
    }
}

