/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.ondemand;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeature;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class OnDemandFeaturegroupController {
    @EJB
    private OnDemandFeaturegroupFacade onDemandFeaturegroupFacade;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private DistributedFsService distributedFsService;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private InodeController inodeController;

    public OnDemandFeaturegroup createOnDemandFeaturegroup(Featurestore featurestore, OnDemandFeaturegroupDTO onDemandFeaturegroupDTO, Project project, Users user) throws FeaturestoreException {
        FeaturestoreConnector connector = this.getStorageConnector(onDemandFeaturegroupDTO.getStorageConnector().getId());
        if (Strings.isNullOrEmpty((String)onDemandFeaturegroupDTO.getQuery())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_SQL_QUERY, Level.FINE, "SQL Query cannot be empty");
        }
        OnDemandFeaturegroup onDemandFeaturegroup = new OnDemandFeaturegroup();
        onDemandFeaturegroup.setDescription(onDemandFeaturegroupDTO.getDescription());
        onDemandFeaturegroup.setFeaturestoreConnector(connector);
        onDemandFeaturegroup.setQuery(onDemandFeaturegroupDTO.getQuery());
        onDemandFeaturegroup.setFeatures(this.convertOnDemandFeatures(onDemandFeaturegroupDTO, onDemandFeaturegroup));
        onDemandFeaturegroup.setInode(this.createFile(project, user, featurestore, onDemandFeaturegroupDTO));
        this.onDemandFeaturegroupFacade.persist(onDemandFeaturegroup);
        return onDemandFeaturegroup;
    }

    public void updateOnDemandFeaturegroupMetadata(OnDemandFeaturegroup onDemandFeaturegroup, OnDemandFeaturegroupDTO onDemandFeaturegroupDTO) throws FeaturestoreException {
        FeaturestoreConnector connector = this.getStorageConnector(onDemandFeaturegroupDTO.getStorageConnector().getId());
        onDemandFeaturegroup.setDescription(onDemandFeaturegroupDTO.getDescription());
        onDemandFeaturegroup.setFeaturestoreConnector(connector);
        this.onDemandFeaturegroupFacade.updateMetadata(onDemandFeaturegroup);
    }

    public void removeOnDemandFeaturegroup(Featurestore featurestore, Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException {
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = null;
        this.onDemandFeaturegroupFacade.remove(featuregroup.getOnDemandFeaturegroup());
        try {
            udfso = this.distributedFsService.getDfsOps(username);
            udfso.rm(this.getFilePath(featurestore, featuregroup.getName(), featuregroup.getVersion()), false);
        }
        catch (IOException | URISyntaxException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_DELETE_ON_DEMAND_FEATUREGROUP, Level.SEVERE, "Error removing the placeholder file", e.getMessage(), (Throwable)e);
        }
        finally {
            this.distributedFsService.closeDfsClient(udfso);
        }
    }

    private List<OnDemandFeature> convertOnDemandFeatures(OnDemandFeaturegroupDTO onDemandFeaturegroupDTO, OnDemandFeaturegroup onDemandFeaturegroup) {
        if (onDemandFeaturegroupDTO.getFeatures().isEmpty()) {
            throw new IllegalArgumentException("No features were provided for on demand feature group");
        }
        return onDemandFeaturegroupDTO.getFeatures().stream().map(f -> new OnDemandFeature(onDemandFeaturegroup, f.getName(), f.getType(), f.getDescription(), f.getPrimary())).collect(Collectors.toList());
    }

    private Inode createFile(Project project, Users user, Featurestore featurestore, OnDemandFeaturegroupDTO onDemandFeaturegroupDTO) throws FeaturestoreException {
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        Path path = null;
        DistributedFileSystemOps udfso = null;
        try {
            path = this.getFilePath(featurestore, onDemandFeaturegroupDTO.getName(), onDemandFeaturegroupDTO.getVersion());
            udfso = this.distributedFsService.getDfsOps(username);
            udfso.touchz(path);
            this.distributedFsService.closeDfsClient(udfso);
        }
        catch (IOException | URISyntaxException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ON_DEMAND_FEATUREGROUP, Level.SEVERE, "Error creating the placeholder file", e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.distributedFsService.closeDfsClient(udfso);
                throw throwable;
            }
        }
        return this.inodeController.getInodeAtPath(path.toString());
    }

    private Path getFilePath(Featurestore featurestore, String name, Integer version) throws URISyntaxException {
        return new Path(new URI(this.featurestoreFacade.getHiveDbHdfsPath(featurestore.getHiveDbId())).getPath(), name + "_" + version);
    }

    private FeaturestoreConnector getStorageConnector(Integer connectorId) throws FeaturestoreException {
        if (connectorId == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_ID_NOT_PROVIDED.getMessage());
        }
        return this.featurestoreConnectorFacade.findById(connectorId).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_NOT_FOUND, Level.FINE, "Connector with id: " + connectorId + " was not found"));
    }
}

