/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.metadata.db;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.metadata.EntityIntf;
import io.hops.hopsworks.persistence.entity.metadata.MTable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless
public class MTableFacade
extends AbstractFacade<MTable> {
    private static final Logger LOGGER = Logger.getLogger(MTableFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    public MTableFacade() {
        super(MTable.class);
    }

    public MTable getTable(int tableid) {
        return (MTable)this.em.find(MTable.class, (Object)tableid);
    }

    public int addTable(MTable table) {
        try {
            MTable t = this.getTable(table.getId());
            if (t != null && t.getId() != -1) {
                t.copy((EntityIntf)table);
                this.em.merge((Object)t);
            } else {
                t = table;
                t.resetFields();
                this.em.persist((Object)t);
            }
            this.em.flush();
            this.em.clear();
            return t.getId();
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not add table " + table, ex);
            throw ex;
        }
    }

    public void deleteTable(MTable table) {
        try {
            MTable t;
            MTable mTable = t = this.contains(table) ? table : this.getTable(table.getId());
            if (this.em.contains((Object)t)) {
                this.em.remove((Object)t);
            } else {
                this.em.remove(this.em.merge((Object)t));
            }
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not add table " + table, ex);
            throw ex;
        }
    }

    public boolean contains(MTable table) {
        return this.em.contains((Object)table);
    }
}

