/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidation;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.hops.hopsworks.common.featurestore.datavalidation.ConstraintGroup;
import io.hops.hopsworks.common.featurestore.datavalidation.ConstraintGroupLevel;
import io.hops.hopsworks.common.featurestore.datavalidation.ConstraintResult;
import io.hops.hopsworks.common.featurestore.datavalidation.ValidationResult;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IOUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class DataValidationController {
    private static Logger LOGGER = Logger.getLogger(DataValidationController.class.getName());
    private static final String PATH_TO_DATA_VALIDATION = "/Projects/%s/" + Settings.ServiceDataset.DATAVALIDATION.getName();
    private static final String PATH_TO_DATA_VALIDATION_RESULT = PATH_TO_DATA_VALIDATION + "/" + "%s" + "/" + "%d";
    private static final String PATH_TO_DATA_VALIDATION_RULES = PATH_TO_DATA_VALIDATION + "/" + "rules";
    private static final String PATH_TO_DATA_VALIDATION_RULES_FILE = PATH_TO_DATA_VALIDATION_RULES + "/" + "%s_%d-rules.json";
    private static final String HDFS_FILE_PATH = "hdfs://%s";
    private static final String DEFAULT_MAIN_CLASS = "io.hops.hopsworks.verification.Verification";
    @EJB
    private DistributedFsService distributedFsService;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHopsVerificationMainClass(Path jarFile) {
        String mainClass = this.settings.getHopsVerificationMainClass();
        if (mainClass != null) {
            return mainClass;
        }
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.distributedFsService.getDfsOps();
            try (JarInputStream kis = new JarInputStream((InputStream)dfso.open(jarFile));){
                String discoveredMainClass = kis.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                this.settings.setHopsVerificationMainClass(discoveredMainClass);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Could not load Main-class of: " + jarFile.toString() + " Falling back to " + DEFAULT_MAIN_CLASS);
            this.settings.setHopsVerificationMainClass(DEFAULT_MAIN_CLASS);
        }
        finally {
            if (dfso != null) {
                this.distributedFsService.closeDfsClient(dfso);
            }
        }
        return this.settings.getHopsVerificationMainClass();
    }

    public String writeRulesToFile(Users user, Project project, FeaturegroupDTO featureGroup, List<ConstraintGroup> constraintGroups) throws FeaturestoreException {
        LOGGER.log(Level.FINE, "Writing validation rules to file for feature group " + featureGroup.getName());
        String jsonRules = this.convert2deequRules(constraintGroups);
        DistributedFileSystemOps udfso = null;
        try {
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = this.distributedFsService.getDfsOps(hdfsUsername);
            Path rulesPath = this.getDataValidationRulesFilePath(project, featureGroup.getName(), featureGroup.getVersion());
            LOGGER.log(Level.FINEST, "Writing rules " + jsonRules + " to file " + rulesPath.toString());
            this.writeToHDFS(rulesPath, jsonRules, udfso);
            String string = String.format(HDFS_FILE_PATH, rulesPath.toString());
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            return string;
        }
        catch (IOException ex) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_DATA_VALIDATION_RULES, Level.WARNING, "Failed to create data validation rules", "Could not write data validation rules to HDFS", (Throwable)ex);
            }
            catch (Throwable throwable) {
                if (udfso != null) {
                    this.distributedFsService.closeDfsClient(udfso);
                }
                throw throwable;
            }
        }
    }

    public List<ConstraintGroup> readRulesForFeatureGroup(Users user, Project project, FeaturegroupDTO featureGroup) throws FeaturestoreException {
        FileStatus[] rules;
        DistributedFileSystemOps udfso;
        block21: {
            LOGGER.log(Level.FINE, "Reading rules file for feature group " + featureGroup.getName());
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = null;
            Path path2rules = new Path(String.format(PATH_TO_DATA_VALIDATION_RULES, project.getName()) + "/" + "*");
            udfso = this.distributedFsService.getDfsOps(hdfsUsername);
            GlobFilter filter = new GlobFilter(featureGroup.getName() + "_*-rules.json");
            rules = udfso.getFilesystem().globStatus(path2rules, (PathFilter)filter);
            if (rules != null && rules.length != 0) break block21;
            LOGGER.log(Level.FINE, "Did not find any validation rules for " + featureGroup.getName());
            List list = Collections.EMPTY_LIST;
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            return list;
        }
        try {
            ArrayList<ConstraintGroup> constraintGroups = new ArrayList<ConstraintGroup>();
            for (int i = 0; i < rules.length; ++i) {
                FileStatus fileStatus = rules[i];
                Path path2rule = fileStatus.getPath();
                try (FSDataInputStream inStream = udfso.open(path2rule);){
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copyBytes((InputStream)inStream, (OutputStream)out, (int)512);
                    String content = out.toString("UTF-8");
                    LOGGER.log(Level.FINEST, "Found rules " + content + " for feature group " + featureGroup.getName());
                    List<ConstraintGroup> groups = this.convertFromDeequRules(content);
                    constraintGroups.addAll(groups);
                    out.close();
                    continue;
                }
            }
            ArrayList<ConstraintGroup> arrayList = constraintGroups;
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            return arrayList;
        }
        catch (IOException ex) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_DATA_VALIDATION_RULES, Level.WARNING, "Failed to read validation rules", "Could not read validation rules from HDFS for Feature group " + featureGroup.getName(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                if (udfso != null) {
                    this.distributedFsService.closeDfsClient(udfso);
                }
                throw throwable;
            }
        }
    }

    public ValidationResult getValidationResultForFeatureGroup(Users user, Project project, FeaturegroupDTO featureGroup) throws FeaturestoreException {
        FileStatus[] resultFiles;
        DistributedFileSystemOps udfso;
        block22: {
            LOGGER.log(Level.FINE, "Fetching validation result for feature group " + featureGroup.getName());
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = null;
            Path path2result = new Path(String.format(PATH_TO_DATA_VALIDATION_RESULT, project.getName(), featureGroup.getName(), featureGroup.getVersion()) + "/" + "*");
            udfso = this.distributedFsService.getDfsOps(hdfsUsername);
            GlobFilter filter = new GlobFilter("*.json");
            resultFiles = udfso.getFilesystem().globStatus(path2result, (PathFilter)filter);
            if (resultFiles != null && resultFiles.length != 0) break block22;
            LOGGER.log(Level.FINE, "Did not find any validation result for " + featureGroup.getName());
            ValidationResult validationResult = new ValidationResult(ValidationResult.Status.Empty, Collections.EMPTY_LIST);
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            return validationResult;
        }
        try {
            ArrayList<ConstraintResult> constraintResults = new ArrayList<ConstraintResult>();
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            for (FileStatus fileStatus : resultFiles) {
                Path resultFile = fileStatus.getPath();
                try (FSDataInputStream inStream = udfso.open(resultFile);){
                    String[] constraintResultsJson;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copyBytes((InputStream)inStream, (OutputStream)out, (int)512);
                    for (String cr : constraintResultsJson = out.toString("UTF-8").split("\n")) {
                        LOGGER.log(Level.FINEST, "Found result " + cr + " for feature group " + featureGroup.getName());
                        ConstraintResult constraintResult = (ConstraintResult)gson.fromJson(cr, ConstraintResult.class);
                        constraintResults.add(constraintResult);
                    }
                }
            }
            ValidationResult validationResult = new ValidationResult();
            validationResult.setConstraintsResult(constraintResults);
            this.assignValidationResultStatus(validationResult);
            ValidationResult validationResult2 = validationResult;
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            return validationResult2;
        }
        catch (IOException ex) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_READ_DATA_VALIDATION_RESULT, Level.WARNING, "Failed to read validation result", "Failed to read validation result from HDFS for Feature group " + featureGroup.getName(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                if (udfso != null) {
                    this.distributedFsService.closeDfsClient(udfso);
                }
                throw throwable;
            }
        }
    }

    private void assignValidationResultStatus(ValidationResult validationResult) {
        int success = 0;
        int warning = 0;
        int error = 0;
        ConstraintGroupLevel level = ConstraintGroupLevel.Warning;
        for (ConstraintResult cr : validationResult.getConstraintsResult()) {
            if (cr.getCheckLevel().equals((Object)ConstraintGroupLevel.Error)) {
                level = ConstraintGroupLevel.Error;
            }
            switch (cr.getConstraintStatus()) {
                case Success: {
                    ++success;
                    break;
                }
                case Warning: {
                    ++warning;
                    break;
                }
                case Failure: {
                    ++error;
                    break;
                }
            }
        }
        if (success != 0 && warning == 0 && error == 0) {
            validationResult.setStatus(ValidationResult.Status.Success);
            return;
        }
        if (level.equals((Object)ConstraintGroupLevel.Warning)) {
            if (warning > 0 && error == 0) {
                validationResult.setStatus(ValidationResult.Status.Warning);
                return;
            }
            if (warning >= 0 && error > 0) {
                validationResult.setStatus(ValidationResult.Status.Failure);
                return;
            }
        }
        if (level.equals((Object)ConstraintGroupLevel.Error)) {
            validationResult.setStatus(ValidationResult.Status.Failure);
        }
    }

    private void writeToHDFS(Path path2file, String content, DistributedFileSystemOps udfso) throws IOException {
        try (FSDataOutputStream outStream = udfso.create(path2file);){
            outStream.writeBytes(content);
            outStream.hflush();
            LOGGER.log(Level.FINE, "Finished writing rules to file " + path2file.toString());
        }
    }

    private Path getDataValidationRulesFilePath(Project project, String featureGroupName, Integer featureGroupVersion) {
        return new Path(String.format(PATH_TO_DATA_VALIDATION_RULES_FILE, project.getName(), featureGroupName, featureGroupVersion));
    }

    private String convert2deequRules(List<ConstraintGroup> constraintGroups) {
        Gson serializer = new Gson();
        JsonObject json = new JsonObject();
        JsonArray constraintGroupsJSON = new JsonArray();
        for (ConstraintGroup constraintGroup : constraintGroups) {
            JsonElement constraintGroupJSON = serializer.toJsonTree((Object)constraintGroup);
            constraintGroupsJSON.add(constraintGroupJSON);
        }
        json.add("constraintGroups", (JsonElement)constraintGroupsJSON);
        return serializer.toJson((JsonElement)json);
    }

    private List<ConstraintGroup> convertFromDeequRules(String rules) {
        Gson deserializer = new Gson();
        JsonElement topLevelObject = (JsonElement)deserializer.fromJson(rules, JsonElement.class);
        JsonArray constraintGroupsJSON = topLevelObject.getAsJsonObject().getAsJsonArray("constraintGroups");
        ArrayList<ConstraintGroup> constraintGroups = new ArrayList<ConstraintGroup>(constraintGroupsJSON.size());
        constraintGroupsJSON.forEach(cgj -> {
            ConstraintGroup cg = (ConstraintGroup)deserializer.fromJson(cgj, ConstraintGroup.class);
            constraintGroups.add(cg);
        });
        return constraintGroups;
    }
}

