/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.ops;

import io.hops.hopsworks.common.provenance.app.ProvAParser;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.ops.ProvOps;
import io.hops.hopsworks.common.provenance.ops.ProvOpsElasticComm;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.elasticsearch.search.sort.SortOrder;
import org.javatuples.Pair;

public class ProvOpsParamBuilder {
    Map<ProvParser.Field, ProvParser.FilterVal> fileOpsFilterBy = new HashMap<ProvParser.Field, ProvParser.FilterVal>();
    List<Pair<ProvParser.Field, SortOrder>> fileOpsSortBy = new ArrayList<Pair<ProvParser.Field, SortOrder>>();
    Set<ProvParser.ElasticExpansions> expansions = new HashSet<ProvParser.ElasticExpansions>();
    Map<ProvParser.Field, ProvParser.FilterVal> appStateFilter = new HashMap<ProvParser.Field, ProvParser.FilterVal>();
    Pair<Integer, Integer> pagination = null;
    Set<ProvOpsElasticComm.Aggregations> aggregations = new HashSet<ProvOpsElasticComm.Aggregations>();

    public ProvOpsParamBuilder filterByFields(Set<String> params) throws ProvenanceException {
        if (params != null) {
            for (String param : params) {
                Pair<ProvOps.Field, Object> field = ProvOps.extractFilter(param);
                ProvParser.addToFilters(this.fileOpsFilterBy, (ProvParser.Field)field.getValue0(), field.getValue1());
            }
        }
        return this;
    }

    public ProvOpsParamBuilder filterByField(ProvOps.Field field, Object val) throws ProvenanceException {
        Object parsedVal = field.filterValParser().apply(val);
        ProvParser.addToFilters(this.fileOpsFilterBy, field, parsedVal);
        return this;
    }

    public ProvOpsParamBuilder sortByFields(List<String> params) throws ProvenanceException {
        if (params != null) {
            for (String param : params) {
                this.fileOpsSortBy.add(ProvOps.extractSort(param));
            }
        }
        return this;
    }

    public ProvOpsParamBuilder sortByField(ProvOps.Field field, SortOrder order) {
        this.fileOpsSortBy.add((Pair<ProvParser.Field, SortOrder>)Pair.with((Object)field, (Object)order));
        return this;
    }

    public ProvOpsParamBuilder paginate(Integer offset, Integer limit) {
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = Settings.PROVENANCE_ELASTIC_PAGE_DEFAULT_SIZE;
        }
        this.pagination = Pair.with((Object)offset, (Object)limit);
        return this;
    }

    public ProvOpsParamBuilder provExpansions(Set<String> params) throws ProvenanceException {
        if (params != null) {
            ProvParser.withExpansions(this.expansions, params);
        }
        return this;
    }

    public ProvOpsParamBuilder withAppExpansionFilters(Set<String> params) throws ProvenanceException {
        if (params != null) {
            for (String param : params) {
                ProvParser.addToFilters(this.appStateFilter, ProvAParser.extractFilter(param));
            }
        }
        return this;
    }

    public ProvOpsParamBuilder withAppExpansion() {
        this.expansions.add(ProvParser.ElasticExpansions.APP);
        return this;
    }

    public ProvOpsParamBuilder withAppExpansion(String appId) throws ProvenanceException {
        this.withAppExpansion();
        ProvParser.addToFilters(this.appStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvAParser.Field.APP_ID, (Object)appId));
        return this;
    }

    public boolean hasAppExpansion() {
        return this.expansions.contains((Object)ProvParser.ElasticExpansions.APP);
    }

    public ProvOpsParamBuilder withAggregation(ProvOpsElasticComm.Aggregations aggregation) {
        this.aggregations.add(aggregation);
        return this;
    }

    public ProvOpsParamBuilder aggregations(Set<String> aggregations) throws ProvenanceException {
        if (aggregations == null) {
            return this;
        }
        for (String agg : aggregations) {
            try {
                ProvOpsElasticComm.Aggregations aggregation = ProvOpsElasticComm.Aggregations.valueOf(agg);
                this.withAggregation(aggregation);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "aggregation" + agg + " not supported - supported:" + EnumSet.allOf(ProvOpsElasticComm.Aggregations.class);
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, "exception extracting aggregations");
            }
        }
        return this;
    }

    public Set<ProvOpsElasticComm.Aggregations> getAggregations() {
        return this.aggregations;
    }

    public Map<ProvParser.Field, ProvParser.FilterVal> getFileOpsFilterBy() {
        return this.fileOpsFilterBy;
    }

    public List<Pair<ProvParser.Field, SortOrder>> getFileOpsSortBy() {
        return this.fileOpsSortBy;
    }

    public Set<ProvParser.ElasticExpansions> getExpansions() {
        return this.expansions;
    }

    public Map<ProvParser.Field, ProvParser.FilterVal> getAppStateFilter() {
        return this.appStateFilter;
    }

    public Pair<Integer, Integer> getPagination() {
        return this.pagination;
    }
}

