/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.maggy;

import io.hops.hopsworks.persistence.entity.maggy.MaggyDriver;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class MaggyFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public List<MaggyDriver> findByAppId(String appId) {
        TypedQuery query = this.em.createNamedQuery("MaggyDriver.findByAppId", MaggyDriver.class).setParameter("appId", (Object)appId);
        return query.getResultList();
    }

    public List<MaggyDriver> getAllDrivers() {
        TypedQuery query = this.em.createNamedQuery("MaggyDriver.findAll", MaggyDriver.class);
        return query.getResultList();
    }

    public void remove(MaggyDriver driver) {
        if (driver != null) {
            this.em.remove((Object)driver);
        }
    }

    public void removeByAppId(String appId) {
        List<MaggyDriver> driversToRemove = this.findByAppId(appId);
        driversToRemove.forEach(driver -> this.em.remove(driver));
    }

    public void add(MaggyDriver driver) {
        if (driver != null) {
            driver.setCreated((Date)Timestamp.valueOf(LocalDateTime.now()));
            this.em.persist((Object)driver);
        }
    }
}

