/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitFacade;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.HiveTbls;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupCommitController {
    @EJB
    private Settings settings;
    @EJB
    private FeatureGroupCommitFacade featureGroupCommitFacade;
    @EJB
    private InodeController inodeController;
    @EJB
    private FeaturestoreController featurestoreController;
    private static final String HOODIE_METADATA_DIR = ".hoodie";
    private static final String HOODIE_COMMIT_METADATA_FILE = ".commit";
    private static final Logger LOGGER = Logger.getLogger(FeatureGroupCommitController.class.getName());
    private static final HashMap<Pattern, String> DATE_FORMAT_PATTERNS = new HashMap<Pattern, String>(){
        {
            this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})$"), "yyyyMMdd");
            this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})$"), "yyyyMMddHH");
            this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$"), "yyyyMMddHHmm");
            this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$"), "yyyyMMddHHmmss");
        }
    };

    public FeatureGroupCommit createHudiFeatureGroupCommit(Featuregroup featuregroup, String commitDateString, Long rowsUpdated, Long rowsInserted, Long rowsDeleted) throws FeaturestoreException {
        String commitPath = this.computeHudiCommitPath(featuregroup, commitDateString);
        Inode inode = this.inodeController.getInodeAtPath(commitPath);
        FeatureGroupCommit featureGroupCommit = new FeatureGroupCommit(featuregroup.getId(), this.getTimeStampFromDateString(commitDateString));
        featureGroupCommit.setInode(inode);
        featureGroupCommit.setCommittedOn((Date)new Timestamp(this.getTimeStampFromDateString(commitDateString)));
        featureGroupCommit.setNumRowsUpdated(rowsUpdated);
        featureGroupCommit.setNumRowsInserted(rowsInserted);
        featureGroupCommit.setNumRowsDeleted(rowsDeleted);
        this.featureGroupCommitFacade.createFeatureGroupCommit(featureGroupCommit);
        return featureGroupCommit;
    }

    public FeatureGroupCommit findCommitByDate(Featuregroup featuregroup, String wallclocktime) throws FeaturestoreException {
        Optional<FeatureGroupCommit> featureGroupCommit;
        if (wallclocktime != null) {
            Long wallclockTimestamp = this.getTimeStampFromDateString(wallclocktime);
            featureGroupCommit = this.featureGroupCommitFacade.findClosestDateCommit(featuregroup.getId(), wallclockTimestamp);
        } else {
            featureGroupCommit = this.featureGroupCommitFacade.findLatestDateCommit(featuregroup.getId());
        }
        return featureGroupCommit.orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.NO_DATA_AVAILABLE_FEATUREGROUP_COMMITDATE, Level.FINE, "featureGroup: " + featuregroup.getName() + " version " + featuregroup.getVersion()));
    }

    public AbstractFacade.CollectionInfo getCommitDetails(Integer featureGroupId, Integer limit, Integer offset, Set<? extends AbstractFacade.SortBy> sort) {
        return this.featureGroupCommitFacade.getCommitDetails(featureGroupId, limit, offset, sort);
    }

    protected Long getTimeStampFromDateString(String inputDate) throws FeaturestoreException {
        String tempDate = inputDate.replace("/", "").replace("-", "").replace(" ", "").replace(":", "");
        String dateFormatPattern = null;
        for (Pattern pattern : DATE_FORMAT_PATTERNS.keySet()) {
            if (!pattern.matcher(tempDate).matches()) continue;
            dateFormatPattern = DATE_FORMAT_PATTERNS.get(pattern);
        }
        if (dateFormatPattern == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.PROVIDED_DATE_FORMAT_NOT_SUPPORTED, Level.FINE, "Unable to identify format of the provided date value : " + inputDate);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatPattern);
        Long commitTimeStamp = null;
        try {
            commitTimeStamp = dateFormat.parse(tempDate).getTime();
        }
        catch (ParseException e) {
            LOGGER.log(Level.FINE, "Unable to convert provided date value : " + tempDate + " to timestamp", e);
        }
        return commitTimeStamp;
    }

    protected String computeHudiCommitPath(Featuregroup featuregroup, String commitDateString) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateFormat.parse(commitDateString).getTime();
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "Unable to recognize provided HUDI commitDateString ", e);
        }
        HiveTbls hiveTbls = featuregroup.getCachedFeaturegroup().getHiveTbls();
        String dbLocation = hiveTbls.getSdId().getLocation();
        Path commitMetadataPath = new Path(HOODIE_METADATA_DIR, commitDateString + HOODIE_COMMIT_METADATA_FILE);
        Path commitPath = new Path(dbLocation, commitMetadataPath);
        return commitPath.toString();
    }
}

