/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.external;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetFacade;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.external.ExternalTrainingDataset;
import java.nio.file.Paths;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ExternalTrainingDatasetController {
    @EJB
    private ExternalTrainingDatasetFacade externalTrainingDatasetFacade;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeExternalTrainingDataset(ExternalTrainingDataset externalTrainingDataset) {
        this.externalTrainingDatasetFacade.remove(externalTrainingDataset);
    }

    public TrainingDatasetDTO convertExternalTrainingDatasetToDTO(TrainingDatasetDTO trainingDatasetDTO, TrainingDataset trainingDataset) {
        ExternalTrainingDataset externalTrainingDataset = trainingDataset.getExternalTrainingDataset();
        FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO = new FeaturestoreS3ConnectorDTO(externalTrainingDataset.getFeaturestoreConnector());
        trainingDatasetDTO.setStorageConnector(featurestoreS3ConnectorDTO);
        trainingDatasetDTO.setLocation(this.buildDatasetPath(trainingDataset));
        return trainingDatasetDTO;
    }

    private String buildDatasetPath(TrainingDataset trainingDataset) {
        String bucketFolder = "TRAINING_DATASETS";
        if (!Strings.isNullOrEmpty((String)trainingDataset.getExternalTrainingDataset().getPath())) {
            bucketFolder = trainingDataset.getExternalTrainingDataset().getPath();
        }
        return "s3://" + Paths.get(trainingDataset.getExternalTrainingDataset().getFeaturestoreConnector().getS3Connector().getBucket(), bucketFolder, trainingDataset.getName() + "_" + trainingDataset.getVersion()).toString();
    }
}

