/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.project.Project;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProjectUtils {
    @EJB
    private Settings settings;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;

    public boolean isReservedProjectName(String projectName) {
        for (String name : this.settings.getReservedProjectNames()) {
            if (!name.equalsIgnoreCase(projectName)) continue;
            return true;
        }
        return false;
    }

    public String getFullDockerImageName(Project project, boolean useBase) throws ServiceDiscoveryException {
        return ProjectUtils.getFullDockerImageName(project, this.settings, this.serviceDiscoveryController, useBase);
    }

    public static String getFullDockerImageName(Project project, Settings settings, ServiceDiscoveryController serviceDiscoveryController, boolean useBase) throws ServiceDiscoveryException {
        String imageName = ProjectUtils.getDockerImageName(project, settings, useBase);
        return ProjectUtils.getRegistryURL(settings, serviceDiscoveryController) + "/" + imageName;
    }

    public static String getDockerImageName(Project project, Settings settings, boolean useBase) {
        if (project.getConda().booleanValue() && (useBase || Strings.isNullOrEmpty((String)project.getDockerImage()))) {
            return settings.getBaseDockerImagePythonName();
        }
        if (!project.getConda().booleanValue()) {
            throw new IllegalArgumentException("Error. Python has not been enabled for this project.");
        }
        return project.getDockerImage();
    }

    public String getFullDockerImageName(String imageName) throws ServiceDiscoveryException {
        return ProjectUtils.getRegistryURL(this.settings, this.serviceDiscoveryController) + "/" + imageName;
    }

    public String getRegistryURL() throws ServiceDiscoveryException {
        return ProjectUtils.getRegistryURL(this.settings, this.serviceDiscoveryController);
    }

    public static String getRegistryURL(Settings settings, ServiceDiscoveryController serviceDiscoveryController) throws ServiceDiscoveryException {
        Service registry = serviceDiscoveryController.getAnyAddressOfServiceWithDNSSRVOnly(ServiceDiscoveryController.HopsworksService.REGISTRY);
        if (settings.isManagedDockerRegistry().booleanValue()) {
            String registryUrl = registry.getAddress();
            String dockerNamespace = settings.getDockerNamespace();
            if (!dockerNamespace.isEmpty()) {
                registryUrl = registryUrl + "/" + dockerNamespace;
            }
            return registryUrl;
        }
        return registry.getName() + ":" + registry.getPort();
    }

    public String getInitialDockerImageName(Project project) {
        String initialImageTag = System.currentTimeMillis() + "-" + this.settings.getHopsworksVersion() + ".0";
        if (this.settings.isManagedDockerRegistry().booleanValue()) {
            return this.settings.getBaseNonPythonDockerImageWithNoTag() + ":" + project.getName().toLowerCase() + "_" + initialImageTag;
        }
        return project.getName().toLowerCase() + ":" + initialImageTag;
    }

    public String getFullBaseImageName() throws ServiceDiscoveryException {
        return ProjectUtils.getRegistryURL(this.settings, this.serviceDiscoveryController) + "/" + this.settings.getBaseDockerImagePythonName();
    }

    public String getProjectNameFromDockerImageName(String imageName) {
        if (this.settings.isManagedDockerRegistry().booleanValue()) {
            return imageName.split(":")[1].split("_")[0];
        }
        return this.getProjectDockerRepoName(imageName);
    }

    public String getProjectDockerRepoName(String imageName) {
        return imageName.split(":")[0];
    }
}

