/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.utils;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

@Stateless
public class FeaturestoreUtils {
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService distributedFsService;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;

    public void verifyUserRole(TrainingDataset trainingDataset, Featurestore featurestore, Users user, Project project) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!trainingDataset.getCreator().equals((Object)user) && !userRole.equalsIgnoreCase("Data owner")) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.UNAUTHORIZED_FEATURESTORE_OPERATION, Level.FINE, "project: " + project.getName() + ", featurestoreId: " + featurestore.getId() + ", Training dataset: " + trainingDataset.getName() + ", userRole:" + userRole + ", creator of the featuregroup: " + trainingDataset.getCreator().getEmail());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToHDFS(Project project, Users user, Path filePath, String content) throws IOException {
        DistributedFileSystemOps udfso = null;
        try {
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = this.distributedFsService.getDfsOps(hdfsUsername);
            try (FSDataOutputStream outStream = udfso.create(filePath);){
                outStream.writeBytes(content);
                outStream.hflush();
            }
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
        }
        catch (Throwable throwable) {
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            throw throwable;
        }
    }

    public String resolveLocationURI(String locationURI) throws ServiceException {
        URI uri = URI.create(locationURI);
        if (Strings.isNullOrEmpty((String)uri.getHost())) {
            return locationURI;
        }
        if (InetAddresses.isInetAddress((String)uri.getHost())) {
            return locationURI;
        }
        try {
            Service nn = this.serviceDiscoveryController.getService(Type.DNS, ServiceQuery.of((String)uri.getHost(), Collections.emptySet())).findAny().orElseThrow(() -> new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE, "Service Discovery is enabled but could not resolve domain " + uri.getHost()));
            return new URI(uri.getScheme(), uri.getUserInfo(), nn.getAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (ServiceDiscoveryException | URISyntaxException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE, "Service Discovery is enabled but could not resolve domain " + uri.getHost(), ex.getMessage(), ex);
        }
    }
}

