/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.security.SymmetricEncryptionDescriptor;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.ejb.Stateless;
import org.apache.commons.lang3.tuple.Pair;

@Stateless
public class SymmetricEncryptionService {
    private static final String RNG_IMPL = "NativePRNGNonBlocking";
    public static final int SALT_LENGTH = 64;
    private static final int KEY_DERIVATION_ITERATIONS = 10000;
    private static final int KEY_SIZE = 128;
    private static final String KEY_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final String AES_MODE = "AES/GCM/PKCS5Padding";
    private static final int GCM_AUTHENTICATION_TAG_SIZE = 128;
    public static final int IV_LENGTH = 12;
    SecureRandom rand;

    @PostConstruct
    public void init() {
        try {
            this.rand = SecureRandom.getInstance(RNG_IMPL);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public SymmetricEncryptionDescriptor encrypt(SymmetricEncryptionDescriptor descriptor) throws GeneralSecurityException {
        byte[] iv;
        byte[] salt;
        if (descriptor.getSalt() != null) {
            salt = descriptor.getSalt();
        } else {
            salt = new byte[64];
            this.generateRandom(salt);
        }
        if (descriptor.getIv() != null) {
            iv = descriptor.getIv();
        } else {
            iv = new byte[12];
            this.generateRandom(iv);
        }
        Pair<KeySpec, SecretKey> keyMaterial = this.buildSecretKey(descriptor.getPassword(), salt);
        Cipher cipher = this.getCipher();
        cipher.init(1, (Key)keyMaterial.getRight(), this.getGCMSpec(iv));
        byte[] ciphertext = cipher.doFinal(descriptor.getInput());
        this.clearPasswords((KeySpec)keyMaterial.getLeft(), descriptor);
        return new SymmetricEncryptionDescriptor.Builder().setOutput(ciphertext).setSalt(salt).setIV(iv).build();
    }

    public SymmetricEncryptionDescriptor decrypt(SymmetricEncryptionDescriptor descriptor) throws GeneralSecurityException {
        if (descriptor.getSalt() == null || descriptor.getIv() == null || descriptor.getPassword() == null) {
            throw new IllegalArgumentException("Cryptographic primitives are empty");
        }
        Pair<KeySpec, SecretKey> keyMaterial = this.buildSecretKey(descriptor.getPassword(), descriptor.getSalt());
        Cipher cipher = this.getCipher();
        cipher.init(2, (Key)keyMaterial.getRight(), this.getGCMSpec(descriptor.getIv()));
        byte[] plaintext = cipher.doFinal(descriptor.getInput());
        this.clearPasswords((KeySpec)keyMaterial.getLeft(), descriptor);
        return new SymmetricEncryptionDescriptor.Builder().setOutput(plaintext).build();
    }

    public byte[] mergePayloadWithCryptoPrimitives(byte[] salt, byte[] iv, byte[] payload) {
        byte[] payloadWithPrimitives = new byte[salt.length + iv.length + payload.length];
        System.arraycopy(salt, 0, payloadWithPrimitives, 0, salt.length);
        System.arraycopy(iv, 0, payloadWithPrimitives, salt.length, iv.length);
        System.arraycopy(payload, 0, payloadWithPrimitives, salt.length + iv.length, payload.length);
        return payloadWithPrimitives;
    }

    public byte[][] splitPayloadFromCryptoPrimitives(byte[] payloadWithCryptoPrimitives) {
        byte[] salt = new byte[64];
        byte[] iv = new byte[12];
        byte[] ciphertext = new byte[payloadWithCryptoPrimitives.length - 64 - 12];
        System.arraycopy(payloadWithCryptoPrimitives, 0, salt, 0, salt.length);
        System.arraycopy(payloadWithCryptoPrimitives, salt.length, iv, 0, iv.length);
        System.arraycopy(payloadWithCryptoPrimitives, salt.length + iv.length, ciphertext, 0, ciphertext.length);
        byte[][] splitPayload = new byte[][]{salt, iv, ciphertext};
        return splitPayload;
    }

    private void clearPasswords(KeySpec keySpec, SymmetricEncryptionDescriptor descriptor) {
        if (keySpec instanceof PBEKeySpec) {
            ((PBEKeySpec)keySpec).clearPassword();
        }
        descriptor.clearPassword();
    }

    private Pair<KeySpec, SecretKey> buildSecretKey(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(KEY_DERIVATION_ALGORITHM);
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, 10000, 128);
        SecretKey key = secretKeyFactory.generateSecret(keySpec);
        return Pair.of((Object)keySpec, (Object)new SecretKeySpec(key.getEncoded(), ENCRYPTION_ALGORITHM));
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(AES_MODE);
    }

    private GCMParameterSpec getGCMSpec(byte[] iv) {
        return new GCMParameterSpec(128, iv);
    }

    private void generateRandom(byte[] buffer) {
        this.rand.nextBytes(buffer);
    }
}

