/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jwt;

import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.time.LocalDateTime;

public class ServiceJWT {
    public final Project project;
    public final Users user;
    public LocalDateTime expiration;
    public String token;

    public ServiceJWT(ServiceJWT serviceJWT) {
        this(serviceJWT.project, serviceJWT.user, serviceJWT.expiration);
        this.token = serviceJWT.token;
    }

    public ServiceJWT(Project project, Users user, LocalDateTime expiration) {
        this.project = project;
        this.user = user;
        this.expiration = expiration;
    }

    public boolean maybeRenew(LocalDateTime now) {
        return now.isAfter(this.expiration) || now.isEqual(this.expiration);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.project.getId();
        result = 31 * result + this.user.getUid();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ServiceJWT) {
            ServiceJWT other = (ServiceJWT)o;
            return this.user.getUid().equals(other.user.getUid()) && this.project.getId().equals(other.project.getId());
        }
        return false;
    }

    public String toString() {
        return "(" + this.project.getName() + "/" + this.user.getUsername() + ")";
    }
}

