/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics.columns;

import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.StatisticColumn;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class StatisticColumnController {
    @EJB
    private StatisticColumnFacade statisticColumnFacade;

    public void persistStatisticColumns(Featuregroup featuregroup, List<String> statisticColumns) {
        if (statisticColumns != null) {
            statisticColumns.forEach(statisticColumn -> {
                if (!this.isColumnExists((List)featuregroup.getStatisticColumns(), (String)statisticColumn)) {
                    StatisticColumn sc = new StatisticColumn();
                    sc.setFeaturegroup(featuregroup);
                    sc.setName(statisticColumn);
                    this.statisticColumnFacade.persist(sc);
                }
            });
            List columnEntities = (List)featuregroup.getStatisticColumns();
            columnEntities.forEach(scEntity -> {
                if (this.isEntityToBeDropped((StatisticColumn)scEntity, statisticColumns)) {
                    this.statisticColumnFacade.remove(scEntity);
                }
            });
        }
    }

    public boolean isColumnExists(List<StatisticColumn> statisticColumns, String column) {
        return statisticColumns.stream().anyMatch(statisticColumn -> statisticColumn.getName().equals(column));
    }

    public boolean isEntityToBeDropped(StatisticColumn entity, List<String> statisticColumns) {
        return statisticColumns.stream().noneMatch(statisticColumn -> statisticColumn.equals(entity.getName()));
    }

    public void verifyStatisticColumnsExist(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        this.verifyStatisticColumnsExist(featuregroupDTO, featuregroupDTO.getFeatures());
    }

    public void verifyStatisticColumnsExist(FeaturegroupDTO featuregroupDTO, List<FeatureGroupFeatureDTO> features) throws FeaturestoreException {
        if (featuregroupDTO.getStatisticColumns() != null) {
            List featureNames = features.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toList());
            Optional<String> nonExistingStatColumn = featuregroupDTO.getStatisticColumns().stream().filter(statCol -> !featureNames.contains(statCol)).findAny();
            if (nonExistingStatColumn.isPresent()) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STATISTICS_CONFIG, Level.FINE, "statistic column: " + nonExistingStatColumn.get() + " is not part of feature group " + featuregroupDTO.getName() + " with version " + featuregroupDTO.getVersion());
            }
        }
    }
}

