/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset.util;

import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;

public class DatasetPath {
    private final Path fullPath;
    private final Path datasetFullPath;
    private final Path relativePath;
    private boolean isShared;
    private Dataset dataset;
    private DatasetSharedWith datasetSharedWith;
    private Inode inode;

    public DatasetPath(Project project, String path, String root) throws UnsupportedEncodingException {
        String projectName;
        String p = Utils.prepPath(path);
        String pathStr = Utils.pathStripSlash(p);
        String pathRoot = Utils.pathStripSlash(root);
        boolean isProject = root.equals("Projects");
        this.isShared = pathStr.contains("::");
        String dataset = this.getDatasetFromPath(pathStr, pathRoot, project.getName(), isProject);
        String datasetName = !dataset.isEmpty() && dataset.contains(File.separator) ? dataset.split(File.separator)[0] : dataset;
        String string = projectName = isProject ? File.separator + project.getName() + File.separator : File.separator;
        if (pathStr.startsWith(pathRoot + File.separator) && !datasetName.contains("::")) {
            this.fullPath = new Path(File.separator + pathStr);
        } else if (!datasetName.contains("::")) {
            this.fullPath = new Path(File.separator + pathRoot + projectName + pathStr);
        } else {
            String[] datasetNameParts = datasetName.split("::");
            String string2 = projectName = isProject ? File.separator + datasetNameParts[0] + File.separator : File.separator;
            if (projectName.replaceAll(File.separator, "").equals(project.getName())) {
                this.isShared = false;
                dataset = dataset.replace(datasetName, datasetNameParts[1]);
            }
            this.fullPath = new Path(File.separator + pathRoot + projectName + dataset.replace(datasetName, datasetNameParts[1]));
        }
        this.relativePath = new Path(File.separator + dataset);
        this.datasetFullPath = this.getDatasetPath(this.fullPath.toString(), new Path(pathRoot + projectName));
    }

    public Path getFullPath() {
        return this.fullPath;
    }

    public Path getDatasetFullPath() {
        return this.datasetFullPath;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public DatasetSharedWith getDatasetSharedWith() {
        return this.datasetSharedWith;
    }

    public void setDatasetSharedWith(DatasetSharedWith datasetSharedWith) {
        this.datasetSharedWith = datasetSharedWith;
    }

    public Inode getInode() {
        return this.inode;
    }

    public void setInode(Inode inode) {
        this.inode = inode;
    }

    public boolean isTopLevelDataset() {
        return this.fullPath.depth() == this.datasetFullPath.depth();
    }

    public String getDatasetRelativePath() {
        return Utils.pathStripSlash(this.fullPath.toString().replace(this.datasetFullPath.toString(), ""));
    }

    public String getDatasetName() {
        return this.datasetFullPath.getName();
    }

    public boolean isShared() {
        return this.isShared;
    }

    private String getDatasetFromPath(String path, String root, String projectName, boolean isProject) {
        String dataset = path;
        if (path.startsWith(root)) {
            dataset = path.replace(root + File.separator, "");
            if (isProject && dataset.startsWith(projectName)) {
                dataset = dataset.replace(projectName + File.separator, "");
            } else if (isProject) {
                dataset = dataset.substring(dataset.indexOf(File.separator) + 1);
            }
        }
        return dataset;
    }

    private Path getDatasetPath(String fullPath, Path root) {
        if (fullPath.startsWith(File.separator)) {
            fullPath = fullPath.substring(1);
        }
        String[] parts = fullPath.split(File.separator);
        String dsPath = String.join((CharSequence)File.separator, Arrays.copyOfRange(parts, 0, root.depth() + 1));
        return new Path(File.separator + dsPath);
    }
}

