/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.metadata.db;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.metadata.EntityIntf;
import io.hops.hopsworks.persistence.entity.metadata.MTable;
import io.hops.hopsworks.persistence.entity.metadata.Template;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class TemplateFacade
extends AbstractFacade<Template> {
    private static final Logger LOGGER = Logger.getLogger(TemplateFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public TemplateFacade() {
        super(Template.class);
    }

    public Template getTemplate(int templateId) {
        return (Template)this.em.find(Template.class, (Object)templateId);
    }

    public int addTemplate(Template template) {
        try {
            Template t = this.getTemplate(template.getId());
            if (t != null && t.getId() != -1) {
                t.copy((EntityIntf)template);
                this.em.merge((Object)t);
            } else {
                t = template;
                t.getMTables().clear();
                this.em.persist((Object)t);
            }
            this.em.flush();
            this.em.clear();
            return t.getId();
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not add template " + template, ex);
            throw ex;
        }
    }

    public void removeTemplate(Template template) {
        try {
            Template t = this.getTemplate(template.getId());
            if (t != null) {
                if (this.em.contains((Object)t)) {
                    this.em.remove((Object)t);
                } else {
                    this.em.remove(this.em.merge((Object)t));
                }
            }
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not remove template " + template, ex);
            throw ex;
        }
    }

    public List<Template> loadTemplates() {
        String queryString = "Template.findAll";
        Query query = this.em.createNamedQuery(queryString);
        return query.getResultList();
    }

    public List<MTable> loadTemplateContent(int templateId) {
        String queryString = "MTable.findByTemplateId";
        Query query = this.em.createNamedQuery(queryString);
        query.setParameter("templateid", (Object)templateId);
        List modifiedEntities = query.getResultList();
        for (MTable table : modifiedEntities) {
            this.em.refresh((Object)table);
        }
        Collections.sort(modifiedEntities);
        return modifiedEntities;
    }

    public Template findByTemplateId(int templateid) {
        TypedQuery query = this.em.createNamedQuery("Template.findById", Template.class);
        query.setParameter("templateid", (Object)templateid);
        try {
            return (Template)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Template> findByTemplateName(String templateName) {
        TypedQuery query = this.em.createNamedQuery("Template.findByName", Template.class);
        query.setParameter("name", (Object)templateName);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public boolean isTemplateAvailable(String templateName) {
        List<Template> t = this.findByTemplateName(templateName);
        return t != null && t.size() > 0;
    }

    public void updateTemplatesInodesMxN(Template template) {
        this.em.merge((Object)template);
    }
}

