/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.util;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.util.Variables;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class VariablesFacade
extends AbstractFacade<Variables> {
    private static final Logger logger = Logger.getLogger(VariablesFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public VariablesFacade() {
        super(Variables.class);
    }

    public void storeVariable(String id, String value) {
        Variables variable = new Variables(id, value);
        this.em.merge((Object)variable);
        this.em.flush();
    }

    public String getVariableValue(String id) {
        TypedQuery query = this.em.createNamedQuery("Variables.findById", Variables.class).setParameter("id", (Object)id);
        try {
            Variables var = (Variables)query.getSingleResult();
            if (var != null) {
                return var.getValue();
            }
        }
        catch (NoResultException e) {
            logger.log(Level.INFO, "Variable " + id + " not found in the database");
        }
        return null;
    }
}

