/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs;

import io.hops.hopsworks.common.dao.hdfs.HdfsLeDescriptorsFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.UserGroupInformationService;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsGroups;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.security.UserGroupInformation;

@Stateless
public class DistributedFsService {
    private static final Logger logger = Logger.getLogger(DistributedFsService.class.getName());
    @EJB
    private InodeController inodeController;
    @EJB
    private UserGroupInformationService ugiService;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsLeDescriptorsFacade hdfsLeDescriptorsFacade;
    @EJB
    private Settings settings;
    @EJB
    private BaseHadoopClientsService bhcs;
    private Configuration conf;
    private String hadoopConfDir;
    private String transientDir;
    private UserGroupInformation loginUser;

    @PostConstruct
    public void init() {
        try {
            this.loginUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not get login user", ex);
            throw new IllegalStateException(ex);
        }
        System.setProperty("hadoop.home.dir", this.settings.getHadoopSymbolicLinkDir());
        this.hadoopConfDir = this.settings.getHadoopConfDir();
        File hadoopConfFile = new File(this.hadoopConfDir, "core-site.xml");
        if (!hadoopConfFile.exists()) {
            logger.log(Level.SEVERE, "Unable to locate configuration file in {0}", hadoopConfFile);
            throw new IllegalStateException("No hadoop conf file: core-site.xml");
        }
        File hdfsConfFile = new File(this.hadoopConfDir, "hdfs-site.xml");
        if (!hdfsConfFile.exists()) {
            logger.log(Level.SEVERE, "Unable to locate configuration file in {0}", hdfsConfFile);
            throw new IllegalStateException("No hdfs conf file: hdfs-site.xml");
        }
        Path hdfsPath = new Path(hdfsConfFile.getAbsolutePath());
        Path hadoopPath = new Path(hadoopConfFile.getAbsolutePath());
        this.conf = new Configuration();
        this.conf.addResource(hadoopPath);
        this.conf.addResource(hdfsPath);
        this.conf.set("fs.permissions.umask-mode", "0007");
        this.conf.setStrings("dfs.namenode.rpc-address", new String[]{this.hdfsLeDescriptorsFacade.getRPCEndpoint()});
        if (this.settings.getHopsRpcTls()) {
            this.transientDir = this.settings.getHopsworksTmpCertDir();
        }
    }

    @PreDestroy
    public void preDestroy() {
        this.conf.clear();
        this.conf = null;
    }

    public DistributedFileSystemOps getDfsOps() {
        if (this.settings.getHopsRpcTls()) {
            Configuration newConf = new Configuration(this.conf);
            String keystorePath = this.bhcs.getSuperKeystorePath();
            String keystorePass = this.bhcs.getSuperKeystorePassword();
            String truststorePath = this.bhcs.getSuperTrustStorePath();
            String truststorePass = this.bhcs.getSuperTrustStorePassword();
            HopsSSLSocketFactory.setTlsConfiguration((String)keystorePath, (String)keystorePass, (String)truststorePath, (String)truststorePass, (Configuration)newConf);
            return new DistributedFileSystemOps(UserGroupInformation.createRemoteUser((String)this.loginUser.getUserName()), newConf);
        }
        return new DistributedFileSystemOps(UserGroupInformation.createRemoteUser((String)this.loginUser.getUserName()), this.conf);
    }

    public DistributedFileSystemOps getDfsOps(URI uri) {
        if (this.settings.getHopsRpcTls()) {
            Configuration newConf = new Configuration(this.conf);
            String keystorePath = this.bhcs.getSuperKeystorePath();
            String keystorePass = this.bhcs.getSuperKeystorePassword();
            String truststorePath = this.bhcs.getSuperTrustStorePath();
            String truststorePass = this.bhcs.getSuperTrustStorePassword();
            HopsSSLSocketFactory.setTlsConfiguration((String)keystorePath, (String)keystorePass, (String)truststorePath, (String)truststorePass, (Configuration)newConf);
            return new DistributedFileSystemOps(UserGroupInformation.createRemoteUser((String)this.loginUser.getUserName()), newConf, uri);
        }
        return new DistributedFileSystemOps(UserGroupInformation.createRemoteUser((String)this.loginUser.getUserName()), this.conf, uri);
    }

    public DistributedFileSystemOps getDfsOps(String username) {
        UserGroupInformation ugi;
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("username not provided.");
        }
        try {
            ugi = UserGroupInformation.createProxyUser((String)username, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
        if (this.settings.getHopsRpcTls()) {
            try {
                this.bhcs.materializeCertsForNonSuperUser(username);
                Configuration newConf = new Configuration(this.conf);
                this.bhcs.configureTlsForProjectSpecificUser(username, this.transientDir, newConf);
                return new DistributedFileSystemOps(ugi, newConf);
            }
            catch (CryptoPasswordNotFoundException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.bhcs.removeNonSuperUserCertificate(username);
                return null;
            }
        }
        return new DistributedFileSystemOps(ugi, this.conf);
    }

    public void closeDfsClient(DistributedFileSystemOps udfso) {
        if (null != udfso) {
            if (this.settings.getHopsRpcTls() && !udfso.getEffectiveUser().equals(this.loginUser.getUserName())) {
                this.bhcs.removeNonSuperUserCertificate(udfso.getEffectiveUser());
            }
            udfso.close();
        }
    }

    public DistributedFileSystemOps getDfsOpsForTesting(String username) {
        UserGroupInformation ugi;
        if (username == null || username.isEmpty()) {
            throw new NullPointerException("username not set.");
        }
        Collection groups = this.hdfsUsersFacade.findByName(username).getHdfsGroupsCollection();
        String[] userGroups = new String[groups.size()];
        Iterator iter = groups.iterator();
        int i = 0;
        while (iter.hasNext()) {
            userGroups[i] = ((HdfsGroups)iter.next()).getName();
            ++i;
        }
        try {
            ugi = UserGroupInformation.createProxyUserForTesting((String)username, (UserGroupInformation)UserGroupInformation.getLoginUser(), (String[])userGroups);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
        if (this.settings.getHopsRpcTls()) {
            try {
                this.bhcs.materializeCertsForNonSuperUser(username);
                Configuration newConf = new Configuration(this.conf);
                this.bhcs.configureTlsForProjectSpecificUser(username, this.transientDir, newConf);
                return new DistributedFileSystemOps(ugi, newConf);
            }
            catch (CryptoPasswordNotFoundException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.bhcs.removeNonSuperUserCertificate(username);
                return null;
            }
        }
        return new DistributedFileSystemOps(ugi, this.conf);
    }

    public void removeDfsOps(String username) {
        if (username == null || username.isEmpty()) {
            return;
        }
        UserGroupInformation ugi = this.ugiService.remove(username);
        if (ugi == null) {
            return;
        }
        try {
            FileSystem.closeAllForUGI((UserGroupInformation)ugi);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not close file system for user " + ugi.getUserName(), ex);
        }
    }

    public UserGroupInformation getLoginUser() {
        return this.loginUser;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public boolean isDir(String path) {
        Inode i = this.inodeController.getInodeAtPath(path);
        if (i != null) {
            return i.isDir();
        }
        return false;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public Inode getInode(String path) {
        Inode i = this.inodeController.getInodeAtPath(path);
        return i;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<String> getChildNames(String path) {
        Inode inode = this.inodeController.getInodeAtPath(path);
        if (inode.isDir()) {
            List<Inode> inodekids = this.inodeController.getChildren(inode);
            ArrayList<String> retList = new ArrayList<String>(inodekids.size());
            for (Inode i : inodekids) {
                if (i.isDir()) continue;
                retList.add(i.getInodePK().getName());
            }
            return retList;
        }
        return Collections.EMPTY_LIST;
    }

    public List<Inode> getChildInodes(String path) {
        Inode inode = this.inodeController.getInodeAtPath(path);
        if (inode.isDir()) {
            return this.inodeController.getChildren(inode);
        }
        return Collections.EMPTY_LIST;
    }
}

