/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.util;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ProvHelper {
    public static <C> C extractElasticField(Map<String, Object> fields, ProvParser.Field field) throws ProvenanceException {
        return ProvHelper.extractElasticField(fields, field, false);
    }

    public static <C> C extractElasticField(Map<String, Object> fields, ProvParser.Field field, boolean soft) throws ProvenanceException {
        Object val = fields.remove(field.elasticFieldName());
        if (val == null) {
            if (soft) {
                return null;
            }
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "problem parsing elastic field:" + field + " - found null");
        }
        try {
            return (C)field.filterValParser().apply(val);
        }
        catch (ProvenanceException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "problem parsing elastic field:" + field, "problem parsing elastic field:" + field, (Throwable)e);
        }
    }

    public static <C> C extractElasticField(Map<String, Object> fields, ProvParser.ElasticField field, CheckedFunction<Object, C, ProvenanceException> parser, boolean soft) throws ProvenanceException {
        Object val = fields.remove(field.toString());
        if (val == null) {
            if (soft) {
                return null;
            }
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "problem parsing elastic field:" + field + " - found null");
        }
        try {
            return parser.apply(val);
        }
        catch (ProvenanceException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "problem parsing elastic field:" + field, "problem parsing elastic field:" + field, (Throwable)e);
        }
    }

    public static <C> C extractElasticField(Object val) throws ProvenanceException {
        if (val == null) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "expected String, found null");
        }
        return (C)val;
    }

    public static CheckedFunction<Object, Map<String, String>, ProvenanceException> asXAttrMap() {
        return o -> {
            Map xattrsMap;
            HashMap<String, String> result = new HashMap<String, String>();
            try {
                xattrsMap = (Map)o;
            }
            catch (ClassCastException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "prov xattr expected map object (1)", e.getMessage(), (Throwable)e);
            }
            for (Map.Entry entry : xattrsMap.entrySet()) {
                String xattrVal;
                String xattrKey;
                try {
                    xattrKey = (String)entry.getKey();
                }
                catch (ClassCastException e) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "prov xattr expected map with string keys", e.getMessage(), (Throwable)e);
                }
                if (entry.getValue() instanceof Map) {
                    Map xaMap = (Map)entry.getValue();
                    if (!xaMap.containsKey("raw")) throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "parsing prov xattr:" + entry.getKey());
                    xattrVal = (String)xaMap.get("raw");
                } else {
                    if (!(entry.getValue() instanceof String)) throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.MALFORMED_ENTRY, Level.INFO, "prov xattr expected map or string");
                    xattrVal = (String)entry.getValue();
                }
                result.put(xattrKey, xattrVal);
            }
            return result;
        };
    }

    public static ProvenanceException fromElastic(ElasticException e, String userMsg, String devMsg) {
        if (e.getErrorCode().equals(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR)) {
            return new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, userMsg, devMsg, (Throwable)e);
        }
        return new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, userMsg, devMsg, (Throwable)e);
    }

    public static boolean missingMappingForField(ProvenanceException e) {
        return e.getErrorCode().equals(RESTCodes.ProvenanceErrorCode.BAD_REQUEST) && e.getDevMsg().startsWith("missing mapping for field");
    }
}

