/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.sshkey;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.user.sshkey.SshKeys;
import io.hops.hopsworks.persistence.entity.user.sshkey.SshKeysPK;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class SshkeysFacade
extends AbstractFacade<SshKeys> {
    private final int STARTING_USER = 1000;
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public SshkeysFacade() {
        super(SshKeys.class);
    }

    public List<SshKeys> findAllById(int id) {
        TypedQuery query = this.em.createNamedQuery("SshKeys.findByUid", SshKeys.class);
        query.setParameter("uid", (Object)id);
        return query.getResultList();
    }

    public void persist(SshKeys user) {
        this.em.persist((Object)user);
    }

    @Override
    public SshKeys update(SshKeys user) {
        return (SshKeys)this.em.merge((Object)user);
    }

    public void removeByIdName(int uid, String name) {
        SshKeysPK pk = new SshKeysPK(uid, name);
        if (pk != null) {
            TypedQuery query = this.em.createNamedQuery("SshKeys.findByUidName", SshKeys.class);
            query.setParameter("name", (Object)name);
            query.setParameter("uid", (Object)uid);
            SshKeys item = (SshKeys)query.getSingleResult();
            SshKeys sk = (SshKeys)this.em.merge((Object)item);
            this.em.remove((Object)sk);
        }
    }

    @Override
    public void remove(SshKeys sshKey) {
        if (sshKey != null && sshKey.getSshKeysPK() != null && this.em.contains((Object)sshKey)) {
            this.em.remove((Object)sshKey);
        }
    }

    public void detach(SshKeys key) {
        this.em.detach((Object)key);
    }

    public List<SshKeys> findAllByUid(int uid) {
        TypedQuery query = this.em.createNamedQuery("SshKeys.findByUid", SshKeys.class);
        query.setParameter("uid", (Object)uid);
        return query.getResultList();
    }
}

