/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureGroupCommitFacade
extends AbstractFacade<FeatureGroupCommit> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureGroupCommitFacade() {
        super(FeatureGroupCommit.class);
    }

    public void createFeatureGroupCommit(FeatureGroupCommit featureGroupCommit) {
        this.em.persist((Object)featureGroupCommit);
        this.em.flush();
    }

    public Optional<FeatureGroupCommit> findClosestDateCommit(Integer featureGroupId, Long wallclocktime) {
        Timestamp requestedPointInTime = new Timestamp(wallclocktime);
        TypedQuery fgcQuery = this.em.createNamedQuery("FeatureGroupCommit.findByLatestCommittedOn", FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId).setParameter("requestedPointInTime", (Object)requestedPointInTime);
        try {
            return Optional.of((FeatureGroupCommit)fgcQuery.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeatureGroupCommit> findLatestDateCommit(Integer featureGroupId) {
        TypedQuery fgcQuery = this.em.createNamedQuery("FeatureGroupCommit.findLatestCommit", FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        try {
            return Optional.of((FeatureGroupCommit)fgcQuery.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<FeatureGroupCommit> getCommitDetailsByDate(Integer featureGroupId, Long wallclocktime, Integer limit) {
        Timestamp requestedPointInTime = new Timestamp(wallclocktime);
        TypedQuery q = this.em.createNamedQuery("FeatureGroupCommit.findByCommittedOn", FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId).setParameter("requestedPointInTime", (Object)requestedPointInTime).setMaxResults(limit.intValue());
        return q.getResultList();
    }

    public AbstractFacade.CollectionInfo getCommitDetails(Integer featureGroupId, Integer limit, Integer offset, Set<? extends AbstractFacade.SortBy> sort) {
        String queryStr = this.buildQuery("SELECT fgc FROM FeatureGroupCommit fgc ", null, sort, "fgc.featureGroupCommitPK.featureGroupId = :featureGroupId");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        String queryCountStr = this.buildQuery("SELECT COUNT(fgc.featureGroupCommitPK.commitId) FROM FeatureGroupCommit fgc ", null, sort, "fgc.featureGroupCommitPK.featureGroupId = :featureGroupId");
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        query.setFirstResult(offset.intValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        return new AbstractFacade.CollectionInfo(this, (Long)queryCount.getSingleResult(), query.getResultList());
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public static enum Sorts {
        COMMITTED_ON("COMMITTED_ON", " fgc.committedOn ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String toString() {
            return this.value;
        }
    }
}

