/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.kafka.KafkaBrokers;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;

@Singleton
@DependsOn(value={"KafkaBrokers"})
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class HopsKafkaAdminClient {
    private static final Logger LOG = Logger.getLogger(HopsKafkaAdminClient.class.getName());
    @EJB
    private BaseHadoopClientsService baseHadoopService;
    @EJB
    private KafkaBrokers kafkaBrokers;
    private AdminClient adminClient;

    @PostConstruct
    private void init() {
        try {
            LOG.log(Level.FINE, "Initializing Kafka client");
            this.initClient();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Kafka is currently unavailable. Will periodically retry to connect");
        }
    }

    @AccessTimeout(value=5000L)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    private void initClient() {
        if (this.adminClient != null) {
            try {
                LOG.log(Level.FINE, "Will attempt to close current kafka client");
                this.adminClient.close(Duration.ofSeconds(3L));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not close adminClient, will continue with initialization", e);
            }
        }
        Properties props = new Properties();
        Set<String> brokers = this.kafkaBrokers.getKafkaBrokers();
        brokers.removeIf(seed -> seed.split(":")[0].equalsIgnoreCase("EXTERNAL"));
        String brokerAddress = brokers.iterator().next().split("://")[1];
        props.setProperty("bootstrap.servers", brokerAddress);
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.truststore.location", this.baseHadoopService.getSuperTrustStorePath());
        props.setProperty("ssl.truststore.password", this.baseHadoopService.getSuperTrustStorePassword());
        props.setProperty("ssl.keystore.location", this.baseHadoopService.getSuperKeystorePath());
        props.setProperty("ssl.keystore.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.key.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.endpoint.identification.algorithm", "");
        LOG.log(Level.FINE, "Will attempt to initialize current kafka client");
        this.adminClient = AdminClient.create((Properties)props);
    }

    public ListTopicsResult listTopics() {
        try {
            return this.adminClient.listTopics();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Kafka cluster is unavailable", e);
            this.initClient();
            return this.adminClient.listTopics();
        }
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) {
        try {
            return this.adminClient.createTopics(newTopics);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Kafka cluster is unavailable", e);
            this.initClient();
            return this.adminClient.createTopics(newTopics);
        }
    }

    public DeleteTopicsResult deleteTopics(Collection<String> topics) {
        try {
            return this.adminClient.deleteTopics(topics);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Kafka cluster is unavailable", e);
            this.initClient();
            return this.adminClient.deleteTopics(topics);
        }
    }

    public DescribeTopicsResult describeTopics(Collection<String> topics) {
        try {
            return this.adminClient.describeTopics(topics);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Kafka cluster is unavailable", e);
            this.initClient();
            return this.adminClient.describeTopics(topics);
        }
    }
}

