/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.online;

import com.google.common.base.Strings;
import com.logicalclocks.shaded.org.apache.commons.lang3.StringUtils;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreFacade;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class OnlineFeaturegroupController {
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private OnlineFeaturestoreFacade onlineFeaturestoreFacade;
    @EJB
    private Settings settings;
    private static final List<String> MYSQL_TYPES = Arrays.asList("INT", "TINYINT", "SMALLINT", "MEDIUMINT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "DATE", "DATETIME", "TIMESTAMP", "TIME", "YEAR", "CHAR", "BINARY", "BLOB", "TEXT", "TINYBLOB", "TINYTEXT", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT");
    private static final String VARBINARY_DEFAULT = "VARBINARY(100)";
    private static final String CHAR_DEFAULT = "CHAR(100)";

    public OnlineFeaturegroupController() {
    }

    protected OnlineFeaturegroupController(Settings settings) {
        this.settings = settings;
    }

    public void dropMySQLTable(Featuregroup featuregroup, Project project, Users user) throws SQLException, FeaturestoreException {
        String query = "DROP TABLE " + featuregroup.getName() + "_" + featuregroup.getVersion() + ";";
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(query, this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()), project, user);
    }

    public void createMySQLTable(Featurestore featurestore, String tableName, List<FeatureGroupFeatureDTO> features, Project project, Users user) throws FeaturestoreException, SQLException {
        String dbName = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject());
        String createStatement = this.buildCreateStatement(dbName, tableName, features);
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(createStatement, dbName, project, user);
    }

    public String buildCreateStatement(String dbName, String tableName, List<FeatureGroupFeatureDTO> features) {
        StringBuilder createStatement = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        createStatement.append("`" + dbName + "`").append(".").append("`" + tableName + "`").append("(");
        ArrayList<String> columns = new ArrayList<String>();
        for (FeatureGroupFeatureDTO feature : features) {
            StringBuilder column = new StringBuilder();
            column.append("`" + feature.getName() + "`").append(" ").append(this.getOnlineType(feature));
            if (feature.getDefaultValue() != null) {
                column.append(" NOT NULL DEFAULT ");
                if (feature.getType().equalsIgnoreCase("string")) {
                    column.append("'").append(feature.getDefaultValue()).append("'");
                } else {
                    column.append(feature.getDefaultValue());
                }
            }
            columns.add(column.toString());
        }
        createStatement.append(StringUtils.join(columns, (String)", "));
        List pkFeatures = features.stream().filter(FeatureGroupFeatureDTO::getPrimary).collect(Collectors.toList());
        if (!pkFeatures.isEmpty()) {
            createStatement.append(", PRIMARY KEY (`");
            createStatement.append(StringUtils.join((Iterable)pkFeatures.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toList()), (String)"`,`"));
            createStatement.append("`)");
        }
        createStatement.append(")");
        createStatement.append("ENGINE=ndbcluster ").append("COMMENT='NDB_TABLE=READ_BACKUP=1'");
        if (!Strings.isNullOrEmpty((String)this.settings.getOnlineFeatureStoreTableSpace())) {
            createStatement.append("/*!50100 TABLESPACE `").append(this.settings.getOnlineFeatureStoreTableSpace()).append("` STORAGE DISK */");
        }
        return createStatement.toString();
    }

    public String buildAlterStatement(String tableName, String dbName, List<FeatureGroupFeatureDTO> featureDTOs) {
        StringBuilder alterTableStatement = new StringBuilder("ALTER TABLE `" + dbName + "`.`" + tableName + "` ");
        ArrayList<String> addColumn = new ArrayList<String>();
        for (FeatureGroupFeatureDTO featureDTO : featureDTOs) {
            StringBuilder add = new StringBuilder("ADD COLUMN `" + featureDTO.getName() + "` " + this.getOnlineType(featureDTO));
            if (featureDTO.getDefaultValue() != null) {
                add.append(" NOT NULL DEFAULT ");
                if (featureDTO.getType().equalsIgnoreCase("string")) {
                    add.append("'" + featureDTO.getDefaultValue() + "'");
                } else {
                    add.append(featureDTO.getDefaultValue() + "");
                }
            } else {
                add.append(" DEFAULT NULL");
            }
            addColumn.add(add.toString());
        }
        alterTableStatement.append(StringUtils.join(addColumn, (String)", ") + ";");
        return alterTableStatement.toString();
    }

    public void alterMySQLTableColumns(Featurestore featurestore, String tableName, List<FeatureGroupFeatureDTO> featureDTOs, Project project, Users user) throws FeaturestoreException, SQLException {
        String dbName = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject());
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(this.buildAlterStatement(tableName, dbName, featureDTOs), dbName, project, user);
    }

    private String getOnlineType(FeatureGroupFeatureDTO featureGroupFeatureDTO) {
        if (!Strings.isNullOrEmpty((String)featureGroupFeatureDTO.getOnlineType())) {
            return featureGroupFeatureDTO.getOnlineType().toLowerCase();
        }
        if (MYSQL_TYPES.contains(featureGroupFeatureDTO.getType().toUpperCase())) {
            return featureGroupFeatureDTO.getType().toLowerCase();
        }
        if (featureGroupFeatureDTO.getType().equalsIgnoreCase("boolean")) {
            return "tinyint";
        }
        if (featureGroupFeatureDTO.getType().equalsIgnoreCase("string")) {
            return CHAR_DEFAULT;
        }
        return VARBINARY_DEFAULT;
    }

    public FeaturegroupPreview getFeaturegroupPreview(Featuregroup featuregroup, Project project, Users user, int limit) throws FeaturestoreException, SQLException {
        String tblName = featuregroup.getName() + "_" + featuregroup.getVersion();
        String query = "SELECT * FROM " + tblName + " LIMIT " + limit;
        String db = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject());
        try {
            return this.onlineFeaturestoreController.executeReadJDBCQuery(query, db, project, user);
        }
        catch (Exception e) {
            return this.onlineFeaturestoreController.executeReadJDBCQuery(query, db, project, user);
        }
    }

    public String getFeaturegroupSchema(Featuregroup featuregroup) throws FeaturestoreException {
        return this.onlineFeaturestoreFacade.getMySQLSchema(this.getTblName(featuregroup), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()));
    }

    public List<FeatureGroupFeatureDTO> getFeaturegroupFeatures(Featuregroup featuregroup) throws FeaturestoreException {
        return this.onlineFeaturestoreFacade.getMySQLFeatures(this.getTblName(featuregroup), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()));
    }

    public Long getFeaturegroupSize(Featuregroup featuregroup) {
        return this.onlineFeaturestoreFacade.getTblSize(this.getTblName(featuregroup), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()));
    }

    private String getTblName(Featuregroup featuregroup) {
        return featuregroup.getName() + "_" + featuregroup.getVersion();
    }
}

