/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.jdbc;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreJdbcConnectorController {
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private SecretsController secretsController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreJdbcConnectorController.class.getName());

    public FeaturestoreJdbcConnector createFeaturestoreJdbcConnector(FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException {
        this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        this.verifyJdbcConnectorArguments(featurestoreJdbcConnectorDTO.getArguments());
        FeaturestoreJdbcConnector featurestoreJdbcConnector = new FeaturestoreJdbcConnector();
        featurestoreJdbcConnector.setArguments(featurestoreJdbcConnectorDTO.getArguments());
        featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        return featurestoreJdbcConnector;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeaturestoreJdbcConnector updateFeaturestoreJdbcConnector(FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, FeaturestoreJdbcConnector featurestoreJdbcConnector) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getConnectionString())) {
            this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
            featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getArguments())) {
            this.verifyJdbcConnectorArguments(featurestoreJdbcConnectorDTO.getArguments());
            featurestoreJdbcConnector.setArguments(featurestoreJdbcConnectorDTO.getArguments());
        }
        return featurestoreJdbcConnector;
    }

    private void verifyJdbcConnectorConnectionString(String connectionString) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)connectionString) || connectionString.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_STRING, Level.FINE, ", the JDBC connection string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyJdbcConnectorArguments(String arguments) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)arguments) && arguments.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_ARGUMENTS, Level.FINE, "JDBC connection arguments should not exceed: 2000 characters");
        }
    }

    public FeaturestoreJdbcConnectorDTO getJdbcConnectorDTO(Users user, Project project, FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO(featurestoreConnector);
        if (featurestoreJdbcConnectorDTO.getName().equals(this.onlineFeaturestoreController.onlineDbUsername(project, user) + "_onlinefeaturestore")) {
            this.setPasswordPlainTextForOnlineJdbcConnector(user, featurestoreJdbcConnectorDTO, project.getName());
        }
        return this.replaceOnlineFsConnectorUrl(featurestoreJdbcConnectorDTO);
    }

    private String getConnectorPlainPasswordFromSecret(Users user, String projectName) {
        String secretName = projectName.concat("_").concat(user.getUsername());
        try {
            SecretPlaintext plaintext = this.secretsController.get(user, secretName);
            return plaintext.getPlaintext();
        }
        catch (UserException e) {
            LOGGER.log(Level.SEVERE, "Could not get the online jdbc connector password for project: " + projectName + ", user: " + user.getEmail());
            return null;
        }
    }

    private void setPasswordPlainTextForOnlineJdbcConnector(Users user, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, String projectName) {
        String connectorPassword = this.getConnectorPlainPasswordFromSecret(user, projectName);
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getArguments()) && !Strings.isNullOrEmpty((String)connectorPassword)) {
            featurestoreJdbcConnectorDTO.setArguments(featurestoreJdbcConnectorDTO.getArguments().replaceFirst("<SECRETPASSWORD>", connectorPassword));
        }
    }

    private FeaturestoreJdbcConnectorDTO replaceOnlineFsConnectorUrl(FeaturestoreJdbcConnectorDTO jdbcConnectorDTO) throws FeaturestoreException {
        String connectionString = "";
        try {
            connectionString = jdbcConnectorDTO.getConnectionString().replace(this.serviceDiscoveryController.constructServiceFQDN(ServiceDiscoveryController.HopsworksService.ONLINEFS_MYSQL), this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.ONLINEFS_MYSQL).getAddress());
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error resolving MySQL DNS name", e.getMessage(), (Throwable)e);
        }
        jdbcConnectorDTO.setConnectionString(connectionString);
        return jdbcConnectorDTO;
    }
}

