/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreDTO;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class FeaturestoreController {
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private Settings settings;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private HiveController hiveController;
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private FeaturestoreConnectorFacade connectorFacade;
    @EJB
    private FeaturestoreStorageConnectorController featurestoreStorageConnectorController;

    public List<FeaturestoreDTO> getFeaturestoresForProject(Project project) throws FeaturestoreException {
        List<Featurestore> featurestores = this.getProjectFeaturestores(project);
        try {
            return featurestores.stream().map(this::convertFeaturestoreToDTO).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof ServiceDiscoveryException) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_INITIALIZATION_ERROR, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public Dataset getProjectFeaturestoreDataset(Project project) throws FeaturestoreException {
        return project.getDatasetCollection().stream().filter(ds -> ds.getDsType() == DatasetType.FEATURESTORE).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.INFO, "Could not find feature store for project: " + project.getName()));
    }

    public Featurestore getProjectFeaturestore(Project project) throws FeaturestoreException {
        Collection dsInProject = project.getDatasetCollection();
        return dsInProject.stream().filter(ds -> ds.getDsType() == DatasetType.FEATURESTORE).map(Dataset::getFeatureStore).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.INFO, "Could not find feature store for project: " + project.getName()));
    }

    private List<Featurestore> getProjectFeaturestores(Project project) {
        Collection dsInProject = project.getDatasetCollection();
        dsInProject.addAll(project.getDatasetSharedWithCollection().stream().filter(DatasetSharedWith::getAccepted).map(DatasetSharedWith::getDataset).collect(Collectors.toList()));
        return dsInProject.stream().filter(ds -> ds.getDsType() == DatasetType.FEATURESTORE).map(Dataset::getFeatureStore).collect(Collectors.toList());
    }

    public FeaturestoreDTO getFeaturestoreForProjectWithName(Project project, String featurestoreName) throws FeaturestoreException {
        try {
            return this.getProjectFeaturestores(project).stream().map(this::convertFeaturestoreToDTO).filter(fs -> fs.getFeaturestoreName().equals(featurestoreName)).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreName: " + featurestoreName + " , project: " + project.getName()));
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof ServiceDiscoveryException) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_INITIALIZATION_ERROR, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public FeaturestoreDTO getFeaturestoreForProjectWithId(Project project, Integer featurestoreId) throws FeaturestoreException {
        try {
            return this.getProjectFeaturestores(project).stream().filter(fs -> fs.getId().equals(featurestoreId)).map(this::convertFeaturestoreToDTO).findAny().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreId: " + featurestoreId + " , project: " + project.getName()));
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof ServiceDiscoveryException) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_INITIALIZATION_ERROR, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public Featurestore getFeaturestoreWithId(Integer id) throws FeaturestoreException {
        Featurestore featurestore = this.featurestoreFacade.findById(id);
        if (featurestore == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreId: " + id);
        }
        return featurestore;
    }

    public Featurestore createProjectFeatureStore(Project project, Users user, String featurestoreName, Dataset trainingDatasetsFolder) throws FeaturestoreException, ProjectException, UserException {
        Long hiveDbId = this.featurestoreFacade.getHiveDatabaseId(featurestoreName);
        Featurestore featurestore = new Featurestore();
        featurestore.setProject(project);
        featurestore.setHiveDbId(hiveDbId);
        featurestore.setCreated(new Date());
        this.featurestoreFacade.persist(featurestore);
        this.activityFacade.persistActivity(" created a new feature store named " + featurestoreName, project, project.getOwner(), ActivityFlag.SERVICE);
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + this.getOfflineFeaturestoreDbName(project), project, project.getOwner(), ActivityFlag.SERVICE);
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + project.getName(), project, project.getOwner(), ActivityFlag.SERVICE);
        this.featurestoreStorageConnectorController.createStorageConnector(user, project, featurestore, this.hopsfsTrainingDatasetConnector(trainingDatasetsFolder));
        this.featurestoreStorageConnectorController.createStorageConnector(user, project, featurestore, this.createOfflineJdbcConnector(featurestoreName));
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + trainingDatasetsFolder.getName(), project, project.getOwner(), ActivityFlag.SERVICE);
        if (this.settings.isOnlineFeaturestore().booleanValue()) {
            this.onlineFeaturestoreController.setupOnlineFeaturestore(user, featurestore);
        }
        return featurestore;
    }

    public FeaturestoreStorageConnectorDTO hopsfsTrainingDatasetConnector(Dataset hopsfsDataset) {
        String name = hopsfsDataset.getName();
        String description = "HOPSFS backend for storing Training Datasets of the Hopsworks Feature Store";
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO();
        featurestoreHopsfsConnectorDTO.setStorageConnectorType(FeaturestoreConnectorType.HOPSFS);
        featurestoreHopsfsConnectorDTO.setName(name);
        featurestoreHopsfsConnectorDTO.setDescription(description);
        featurestoreHopsfsConnectorDTO.setDatasetName(hopsfsDataset.getName());
        return featurestoreHopsfsConnectorDTO;
    }

    public FeaturestoreStorageConnectorDTO createOfflineJdbcConnector(String databaseName) throws FeaturestoreException {
        String hiveEndpoint;
        try {
            hiveEndpoint = this.hiveController.getHiveServerInternalEndpoint();
        }
        catch (ServiceDiscoveryException ex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_NOT_FOUND, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
        }
        String connectionString = "jdbc:hive2://" + hiveEndpoint + "/" + databaseName + ";auth=noSasl;ssl=true;twoWay=true;";
        String arguments = "sslTrustStore,trustStorePassword,sslKeyStore,keyStorePassword";
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO();
        featurestoreJdbcConnectorDTO.setStorageConnectorType(FeaturestoreConnectorType.JDBC);
        featurestoreJdbcConnectorDTO.setName(databaseName);
        featurestoreJdbcConnectorDTO.setDescription("JDBC connector for the Offline Feature Store");
        featurestoreJdbcConnectorDTO.setConnectionString(connectionString);
        featurestoreJdbcConnectorDTO.setArguments(arguments);
        return featurestoreJdbcConnectorDTO;
    }

    private FeaturestoreDTO convertFeaturestoreToDTO(Featurestore featurestore) {
        String hiveDbDescription = this.featurestoreFacade.getHiveDatabaseDescription(featurestore.getHiveDbId());
        FeaturestoreDTO featurestoreDTO = new FeaturestoreDTO(featurestore);
        featurestoreDTO.setFeaturestoreDescription(hiveDbDescription);
        String name = this.featurestoreFacade.getHiveDbName(featurestore.getHiveDbId());
        featurestoreDTO.setFeaturestoreName(name);
        featurestoreDTO.setOfflineFeaturestoreName(name);
        featurestoreDTO.setHdfsStorePath(this.featurestoreFacade.getHiveDbHdfsPath(featurestore.getHiveDbId()));
        featurestoreDTO.setInodeId(this.featurestoreFacade.getFeaturestoreInodeId(featurestore.getHiveDbId()));
        try {
            featurestoreDTO.setHiveEndpoint(this.hiveController.getHiveServerInternalEndpoint());
            if (this.settings.isOnlineFeaturestore().booleanValue() && this.onlineFeaturestoreController.checkIfDatabaseExists(this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject())).booleanValue()) {
                featurestoreDTO.setMysqlServerEndpoint(this.onlineFeaturestoreController.getJdbcURL());
                featurestoreDTO.setOnlineFeaturestoreSize(this.onlineFeaturestoreController.getDbSize(featurestore));
                featurestoreDTO.setOnlineFeaturestoreName(featurestore.getProject().getName());
                featurestoreDTO.setOnlineEnabled(true);
            }
        }
        catch (ServiceDiscoveryException ex) {
            throw new RuntimeException(ex);
        }
        featurestoreDTO.setNumFeatureGroups(this.featuregroupFacade.countByFeaturestore(featurestore));
        featurestoreDTO.setNumTrainingDatasets(this.trainingDatasetFacade.countByFeaturestore(featurestore));
        featurestoreDTO.setNumStorageConnectors(this.connectorFacade.countByFeaturestore(featurestore));
        return featurestoreDTO;
    }

    public String getOfflineFeaturestoreDbName(Project project) {
        return project.getName().toLowerCase() + "_featurestore";
    }
}

