/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.project;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.airflow.AirflowManager;
import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWithFacade;
import io.hops.hopsworks.common.dao.hdfs.HdfsDirectoryWithQuotaFeatureFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dao.jobs.quota.YarnProjectsQuotaFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterFacade;
import io.hops.hopsworks.common.dao.kafka.HopsKafkaAdminClient;
import io.hops.hopsworks.common.dao.kafka.ProjectTopicsFacade;
import io.hops.hopsworks.common.dao.kafka.TopicAclsFacade;
import io.hops.hopsworks.common.dao.log.operation.OperationsLogFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.service.ProjectServiceFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.dataset.FolderNameValidator;
import io.hops.hopsworks.common.elastic.ElasticController;
import io.hops.hopsworks.common.experiments.tensorboard.TensorBoardController;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.FsPermissions;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.jobs.JobController;
import io.hops.hopsworks.common.jobs.execution.ExecutionController;
import io.hops.hopsworks.common.jobs.yarn.YarnLogUtil;
import io.hops.hopsworks.common.jupyter.JupyterController;
import io.hops.hopsworks.common.kafka.KafkaController;
import io.hops.hopsworks.common.kafka.SubjectsCompatibilityController;
import io.hops.hopsworks.common.kafka.SubjectsController;
import io.hops.hopsworks.common.message.MessageController;
import io.hops.hopsworks.common.project.AccessCredentialsDTO;
import io.hops.hopsworks.common.project.ProjectDTO;
import io.hops.hopsworks.common.project.ProjectHandler;
import io.hops.hopsworks.common.project.QuotasDTO;
import io.hops.hopsworks.common.project.TourProjectType;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.python.environment.EnvironmentController;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.security.CertificatesController;
import io.hops.hopsworks.common.serving.ServingController;
import io.hops.hopsworks.common.user.UsersController;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.yarn.YarnClientService;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.KafkaException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.SchemaException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.ServingException;
import io.hops.hopsworks.exceptions.TensorBoardException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.hdfs.HdfsDirectoryWithQuotaFeature;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.hdfs.inode.InodeView;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsGroups;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.yarn.LocalResourceDTO;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.jobs.quota.YarnPriceMultiplicator;
import io.hops.hopsworks.persistence.entity.jobs.quota.YarnProjectsQuota;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import io.hops.hopsworks.persistence.entity.kafka.ProjectTopics;
import io.hops.hopsworks.persistence.entity.kafka.schemas.SchemaCompatibility;
import io.hops.hopsworks.persistence.entity.log.operation.OperationType;
import io.hops.hopsworks.persistence.entity.log.operation.OperationsLog;
import io.hops.hopsworks.persistence.entity.project.PaymentType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServiceEnum;
import io.hops.hopsworks.persistence.entity.project.team.ProjectRoleTypes;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeamPK;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.restutils.RESTException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ProjectController {
    private static final Logger LOGGER = Logger.getLogger(ProjectController.class.getName());
    @EJB
    protected UsersController usersController;
    @EJB
    protected JobController jobController;
    @Inject
    protected ExecutionController executionController;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private YarnProjectsQuotaFacade yarnProjectsQuotaFacade;
    @EJB
    private UserFacade userFacade;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private ProjectServiceFacade projectServicesFacade;
    @EJB
    private InodeFacade inodes;
    @EJB
    private InodeController inodeController;
    @EJB
    private DatasetController datasetController;
    @EJB
    private DatasetSharedWithFacade datasetSharedWithFacade;
    @EJB
    private Settings settings;
    @EJB
    private CertsFacade userCertsFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private YarnClientService ycs;
    @EJB
    private InodeFacade inodeFacade;
    @EJB
    private OperationsLogFacade operationsLogFacade;
    @EJB
    private EnvironmentController environmentController;
    @EJB
    private JobFacade jobFacade;
    @EJB
    private SubjectsCompatibilityController subjectsCompatibilityController;
    @EJB
    private KafkaController kafkaController;
    @EJB
    private TensorBoardController tensorBoardController;
    @EJB
    private ElasticController elasticController;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private HiveController hiveController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private CertificatesController certificatesController;
    @EJB
    private MessageController messageController;
    @EJB
    private HdfsDirectoryWithQuotaFeatureFacade hdfsDirectoryWithQuotaFeatureFacade;
    @EJB
    private FeaturestoreController featurestoreController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @Inject
    private ServingController servingController;
    @Inject
    @Any
    private Instance<ProjectHandler> projectHandlers;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private JupyterController jupyterController;
    @EJB
    private JupyterFacade jupyterFacade;
    @EJB
    private AirflowManager airflowManager;
    @EJB
    private ProjectServiceFacade projectServiceFacade;
    @EJB
    private HopsKafkaAdminClient hopsKafkaAdminClient;
    @EJB
    private ProjectTopicsFacade projectTopicsFacade;
    @EJB
    private TopicAclsFacade topicAclsFacade;
    @EJB
    private SubjectsController subjectsController;
    @EJB
    private HopsFSProvenanceController fsProvController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createProject(ProjectDTO projectDTO, Users owner, String sessionId) throws DatasetException, GenericException, KafkaException, ProjectException, UserException, HopsSecurityException, ServiceException, FeaturestoreException, ElasticException, SchemaException, IOException {
        Long startTime = System.currentTimeMillis();
        String projectName = projectDTO.getProjectName();
        FolderNameValidator.isValidProjectName(this.projectUtils, projectName);
        ArrayList<ProjectServiceEnum> projectServices = new ArrayList<ProjectServiceEnum>();
        if (projectDTO.getServices() != null) {
            for (String s : projectDTO.getServices()) {
                ProjectServiceEnum se = ProjectServiceEnum.valueOf((String)s.toUpperCase());
                projectServices.add(se);
            }
        }
        LOGGER.log(Level.FINE, () -> "PROJECT CREATION TIME. Step 1: " + (System.currentTimeMillis() - startTime));
        DistributedFileSystemOps dfso = null;
        Project project = null;
        try {
            dfso = this.dfs.getDfsOps();
            try {
                project = this.createProject(projectName, owner, projectDTO.getDescription(), dfso);
            }
            catch (EJBException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                Path dummy = new Path("/tmp/" + projectName);
                try {
                    dfso.rm(dummy, true);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, null, e);
                }
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_EXISTS, Level.SEVERE, "project: " + projectName, ex.getMessage(), (Throwable)ex);
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 2 (hdfs): {0}", System.currentTimeMillis() - startTime);
            this.verifyProject(project, dfso, sessionId);
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 3 (verify): {0}", System.currentTimeMillis() - startTime);
            for (ProjectHandler projectHandler : this.projectHandlers) {
                try {
                    projectHandler.preCreate(project);
                }
                catch (Exception e) {
                    this.cleanup(project, sessionId, null, true, owner);
                    throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_PRECREATE_ERROR, Level.SEVERE, e.getMessage(), "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), (Throwable)e);
                }
            }
            ArrayList projectCreationFutures = new ArrayList();
            try {
                projectCreationFutures.add(this.certificatesController.generateCertificates(project, owner));
            }
            catch (Exception ex) {
                this.cleanup(project, sessionId, projectCreationFutures, true, owner);
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERT_CREATION_ERROR, Level.SEVERE, "project: " + project.getName() + "owner: " + owner.getUsername(), ex.getMessage(), (Throwable)ex);
            }
            String username = this.hdfsUsersController.getHdfsUserName(project, owner);
            if (username == null || username.isEmpty()) {
                this.cleanup(project, sessionId, projectCreationFutures, true, owner);
                throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.SEVERE, "project: " + project.getName() + "owner: " + owner.getUsername());
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 4 (certs): {0}", System.currentTimeMillis() - startTime);
            ProvTypeDTO provType = this.settings.getProvType().dto;
            try {
                this.mkProjectDIR(projectName, dfso);
                this.fsProvController.updateProjectProvType(project, provType, dfso);
            }
            catch (ProvenanceException | IOException | EJBException ex) {
                this.cleanup(project, sessionId, projectCreationFutures, true, owner);
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_FOLDER_NOT_CREATED, Level.SEVERE, "project: " + projectName, ex.getMessage(), ex);
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 5 (folders): {0}", System.currentTimeMillis() - startTime);
            try {
                this.setProjectInode(project, dfso);
            }
            catch (IOException | EJBException ex) {
                this.cleanup(project, sessionId, projectCreationFutures, true, owner);
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_INODE_CREATION_ERROR, Level.SEVERE, "project: " + projectName, ex.getMessage(), ex);
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 6 (inodes): {0}", System.currentTimeMillis() - startTime);
            try {
                this.setProjectOwnerAndQuotas(project, this.settings.getHdfsDefaultQuotaInMBs(), dfso, owner);
            }
            catch (IOException | EJBException ex) {
                this.cleanup(project, sessionId, projectCreationFutures, true, owner);
                throw new ProjectException(RESTCodes.ProjectErrorCode.QUOTA_ERROR, Level.SEVERE, "project: " + project.getName(), ex.getMessage(), ex);
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 7 (quotas): {0}", System.currentTimeMillis() - startTime);
            try {
                this.hdfsUsersController.addProjectFolderOwner(project, dfso);
                this.createProjectLogResources(owner, project, dfso);
            }
            catch (IOException | EJBException ex) {
                this.cleanup(project, sessionId, projectCreationFutures);
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_SET_PERMISSIONS_ERROR, Level.SEVERE, "project: " + projectName, ex.getMessage(), ex);
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 8 (logs): {0}", System.currentTimeMillis() - startTime);
            try {
                project = this.environmentController.createEnv(project, owner);
            }
            catch (PythonException | EJBException ex) {
                this.cleanup(project, sessionId, projectCreationFutures);
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_ANACONDA_ENABLE_ERROR, Level.SEVERE, "project: " + projectName, ex.getMessage(), ex);
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 9 (env): {0}", System.currentTimeMillis() - startTime);
            try {
                this.elasticController.deleteProjectIndices(project);
                this.elasticController.deleteProjectSavedObjects(projectName);
                LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 10 (elastic cleanup): {0}", System.currentTimeMillis() - startTime);
            }
            catch (ElasticException ex) {
                LOGGER.log(Level.FINE, "Error while cleaning old project indices", ex);
            }
            this.logProject(project, OperationType.Add);
            for (ProjectServiceEnum service : projectServices) {
                try {
                    projectCreationFutures.addAll(this.addService(project, service, owner, dfso, provType));
                }
                catch (RESTException | IOException ex) {
                    this.cleanup(project, sessionId, projectCreationFutures);
                    throw ex;
                }
            }
            try {
                for (Future f : projectCreationFutures) {
                    if (f == null) continue;
                    f.get();
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.log(Level.SEVERE, "Error while waiting for the certificate generation thread to finish. Will try to cleanup...", ex);
                this.cleanup(project, sessionId, projectCreationFutures);
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERT_CREATION_ERROR, Level.SEVERE);
            }
            for (ProjectHandler projectHandler : this.projectHandlers) {
                try {
                    projectHandler.postCreate(project);
                }
                catch (Exception e) {
                    this.cleanup(project, sessionId, projectCreationFutures);
                    throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_POSTCREATE_ERROR, Level.SEVERE, e.getMessage(), "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), (Throwable)e);
                }
            }
            Iterator iterator = project;
            return iterator;
        }
        finally {
            if (dfso != null) {
                dfso.close();
            }
            LOGGER.log(Level.FINE, "PROJECT CREATION TIME. Step 10 (close): {0}", System.currentTimeMillis() - startTime);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void verifyProject(Project project, DistributedFileSystemOps dfso, String sessionId) throws ProjectException, GenericException {
        String severity = "Possible inconsistency,  Please contact the administrator.";
        try {
            if (this.existingProjectFolder(project)) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_FOLDER_EXISTS, Level.INFO, "Possible inconsistency,  Please contact the administrator.", project.getName());
            }
            if (!this.noExistingUser(project.getName())) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_USER_EXISTS, Level.INFO, "Possible inconsistency,  Please contact the administrator.", project.getName());
            }
            if (!this.noExistingGroup(project.getName())) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_GROUP_EXISTS, Level.INFO, "Possible inconsistency,  Please contact the administrator.", project.getName());
            }
            if (!this.verifyQuota(project.getName())) {
                this.cleanup(project, sessionId, true);
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_QUOTA_EXISTS, Level.INFO, project.getName());
            }
            if (!this.verifyLogs(dfso, project.getName())) {
                this.cleanup(project, sessionId, true);
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_LOGS_EXIST, Level.INFO, "Possible inconsistency,  Please contact the administrator.", project.getName());
            }
        }
        catch (IOException | EJBException ex) {
            LOGGER.log(Level.SEVERE, RESTCodes.ProjectErrorCode.PROJECT_VERIFICATIONS_FAILED.toString(), ex);
            this.cleanup(project, sessionId, true);
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_VERIFICATIONS_FAILED, Level.SEVERE);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private Project createProject(String projectName, Users user, String projectDescription, DistributedFileSystemOps dfso) throws ProjectException {
        if (user == null) {
            throw new IllegalArgumentException("User was not provided.");
        }
        if (this.projectFacade.numProjectsLimitReached(user)) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.NUM_PROJECTS_LIMIT_REACHED, Level.FINE, "projects already created: " + user.getNumCreatedProjects() + ", out of a maximum: " + user.getMaxNumProjects());
        }
        if (this.projectFacade.projectExists(projectName)) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_EXISTS, Level.FINE, "project: " + projectName);
        }
        Date now = new Date();
        Project project = new Project(projectName, user, now, PaymentType.PREPAID);
        project.setKafkaMaxNumTopics(Integer.valueOf(this.settings.getKafkaMaxNumTopics()));
        project.setDescription(projectDescription);
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(1, 10);
        project.setRetentionPeriod(cal.getTime());
        Path dummy = new Path("/tmp/" + projectName);
        try {
            dfso.touchz(dummy);
            project.setInode(this.inodeController.getInodeAtPath(dummy.toString()));
        }
        catch (IOException ex) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_INODE_CREATION_ERROR, Level.SEVERE, "Couldn't get the dummy Inode at: /tmp/" + projectName, ex.getMessage(), (Throwable)ex);
        }
        this.projectFacade.persistProject(project);
        this.projectFacade.flushEm();
        this.usersController.increaseNumCreatedProjects(user.getUid());
        return project;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void setProjectInode(Project project, DistributedFileSystemOps dfso) throws IOException {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        project.setInode(projectInode);
        this.projectFacade.mergeProject(project);
        this.projectFacade.flushEm();
        Path dumy = new Path("/tmp/" + project.getName());
        dfso.rm(dumy, true);
    }

    private boolean existingProjectFolder(Project project) {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        if (projectInode != null) {
            LOGGER.log(Level.WARNING, "project folder existing for project {0}", project.getName());
            return true;
        }
        return false;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private boolean noExistingUser(String projectName) {
        List<HdfsUsers> hdfsUsers = this.hdfsUsersController.getAllProjectHdfsUsers(projectName);
        if (hdfsUsers != null && !hdfsUsers.isEmpty()) {
            LOGGER.log(Level.WARNING, "hdfs users exist for project {0}", projectName);
            return false;
        }
        return true;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private boolean noExistingGroup(String projectName) {
        List<HdfsGroups> hdfsGroups = this.hdfsUsersController.getAllProjectHdfsGroups(projectName);
        if (hdfsGroups != null && !hdfsGroups.isEmpty()) {
            LOGGER.log(Level.WARNING, () -> "hdfs group(s) exist for project: " + projectName + ", group(s): " + Arrays.toString(hdfsGroups.toArray()));
            return false;
        }
        return true;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private boolean verifyQuota(String projectName) {
        YarnProjectsQuota projectsQuota = this.yarnProjectsQuotaFacade.findByProjectName(projectName);
        if (projectsQuota != null) {
            LOGGER.log(Level.WARNING, "quota existing for project {0}", projectName);
            return false;
        }
        return true;
    }

    private boolean verifyLogs(DistributedFileSystemOps dfso, String projectName) throws IOException {
        FileStatus[] logs;
        Path logPath = new Path(this.getYarnAgregationLogPath());
        for (FileStatus log : logs = dfso.listStatus(logPath)) {
            if (!log.getPath().getName().startsWith(projectName + "__")) continue;
            LOGGER.log(Level.WARNING, "logs existing for project {0}", projectName);
            return false;
        }
        return true;
    }

    private String getYarnAgregationLogPath() {
        File yarnConfFile = new File(this.settings.getHadoopConfDir(), "yarn-site.xml");
        if (!yarnConfFile.exists()) {
            LOGGER.log(Level.SEVERE, "Unable to locate configuration file in {0}", yarnConfFile);
            throw new IllegalStateException("No yarn conf file: yarn-site.xml");
        }
        Configuration conf = new Configuration();
        conf.addResource(new Path(yarnConfFile.getAbsolutePath()));
        return conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs");
    }

    public void createProjectLogResources(Users user, Project project, DistributedFileSystemOps dfso) throws IOException, DatasetException, HopsSecurityException {
        for (Settings.BaseDataset ds : Settings.BaseDataset.values()) {
            Path subDirPath;
            this.datasetController.createDataset(user, project, ds.getName(), ds.getDescription(), -1, Provenance.Type.DISABLED.dto, false, DatasetAccessPermission.EDITABLE, dfso);
            Path dsPath = new Path(Utils.getProjectPath(project.getName()) + ds.getName());
            FileStatus fstatus = dfso.getFileStatus(dsPath);
            if (ds.equals((Object)Settings.BaseDataset.RESOURCES)) {
                String[] subResources;
                for (String string : subResources = this.settings.getResourceDirs().split(";")) {
                    subDirPath = new Path(dsPath, string);
                    this.datasetController.createSubDirectory(project, subDirPath, -1, "", false, dfso);
                    dfso.setOwner(subDirPath, fstatus.getOwner(), fstatus.getGroup());
                }
            } else if (ds.equals((Object)Settings.BaseDataset.LOGS)) {
                dfso.setStoragePolicy(dsPath, this.settings.getHdfsLogStoragePolicy());
                JobType[] jobTypes = new JobType[]{JobType.SPARK, JobType.PYSPARK, JobType.FLINK};
                for (String string : jobTypes) {
                    subDirPath = new Path(dsPath, string.getName());
                    this.datasetController.createSubDirectory(project, subDirPath, -1, "", false, dfso);
                    dfso.setOwner(subDirPath, fstatus.getOwner(), fstatus.getGroup());
                }
            }
            this.datasetController.generateReadme(dfso, ds.getName(), ds.getDescription(), project.getName());
            Path readmePath = new Path(dsPath, "README.md");
            dfso.setOwner(readmePath, fstatus.getOwner(), fstatus.getGroup());
        }
    }

    public Project findProjectById(Integer id) throws ProjectException {
        Project project = this.projectFacade.find(id);
        if (project == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + id);
        }
        return project;
    }

    public Project findProjectByName(String projectName) throws ProjectException {
        Project project = this.projectFacade.findByName(projectName);
        if (project == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectName: " + projectName);
        }
        return project;
    }

    private List<Future<?>> addService(Project project, ProjectServiceEnum service, Users user, DistributedFileSystemOps dfso, ProvTypeDTO projectProvCore) throws ProjectException, ServiceException, DatasetException, HopsSecurityException, UserException, FeaturestoreException, ElasticException, SchemaException, KafkaException, IOException {
        return this.addService(project, service, user, dfso, dfso, projectProvCore);
    }

    public List<Future<?>> addService(Project project, ProjectServiceEnum service, Users user, DistributedFileSystemOps dfso, DistributedFileSystemOps udfso, ProvTypeDTO projectProvCore) throws ProjectException, ServiceException, DatasetException, HopsSecurityException, FeaturestoreException, ElasticException, SchemaException, KafkaException, IOException, UserException {
        ArrayList futureList = new ArrayList();
        if (this.projectServicesFacade.isServiceEnabledForProject(project, service)) {
            return null;
        }
        switch (service) {
            case JUPYTER: {
                this.addServiceDataset(project, user, Settings.ServiceDataset.JUPYTER, dfso, udfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.DATASET));
                if (this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.JOBS)) break;
                this.addKibana(project, user);
                this.addServiceDataset(project, user, Settings.ServiceDataset.EXPERIMENTS, dfso, udfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.EXPERIMENT));
                break;
            }
            case HIVE: {
                this.addServiceHive(project, user, dfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.HIVE));
                break;
            }
            case SERVING: {
                futureList.add(this.addServiceServing(project, user, dfso, udfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.MODEL)));
                break;
            }
            case JOBS: {
                if (this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.JUPYTER)) break;
                this.addServiceDataset(project, user, Settings.ServiceDataset.EXPERIMENTS, dfso, udfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.EXPERIMENT));
                this.addKibana(project, user);
                break;
            }
            case FEATURESTORE: {
                this.addServiceDataset(project, user, Settings.ServiceDataset.TRAININGDATASETS, dfso, udfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.TRAINING_DATASET));
                this.addServiceFeaturestore(project, user, dfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.FEATURE));
                this.addServiceDataset(project, user, Settings.ServiceDataset.DATAVALIDATION, dfso, udfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.DATASET));
                this.addServiceDataset(project, user, Settings.ServiceDataset.STATISTICS, dfso, udfso, Provenance.Type.DISABLED.dto);
                if (this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.JOBS) || this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.JUPYTER)) break;
                this.addServiceDataset(project, user, Settings.ServiceDataset.EXPERIMENTS, dfso, udfso, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.EXPERIMENT));
                this.addKibana(project, user);
                break;
            }
            case KAFKA: {
                this.subjectsCompatibilityController.setProjectCompatibility(project, SchemaCompatibility.BACKWARD);
                this.subjectsController.registerNewSubject(project, "inferenceschema", "{\"fields\": [{\"name\": \"modelId\", \"type\": \"int\"}, { \"name\": \"modelName\", \"type\": \"string\" }, {  \"name\": \"modelVersion\",  \"type\": \"int\" }, {  \"name\": \"requestTimestamp\",  \"type\": \"long\" }, {  \"name\": \"responseHttpCode\",  \"type\": \"int\" }, {  \"name\": \"inferenceRequest\",  \"type\": \"string\" }, {  \"name\": \"inferenceResponse\",  \"type\": \"string\" }  ],  \"name\": \"inferencelog\",  \"type\": \"record\" }", true);
                this.subjectsCompatibilityController.setSubjectCompatibility(project, "inferenceschema", SchemaCompatibility.NONE);
                this.subjectsController.registerNewSubject(project, "inferenceschema", "{\"fields\": [{\"name\": \"modelId\", \"type\": \"int\"}, { \"name\": \"modelName\", \"type\": \"string\" }, {  \"name\": \"modelVersion\",  \"type\": \"int\" }, {  \"name\": \"requestTimestamp\",  \"type\": \"long\" }, {  \"name\": \"responseHttpCode\",  \"type\": \"int\" }, {  \"name\": \"inferenceRequest\",  \"type\": \"string\" }, {  \"name\": \"inferenceResponse\",  \"type\": \"string\" }, { \"name\": \"servingType\", \"type\": \"string\" } ],  \"name\": \"inferencelog\",  \"type\": \"record\" }", true);
            }
        }
        this.projectServicesFacade.addServiceForProject(project, service);
        this.logActivity(" added new service " + service.toString(), user, project, ActivityFlag.SERVICE);
        return futureList;
    }

    private void addServiceDataset(Project project, Users user, Settings.ServiceDataset ds, DistributedFileSystemOps dfso, DistributedFileSystemOps udfso, ProvTypeDTO datasetProvCore) throws DatasetException, HopsSecurityException, ProjectException {
        try {
            String datasetName = ds.getName();
            if (ds == Settings.ServiceDataset.TRAININGDATASETS) {
                datasetName = project.getName() + "_" + datasetName;
            }
            this.datasetController.createDataset(user, project, datasetName, ds.getDescription(), -1, datasetProvCore, false, DatasetAccessPermission.EDITABLE, dfso);
            this.datasetController.generateReadme(udfso, datasetName, ds.getDescription(), project.getName());
            if (dfso == udfso && udfso.getEffectiveUser().equals(this.dfs.getLoginUser().getUserName())) {
                StringBuilder dsStrBuilder = new StringBuilder();
                dsStrBuilder.append(Utils.getProjectPath(project.getName())).append(datasetName);
                Path dsPath = new Path(dsStrBuilder.toString());
                FileStatus fstatus = dfso.getFileStatus(dsPath);
                Path readmePath = new Path(dsPath, "README.md");
                dfso.setOwner(readmePath, fstatus.getOwner(), fstatus.getGroup());
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Could not create dir: " + ds.getName(), ex);
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_SERVICE_ADD_FAILURE, Level.SEVERE, "service: " + ds.toString(), ex.getMessage(), (Throwable)ex);
        }
    }

    private void addServiceHive(Project project, Users user, DistributedFileSystemOps dfso, ProvTypeDTO datasetProvCore) throws ProjectException {
        try {
            this.hiveController.createDatabase(project.getName(), "Project general-purpose Hive database");
            this.hiveController.createDatasetDb(project, user, dfso, project.getName(), datasetProvCore);
        }
        catch (ServiceDiscoveryException | IOException | SQLException ex) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HIVEDB_CREATE_ERROR, Level.SEVERE, "project: " + project.getName(), ex.getMessage(), ex);
        }
    }

    private Future<CertificatesController.CertsResult> addServiceServing(Project project, Users user, DistributedFileSystemOps dfso, DistributedFileSystemOps udfso, ProvTypeDTO datasetProvCore) throws ProjectException, DatasetException, HopsSecurityException, ElasticException, ServiceException, SchemaException, FeaturestoreException, KafkaException, IOException, UserException {
        this.addServiceDataset(project, user, Settings.ServiceDataset.SERVING, dfso, udfso, datasetProvCore);
        this.elasticController.createIndexPattern(project, user, project.getName().toLowerCase() + "_serving-*");
        if (!this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.KAFKA)) {
            this.addService(project, ProjectServiceEnum.KAFKA, user, dfso, udfso, datasetProvCore);
        }
        return this.addServingManager(project);
    }

    private Future<CertificatesController.CertsResult> addServingManager(Project project) throws HopsSecurityException, IOException {
        Users servingManagerUser = this.userFacade.findByUsername("srvmanager");
        ProjectTeamPK stp = new ProjectTeamPK(project.getId(), servingManagerUser.getEmail());
        ProjectTeam st = new ProjectTeam(stp);
        st.setTeamRole(ProjectRoleTypes.DATA_SCIENTIST.getRole());
        st.setTimestamp(new Date());
        st.setUser(servingManagerUser);
        st.setProject(project);
        this.projectTeamFacade.persistProjectTeam(st);
        this.hdfsUsersController.addNewMember(st);
        Future<CertificatesController.CertsResult> certsResultFuture = null;
        try {
            certsResultFuture = this.certificatesController.generateCertificates(project, servingManagerUser);
        }
        catch (Exception e) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERT_CREATION_ERROR, Level.SEVERE, "project: " + project.getName() + "owner: servingmanager", e.getMessage(), (Throwable)e);
        }
        return certsResultFuture;
    }

    private void addServiceFeaturestore(Project project, Users user, DistributedFileSystemOps dfso, ProvTypeDTO datasetProvCore) throws FeaturestoreException, ProjectException, UserException {
        String featurestoreName = this.featurestoreController.getOfflineFeaturestoreDbName(project);
        try {
            this.hiveController.createDatabase(featurestoreName, "Featurestore database for project: " + project.getName());
            Dataset trainingDatasets = this.datasetController.getByProjectAndDsName(project, null, project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName());
            Featurestore featurestore = this.featurestoreController.createProjectFeatureStore(project, user, featurestoreName, trainingDatasets);
            this.hiveController.createDatasetDb(project, user, dfso, featurestoreName, DatasetType.FEATURESTORE, featurestore, datasetProvCore);
        }
        catch (ServiceDiscoveryException | IOException | SQLException ex) {
            LOGGER.log(Level.SEVERE, RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATURESTORE.getMessage(), ex);
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATURESTORE, Level.SEVERE, "project: " + project.getName(), ex.getMessage(), ex);
        }
    }

    public boolean updateProjectDescription(Project project, String projectDescr, Users user) {
        if (project.getDescription() == null || !project.getDescription().equals(projectDescr)) {
            project.setDescription(projectDescr);
            this.projectFacade.mergeProject(project);
            this.logProject(project, OperationType.Update);
            this.logActivity(" changed project description " + projectDescr, user, project, ActivityFlag.PROJECT);
            return true;
        }
        return false;
    }

    public boolean updateProjectRetention(Project project, Date projectRetention, Users user) {
        if (project.getRetentionPeriod() == null || !project.getRetentionPeriod().equals(projectRetention)) {
            project.setRetentionPeriod(projectRetention);
            this.projectFacade.mergeProject(project);
            this.logProject(project, OperationType.Update);
            this.logActivity(" changed project retention " + projectRetention, user, project, ActivityFlag.PROJECT);
            return true;
        }
        return false;
    }

    private void addProjectOwner(Project project, Users user) {
        ProjectTeamPK stp = new ProjectTeamPK(project.getId(), user.getEmail());
        ProjectTeam st = new ProjectTeam(stp);
        st.setTeamRole(ProjectRoleTypes.DATA_OWNER.getRole());
        st.setTimestamp(new Date());
        st.setProject(project);
        st.setUser(user);
        project.getProjectTeamCollection().add(st);
        this.projectFacade.update(project);
    }

    private String mkProjectDIR(String projectName, DistributedFileSystemOps dfso) throws IOException {
        boolean rootDirCreated;
        String rootDir = "Projects";
        if (!dfso.isDir(File.separator + rootDir)) {
            Path location = new Path(File.separator + rootDir);
            rootDirCreated = dfso.mkdir(location, FsPermission.getDirDefault());
            dfso.setPermission(location, FsPermissions.rwxrwxr_x);
            dfso.setStoragePolicy(location, this.settings.getHdfsBaseStoragePolicy());
        } else {
            rootDirCreated = true;
        }
        String projectPath = Utils.getProjectPath(projectName);
        boolean projectDirCreated = dfso.mkdir(projectPath);
        if (rootDirCreated && projectDirCreated) {
            return projectPath;
        }
        return null;
    }

    public void removeProject(String userMail, int projectId, String sessionId) throws ProjectException, GenericException {
        Project project = this.projectFacade.find(projectId);
        if (project == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + projectId);
        }
        Users user = this.userFacade.findByEmail(userMail);
        if (!project.getOwner().equals((Object)user) && !this.usersController.isUserInRole(user, "HOPS_ADMIN")) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_REMOVAL_NOT_ALLOWED, Level.FINE);
        }
        this.topicAclsFacade.removeAclForProject(project);
        this.cleanup(project, sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] forceCleanup(String projectName, String userEmail, String sessionId) {
        CleanupLogger cleanupLogger = new CleanupLogger(projectName);
        DistributedFileSystemOps dfso = null;
        YarnClientWrapper yarnClientWrapper = null;
        try {
            dfso = this.dfs.getDfsOps();
            yarnClientWrapper = this.ycs.getYarnClientSuper(this.settings.getConfiguration());
            Project project = this.projectFacade.findByName(projectName);
            if (project != null) {
                cleanupLogger.logSuccess("Project found in the database");
                for (ProjectHandler projectHandler : this.projectHandlers) {
                    try {
                        projectHandler.preDelete(project);
                        cleanupLogger.logSuccess("Handler " + projectHandler.getClassName() + " successfully run");
                    }
                    catch (Exception e) {
                        cleanupLogger.logError("Error running handler: " + projectHandler.getClassName() + " during project cleanup");
                        cleanupLogger.logError(e.getMessage());
                    }
                }
                try {
                    this.updateProjectTeamRole(project, ProjectRoleTypes.UNDER_REMOVAL);
                    cleanupLogger.logSuccess("Updated team role");
                }
                catch (Exception ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                List<ApplicationReport> projectApps = null;
                try {
                    Collection team = project.getProjectTeamCollection();
                    HashSet<String> hdfsUsers = new HashSet<String>();
                    for (ProjectTeam pt : team) {
                        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, pt.getUser());
                        hdfsUsers.add(hdfsUsername);
                    }
                    projectApps = this.getYarnApplications(hdfsUsers, yarnClientWrapper.getYarnClient());
                    cleanupLogger.logSuccess("Gotten Yarn applications");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when reading YARN apps during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.killYarnJobs(project);
                    cleanupLogger.logSuccess("Killed Yarn jobs");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when killing YARN jobs during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeJupyter(project);
                    cleanupLogger.logSuccess("Removed Jupyter");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing Anaconda during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.waitForJobLogs(projectApps, yarnClientWrapper.getYarnClient());
                    cleanupLogger.logSuccess("Gotten logs for jobs");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when getting Yarn logs during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.logProject(project, OperationType.Delete);
                    cleanupLogger.logSuccess("Logged project removal");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when logging project removal during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    Path path = new Path(Utils.getProjectPath(project.getName()));
                    this.changeOwnershipToSuperuser(path, dfso);
                    cleanupLogger.logSuccess("Changed ownership of root Project dir");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when changing ownership of root Project dir during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                Path dummy = new Path("/tmp/" + project.getName());
                try {
                    this.changeOwnershipToSuperuser(dummy, dfso);
                    cleanupLogger.logSuccess("Changed ownership of dummy inode");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when changing ownership of dummy inode during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeKafkaTopics(project);
                    cleanupLogger.logSuccess("Removed Kafka topics");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing kafka topics during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.certificatesController.revokeProjectCertificates(project);
                    cleanupLogger.logSuccess("Removed certificates");
                }
                catch (HopsSecurityException ex) {
                    if (ex.getErrorCode() != RESTCodes.SecurityErrorCode.CERTIFICATE_NOT_FOUND) {
                        cleanupLogger.logError("Error when removing certificates during project cleanup");
                        cleanupLogger.logError(ex.getMessage());
                    }
                }
                catch (GenericException | IOException ex) {
                    cleanupLogger.logError("Error when removing certificates during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                List<HdfsUsers> usersToClean = this.getUsersToClean(project);
                List<HdfsGroups> groupsToClean = this.getGroupsToClean(project);
                try {
                    this.removeProjectRelatedFiles(usersToClean, dfso);
                    cleanupLogger.logSuccess("Removed project related files");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing project-related files during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeQuotas(project);
                    cleanupLogger.logSuccess("Removed quotas");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing quota during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.fixSharedDatasets(project, dfso);
                    cleanupLogger.logSuccess("Fixed shared datasets");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when changing ownership during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.hiveController.dropDatabases(project, dfso, true);
                    cleanupLogger.logSuccess("Removed Hive db");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing hive db during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeElasticsearch(project);
                    cleanupLogger.logSuccess("Removed ElasticSearch");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing elastic during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeGroupAndUsers(groupsToClean, usersToClean);
                    cleanupLogger.logSuccess("Removed HDFS Groups and Users");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing HDFS groups/users during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeTensorBoard(project);
                    cleanupLogger.logSuccess("Removed local TensorBoards");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing running TensorBoards during project cleanup");
                }
                try {
                    this.servingController.deleteServings(project);
                    cleanupLogger.logSuccess("Removed servings");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing serving instances");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.airflowManager.onProjectRemoval(project);
                    cleanupLogger.logSuccess("Removed Airflow DAGs and security references");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error while cleaning Airflow DAGs and security references");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeCertificatesFromMaterializer(project);
                    cleanupLogger.logSuccess("Removed all X.509 certificates related to the Project from CertificateMaterializer");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error while force removing Project certificates from CertificateMaterializer");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeAnacondaEnv(project);
                    cleanupLogger.logSuccess("Removed conda envs");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing conda envs during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    dfso.rm(dummy, true);
                    cleanupLogger.logSuccess("Removed dummy Inode");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing dummy Inode during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeProjectFolder(project.getName(), dfso);
                    cleanupLogger.logSuccess("Removed root Project folder");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Error when removing root Project dir during project cleanup");
                    cleanupLogger.logError(ex.getMessage());
                }
                for (ProjectHandler projectHandler : this.projectHandlers) {
                    try {
                        projectHandler.postDelete(project);
                        cleanupLogger.logSuccess("Handler " + projectHandler.getClassName() + " successfully run");
                    }
                    catch (Exception e) {
                        cleanupLogger.logError("Error running handler: " + projectHandler.getClassName() + " during project cleanup");
                        cleanupLogger.logError(e.getMessage());
                    }
                }
            } else {
                cleanupLogger.logSuccess("Project is *NOT* in the database, going to remove as much as possible");
                Date now = DateUtils.localDateTime2Date(DateUtils.getNow());
                Users user = this.userFacade.findByEmail(userEmail);
                Project toDeleteProject = new Project(projectName, user, now, PaymentType.PREPAID);
                toDeleteProject.setKafkaMaxNumTopics(Integer.valueOf(this.settings.getKafkaMaxNumTopics()));
                Path tmpInodePath = new Path(File.separator + "tmp" + File.separator + projectName);
                try {
                    Inode tmpInode;
                    if (!dfso.exists(tmpInodePath.toString())) {
                        dfso.touchz(tmpInodePath);
                    }
                    if ((tmpInode = this.inodeController.getInodeAtPath(tmpInodePath.toString())) != null) {
                        toDeleteProject.setInode(tmpInode);
                        this.projectFacade.persistProject(toDeleteProject);
                        this.projectFacade.flushEm();
                        cleanupLogger.logSuccess("Created dummy Inode");
                    }
                }
                catch (IOException ex) {
                    cleanupLogger.logError("Could not create dummy Inode, moving on unsafe");
                }
                List<HdfsUsers> projectHdfsUsers = this.hdfsUsersController.getAllProjectHdfsUsers(projectName);
                try {
                    HashSet<String> hdfsUsersStr = new HashSet<String>();
                    for (HdfsUsers hdfsUser : projectHdfsUsers) {
                        hdfsUsersStr.add(hdfsUser.getName());
                    }
                    List<ApplicationReport> projectApps = this.getYarnApplications(hdfsUsersStr, yarnClientWrapper.getYarnClient());
                    this.waitForJobLogs(projectApps, yarnClientWrapper.getYarnClient());
                    cleanupLogger.logSuccess("Killed all Yarn Applications");
                }
                catch (Exception ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeProjectRelatedFiles(projectHdfsUsers, dfso);
                    cleanupLogger.logSuccess("Removed project related files from HDFS");
                }
                catch (IOException ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.hiveController.dropDatabases(toDeleteProject, dfso, true);
                    cleanupLogger.logSuccess("Dropped Hive database");
                }
                catch (IOException ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeElasticsearch(toDeleteProject);
                    cleanupLogger.logSuccess("Removed ElasticSearch");
                }
                catch (Exception ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    List<HdfsGroups> projectHdfsGroups = this.hdfsUsersController.getAllProjectHdfsGroups(projectName);
                    this.removeGroupAndUsers(projectHdfsGroups, projectHdfsUsers);
                    cleanupLogger.logSuccess("Removed HDFS Groups and Users");
                }
                catch (IOException ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeQuotas(toDeleteProject);
                    cleanupLogger.logSuccess("Removed project quota");
                }
                catch (Exception ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                ArrayList<ProjectTeam> reconstructedProjectTeam = new ArrayList<ProjectTeam>();
                try {
                    for (HdfsUsers hdfsUser : this.hdfsUsersController.getAllProjectHdfsUsers(projectName)) {
                        Users foundUser = this.userFacade.findByUsername(hdfsUser.getUsername());
                        if (foundUser == null) continue;
                        reconstructedProjectTeam.add(new ProjectTeam(toDeleteProject, foundUser));
                    }
                }
                catch (Exception projectApps) {
                    // empty catch block
                }
                toDeleteProject.setProjectTeamCollection(reconstructedProjectTeam);
                try {
                    this.airflowManager.onProjectRemoval(toDeleteProject);
                    cleanupLogger.logSuccess("Removed Airflow DAGs and security references");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Failed to remove Airflow DAGs and security references");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeCertificatesFromMaterializer(toDeleteProject);
                    cleanupLogger.logSuccess("Freed all x.509 references from CertificateMaterializer");
                }
                catch (Exception ex) {
                    cleanupLogger.logError("Failed to free all X.509 references from CertificateMaterializer");
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.certificatesController.revokeProjectCertificates(project);
                    this.userCertsFacade.removeAllCertsOfAProject(projectName);
                    cleanupLogger.logSuccess("Deleted certificates");
                }
                catch (GenericException | HopsSecurityException | IOException ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    this.removeProjectFolder(projectName, dfso);
                    cleanupLogger.logSuccess("Removed root project directory");
                }
                catch (IOException ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
                try {
                    dfso.rm(new Path(File.separator + "tmp" + File.separator + projectName), true);
                    cleanupLogger.logSuccess("Removed /tmp");
                }
                catch (IOException ex) {
                    cleanupLogger.logError(ex.getMessage());
                }
            }
            this.dfs.closeDfsClient(dfso);
            this.ycs.closeYarnClient(yarnClientWrapper);
            LOGGER.log(Level.INFO, cleanupLogger.getSuccessLog().toString());
            String errorLog = cleanupLogger.getErrorLog().toString();
            if (!errorLog.isEmpty()) {
                LOGGER.log(Level.SEVERE, errorLog);
            }
            this.sendInbox(cleanupLogger.getSuccessLog().append("\n").append((CharSequence)cleanupLogger.getErrorLog()).append("\n").toString(), userEmail);
        }
        catch (Throwable throwable) {
            this.dfs.closeDfsClient(dfso);
            this.ycs.closeYarnClient(yarnClientWrapper);
            LOGGER.log(Level.INFO, cleanupLogger.getSuccessLog().toString());
            String errorLog = cleanupLogger.getErrorLog().toString();
            if (!errorLog.isEmpty()) {
                LOGGER.log(Level.SEVERE, errorLog);
            }
            this.sendInbox(cleanupLogger.getSuccessLog().append("\n").append((CharSequence)cleanupLogger.getErrorLog()).append("\n").toString(), userEmail);
            throw throwable;
        }
        String[] logs = new String[]{cleanupLogger.getSuccessLog().toString(), cleanupLogger.getErrorLog().toString()};
        return logs;
    }

    private void sendInbox(String message, String userRequested) {
        Users to = this.userFacade.findByEmail(userRequested);
        Users from = this.userFacade.findByEmail(this.settings.getAdminEmail());
        this.messageController.send(to, from, "Force project cleanup", "ServiceStatus", message, "");
    }

    private void removeProjectRelatedFiles(List<HdfsUsers> hdfsUsers, DistributedFileSystemOps dfso) throws IOException {
        String logPath = this.getYarnAgregationLogPath();
        for (HdfsUsers user : hdfsUsers) {
            dfso.rm(new Path(logPath + File.separator + user.getName()), true);
            List<Inode> historyInodes = this.inodeFacade.findHistoryFileByHdfsUser(user);
            for (Inode inode : historyInodes) {
                dfso.setOwner(new Path(this.inodeController.getPath(inode)), UserGroupInformation.getLoginUser().getUserName(), "hadoop");
            }
            Path certsHdfsDir = new Path(this.settings.getHdfsTmpCertDir() + File.separator + user.getName());
            if (!dfso.exists(certsHdfsDir.toString())) continue;
            dfso.rm(certsHdfsDir, true);
        }
    }

    private List<ApplicationReport> getYarnApplications(Set<String> hdfsUsers, YarnClient yarnClient) throws YarnException, IOException {
        return yarnClient.getApplications(null, hdfsUsers, null, EnumSet.of(YarnApplicationState.ACCEPTED, YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.RUNNING, YarnApplicationState.SUBMITTED));
    }

    private void killYarnJobs(Project project) throws JobException {
        List<Jobs> running = this.jobFacade.getRunningJobs(project);
        if (running != null && !running.isEmpty()) {
            for (Jobs job : running) {
                this.executionController.stop(job);
            }
        }
    }

    private void waitForJobLogs(List<ApplicationReport> projectsApps, YarnClient client) throws YarnException, IOException, InterruptedException {
        for (ApplicationReport appReport : projectsApps) {
            FinalApplicationStatus finalState = appReport.getFinalApplicationStatus();
            while (finalState.equals((Object)FinalApplicationStatus.UNDEFINED)) {
                client.killApplication(appReport.getApplicationId());
                appReport = client.getApplicationReport(appReport.getApplicationId());
                finalState = appReport.getFinalApplicationStatus();
            }
            YarnLogUtil.waitForLogAggregation(client, appReport.getApplicationId());
        }
    }

    private void removeCertificatesFromMaterializer(Project project) {
        for (ProjectTeam team : project.getProjectTeamCollection()) {
            this.certificateMaterializer.forceRemoveLocalMaterial(team.getUser().getUsername(), project.getName(), null, true);
            String remoteCertsDirectory = this.settings.getHdfsTmpCertDir() + "/" + this.hdfsUsersController.getHdfsUserName(project, team.getUser());
            if (remoteCertsDirectory.equals(this.settings.getHdfsTmpCertDir())) {
                LOGGER.log(Level.WARNING, "Programming error! Tried to delete " + this.settings.getHdfsTmpCertDir() + " while deleting project " + project + " but this operation is not allowed.");
                continue;
            }
            this.certificateMaterializer.forceRemoveRemoteMaterial(team.getUser().getUsername(), project.getName(), remoteCertsDirectory, false);
        }
    }

    public List<String> findProjectNames() {
        ArrayList<String> projectNames = new ArrayList<String>();
        for (Project project : this.projectFacade.findAll()) {
            projectNames.add(project.getName());
        }
        return projectNames;
    }

    public void cleanup(Project project, String sessionId) throws GenericException {
        this.cleanup(project, sessionId, false);
    }

    public void cleanup(Project project, String sessionId, boolean decreaseCreatedProj) throws GenericException {
        this.cleanup(project, sessionId, null, decreaseCreatedProj);
    }

    public void cleanup(Project project, String sessionId, List<Future<?>> projectCreationFutures) throws GenericException {
        this.cleanup(project, sessionId, projectCreationFutures, true);
    }

    public void cleanup(Project project, String sessionId, List<Future<?>> projectCreationFutures, boolean decreaseCreatedProj) throws GenericException {
        this.cleanup(project, sessionId, projectCreationFutures, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Project project, String sessionId, List<Future<?>> projectCreationFutures, boolean decreaseCreatedProj, Users owner) throws GenericException {
        if (project == null) {
            return;
        }
        int nbTry = 0;
        while (nbTry < 2) {
            YarnClientWrapper yarnClientWrapper = this.ycs.getYarnClientSuper(this.settings.getConfiguration());
            YarnClient client = yarnClientWrapper.getYarnClient();
            try {
                this.updateProjectTeamRole(project, ProjectRoleTypes.UNDER_REMOVAL);
                Collection team = project.getProjectTeamCollection();
                HashSet<String> hdfsUsers = new HashSet<String>();
                for (ProjectTeam pt : team) {
                    String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, pt.getUser());
                    hdfsUsers.add(hdfsUsername);
                }
                List<ApplicationReport> projectsApps = this.getYarnApplications(hdfsUsers, client);
                this.removeJupyter(project);
                this.removeAnacondaEnv(project);
                this.killYarnJobs(project);
                this.waitForJobLogs(projectsApps, client);
                List<HdfsUsers> usersToClean = this.getUsersToClean(project);
                List<HdfsGroups> groupsToClean = this.getGroupsToClean(project);
                this.removeProjectInt(project, usersToClean, groupsToClean, projectCreationFutures, decreaseCreatedProj, owner);
                this.removeCertificatesFromMaterializer(project);
                this.onlineFeaturestoreController.removeOnlineFeatureStore(project);
                break;
            }
            catch (Exception ex) {
                if (++nbTry < 2) {
                    try {
                        Thread.sleep(nbTry * 1000);
                    }
                    catch (InterruptedException ex1) {
                        LOGGER.log(Level.SEVERE, null, ex1);
                    }
                    continue;
                }
                throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.ycs.closeYarnClient(yarnClientWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProjectInt(Project project, List<HdfsUsers> usersToClean, List<HdfsGroups> groupsToClean, List<Future<?>> projectCreationFutures, boolean decreaseCreatedProj, Users owner) throws IOException, InterruptedException, HopsSecurityException, ServiceException, ProjectException, GenericException, TensorBoardException, FeaturestoreException, ElasticException, TimeoutException, ExecutionException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfs.getDfsOps();
            for (ProjectHandler projectHandler : this.projectHandlers) {
                try {
                    projectHandler.preDelete(project);
                }
                catch (Exception e) {
                    throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_PREDELETE_ERROR, Level.SEVERE, "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), e.getMessage(), (Throwable)e);
                }
            }
            this.logProject(project, OperationType.Delete);
            Path location = new Path(Utils.getProjectPath(project.getName()));
            this.changeOwnershipToSuperuser(location, dfso);
            Path dumy = new Path("/tmp/" + project.getName());
            this.changeOwnershipToSuperuser(dumy, dfso);
            this.removeKafkaTopics(project);
            if (projectCreationFutures != null) {
                for (Future<?> f : projectCreationFutures) {
                    if (f == null) continue;
                    try {
                        f.get();
                    }
                    catch (ExecutionException ex) {
                        LOGGER.log(Level.SEVERE, "Error while waiting for ProjectCreationFutures to finish for Project " + project.getName(), ex);
                    }
                }
            }
            try {
                this.certificatesController.revokeProjectCertificates(project, owner);
            }
            catch (HopsSecurityException ex) {
                if (ex.getErrorCode() != RESTCodes.SecurityErrorCode.CERTIFICATE_NOT_FOUND) {
                    LOGGER.log(Level.SEVERE, "Could not delete certificates during cleanup for project " + project.getName() + ". Manual cleanup is needed!!!", ex);
                    throw ex;
                }
            }
            catch (GenericException | IOException ex) {
                LOGGER.log(Level.SEVERE, "Could not delete certificates during cleanup for project " + project.getName() + ". Manual cleanup is needed!!!", ex);
                throw ex;
            }
            this.removeTensorBoard(project);
            this.removeJupyter(project);
            this.removeProjectRelatedFiles(usersToClean, dfso);
            this.removeQuotas(project);
            this.fixSharedDatasets(project, dfso);
            this.onlineFeaturestoreController.removeOnlineFeatureStore(project);
            this.hiveController.dropDatabases(project, dfso, false);
            try {
                this.removeElasticsearch(project);
            }
            catch (ElasticException ex) {
                LOGGER.log(Level.WARNING, "Failure while removing elasticsearch indices", ex);
            }
            this.removeGroupAndUsers(groupsToClean, usersToClean);
            dfso.rm(dumy, true);
            try {
                this.servingController.deleteServings(project);
            }
            catch (ServingException e) {
                throw new IOException(e);
            }
            this.airflowManager.onProjectRemoval(project);
            this.removeProjectFolder(project.getName(), dfso);
            if (decreaseCreatedProj) {
                this.usersController.decrementNumProjectsCreated(project.getOwner().getUid());
            }
            this.usersController.decrementNumActiveProjects(project.getOwner().getUid());
            for (ProjectHandler projectHandler : this.projectHandlers) {
                try {
                    projectHandler.postDelete(project);
                }
                catch (Exception e) {
                    throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_POSTDELETE_ERROR, Level.SEVERE, "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), e.getMessage(), (Throwable)e);
                }
            }
            LOGGER.log(Level.INFO, "{0} - project removed.", project.getName());
        }
    }

    private void changeOwnershipToSuperuser(Path path, DistributedFileSystemOps dfso) throws IOException {
        if (dfso.exists(path.toString())) {
            dfso.setOwner(path, this.dfs.getLoginUser().getUserName(), this.settings.getHdfsSuperUser());
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private List<ProjectTeam> updateProjectTeamRole(Project project, ProjectRoleTypes teamRole) {
        return this.projectTeamFacade.updateTeamRole(project, teamRole);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private List<HdfsUsers> getUsersToClean(Project project) {
        return this.hdfsUsersController.getAllProjectHdfsUsers(project.getName());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private List<HdfsGroups> getGroupsToClean(Project project) {
        return this.hdfsUsersController.getAllProjectHdfsGroups(project.getName());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void removeKafkaTopics(Project project) {
        List<ProjectTopics> topics = this.projectTopicsFacade.findTopicsByProject(project);
        List<String> topicNameList = topics.stream().map(ProjectTopics::getTopicName).collect(Collectors.toList());
        this.hopsKafkaAdminClient.deleteTopics(topicNameList);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void removeQuotas(Project project) {
        YarnProjectsQuota yarnProjectsQuota = this.yarnProjectsQuotaFacade.findByProjectName(project.getName());
        this.yarnProjectsQuotaFacade.remove(yarnProjectsQuota);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void fixSharedDatasets(Project project, DistributedFileSystemOps dfso) throws IOException {
        List<DatasetSharedWith> sharedDataSets = this.datasetSharedWithFacade.findByProject(project);
        for (DatasetSharedWith dataSet : sharedDataSets) {
            String owner = dataSet.getDataset().getInode().getHdfsUser().getName();
            String group = dataSet.getDataset().getInode().getHdfsGroup().getName();
            ArrayList<Inode> children = new ArrayList<Inode>();
            this.inodeController.getAllChildren(dataSet.getDataset().getInode(), children);
            for (Inode child : children) {
                if (!child.getHdfsUser().getName().startsWith(project.getName() + "__")) continue;
                Path childPath = new Path(this.inodeController.getPath(child));
                dfso.setOwner(childPath, owner, group);
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void removeGroupAndUsers(List<HdfsGroups> groups, List<HdfsUsers> users) throws IOException {
        this.hdfsUsersController.deleteGroups(groups);
        this.hdfsUsersController.deleteUsers(users);
    }

    private void removeProjectFolder(String projectName, DistributedFileSystemOps dfso) throws IOException {
        Path location = new Path(Utils.getProjectPath(projectName));
        dfso.rm(location, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<String> addMembers(Project project, Users owner, List<ProjectTeam> projectTeams) throws KafkaException, ProjectException, UserException, FeaturestoreException {
        ArrayList<String> failedList = new ArrayList<String>();
        if (projectTeams == null) {
            return failedList;
        }
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            for (ProjectTeam projectTeam : projectTeams) {
                try {
                    if (!projectTeam.getProjectTeamPK().getTeamMember().equals(owner.getEmail())) {
                        projectTeam.setTimestamp(new Date());
                        Users newMember = this.userFacade.findByEmail(projectTeam.getProjectTeamPK().getTeamMember());
                        boolean added = this.addMember(projectTeam, project, newMember, owner, dfso);
                        if (newMember == null) {
                            failedList.add(projectTeam.getProjectTeamPK().getTeamMember() + " was not found in the system.");
                            continue;
                        }
                        if (added) continue;
                        failedList.add(newMember.getEmail() + " is already a member in this project.");
                        continue;
                    }
                    failedList.add(projectTeam.getProjectTeamPK().getTeamMember() + " is already a member in this project.");
                }
                catch (IOException | EJBException ejb) {
                    failedList.add(projectTeam.getProjectTeamPK().getTeamMember() + "could not be added. Try again later.");
                    LOGGER.log(Level.SEVERE, "Adding  team member {0} to members failed", projectTeam.getProjectTeamPK().getTeamMember());
                }
            }
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
        return failedList;
    }

    public boolean addMember(ProjectTeam projectTeam, Project project, Users newMember, Users owner, DistributedFileSystemOps dfso) throws UserException, KafkaException, ProjectException, FeaturestoreException, IOException {
        if (projectTeam.getTeamRole() == null || !projectTeam.getTeamRole().equals(ProjectRoleTypes.DATA_SCIENTIST.getRole()) && !projectTeam.getTeamRole().equals(ProjectRoleTypes.DATA_OWNER.getRole())) {
            projectTeam.setTeamRole(ProjectRoleTypes.DATA_SCIENTIST.getRole());
        }
        projectTeam.setTimestamp(new Date());
        if (newMember != null && !this.projectTeamFacade.isUserMemberOfProject(project, newMember)) {
            projectTeam.getProjectTeamPK().setProjectId(project.getId());
            projectTeam.setProject(project);
            projectTeam.setUser(newMember);
            project.getProjectTeamCollection().add(projectTeam);
            this.projectFacade.update(project);
            this.hdfsUsersController.addNewProjectMember(projectTeam, dfso);
            if (this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.KAFKA)) {
                this.kafkaController.addProjectMemberToTopics(project, newMember.getEmail());
            }
            if (this.projectServiceFacade.isServiceEnabledForProject(project, ProjectServiceEnum.FEATURESTORE) && this.settings.isOnlineFeaturestore().booleanValue()) {
                Featurestore featurestore = this.featurestoreController.getProjectFeaturestore(project);
                this.onlineFeaturestoreController.createDatabaseUser(projectTeam.getUser(), featurestore, projectTeam.getTeamRole());
            }
            Future<CertificatesController.CertsResult> certsResultFuture = null;
            try {
                certsResultFuture = this.certificatesController.generateCertificates(project, newMember);
                certsResultFuture.get();
            }
            catch (Exception ex) {
                try {
                    if (certsResultFuture != null) {
                        certsResultFuture.get();
                    }
                    this.certificatesController.revokeUserSpecificCertificates(project, newMember);
                }
                catch (GenericException | HopsSecurityException | IOException | InterruptedException | ExecutionException e) {
                    String failedUser = project.getName() + "__" + newMember.getUsername();
                    LOGGER.log(Level.SEVERE, "Could not delete user certificates for user " + failedUser + ". Manual cleanup is needed!!! ", e);
                }
                LOGGER.log(Level.SEVERE, "error while creating certificates, jupyter kernel: " + ex.getMessage(), ex);
                this.hdfsUsersController.removeMember(projectTeam);
                this.projectTeamFacade.removeProjectTeam(project, newMember);
                throw new EJBException("Could not create certificates for user");
            }
            String message = "You have been added to project " + project.getName() + " with a role " + projectTeam.getTeamRole() + ".";
            this.messageController.send(newMember, owner, "You have been added to a project.", message, message, "");
            LOGGER.log(Level.FINE, "{0} - member added to project : {1}.", new Object[]{newMember.getEmail(), project.getName()});
            this.logActivity(" added a member " + projectTeam.getProjectTeamPK().getTeamMember(), owner, project, ActivityFlag.MEMBER);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(Users user, String role, Project project) throws KafkaException, ProjectException, UserException, FeaturestoreException, IOException {
        boolean added;
        if (user == null || project == null) {
            throw new IllegalArgumentException("User and project can not be null.");
        }
        ProjectTeam projectTeam = new ProjectTeam(new ProjectTeamPK(project.getId(), user.getEmail()));
        projectTeam.setTeamRole(role);
        Users owner = project.getOwner();
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            added = this.addMember(projectTeam, project, user, owner, dfso);
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
        if (!added) {
            LOGGER.log(Level.FINE, "User {0} is already a member in this project {1}.", new Object[]{user.getUsername(), project.getName()});
        }
    }

    public ProjectDTO getProjectByID(Integer projectID) throws ProjectException {
        Project project = this.projectFacade.find(projectID);
        if (project == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + projectID);
        }
        Inode inode = this.inodeController.getInodeAtPath(Utils.getProjectPath(project.getName()));
        List<ProjectTeam> projectTeam = this.projectTeamFacade.findMembersByProject(project);
        List<ProjectServiceEnum> projectServices = this.projectServicesFacade.findEnabledServicesForProject(project);
        ArrayList<String> services = new ArrayList<String>();
        for (ProjectServiceEnum s : projectServices) {
            services.add(s.toString());
        }
        QuotasDTO quotas = this.getQuotasInternal(project);
        return new ProjectDTO(project, inode.getId(), services, projectTeam, quotas, this.settings.getHopsExamplesSparkFilename());
    }

    public ProjectDTO getProjectByName(String name) throws ProjectException {
        Inode parent;
        Project project = this.projectFacade.findByName(name);
        if (project == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "project: " + name);
        }
        Inode inode = this.inodeController.getInodeAtPath(Utils.getProjectPath(name));
        List<ProjectTeam> projectTeam = this.projectTeamFacade.findMembersByProject(project);
        List<ProjectServiceEnum> projectServices = this.projectServicesFacade.findEnabledServicesForProject(project);
        ArrayList<String> services = new ArrayList<String>();
        for (ProjectServiceEnum s : projectServices) {
            services.add(s.toString());
        }
        ArrayList<InodeView> kids = new ArrayList<InodeView>();
        Collection dsInProject = project.getDatasetCollection();
        Collection dsSharedWithProject = project.getDatasetSharedWithCollection();
        for (Dataset ds : dsInProject) {
            parent = this.inodes.findParent(ds.getInode());
            kids.add(new InodeView(parent, ds, this.inodeController.getPath(ds.getInode())));
        }
        for (Dataset ds : dsSharedWithProject) {
            parent = this.inodes.findParent(ds.getDataset().getInode());
            kids.add(new InodeView(parent, (DatasetSharedWith)ds, this.inodeController.getPath(ds.getDataset().getInode())));
        }
        return new ProjectDTO(project, inode.getId(), services, projectTeam, kids);
    }

    public void setProjectOwnerAndQuotas(Project project, long diskspaceQuotaInMB, DistributedFileSystemOps dfso, Users user) throws IOException {
        this.yarnProjectsQuotaFacade.persistYarnProjectsQuota(new YarnProjectsQuota(project.getName(), this.settings.getYarnDefaultQuota().intValue(), 0));
        this.yarnProjectsQuotaFacade.flushEm();
        this.setHdfsSpaceQuotasInMBs(project, diskspaceQuotaInMB, null, null, dfso);
        this.projectFacade.setTimestampQuotaUpdate(project, new Date());
        this.logActivity(" created a new project named " + project.getName(), user, project, ActivityFlag.PROJECT);
        this.addProjectOwner(project, user);
        LOGGER.log(Level.FINE, "{0} - project created successfully.", project.getName());
    }

    public void setHdfsSpaceQuotasInMBs(Project project, Long diskspaceQuotaInMB, Long hiveDbSpaceQuotaInMb, Long featurestoreDbSpaceQuotaInMb, DistributedFileSystemOps dfso) throws IOException {
        dfso.setHdfsSpaceQuotaInMBs(new Path(Utils.getProjectPath(project.getName())), diskspaceQuotaInMB);
        if (hiveDbSpaceQuotaInMb != null && this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.HIVE)) {
            dfso.setHdfsSpaceQuotaInMBs(this.hiveController.getDbPath(project.getName()), hiveDbSpaceQuotaInMb);
        }
        if (featurestoreDbSpaceQuotaInMb != null && this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.FEATURESTORE)) {
            dfso.setHdfsSpaceQuotaInMBs(this.hiveController.getDbPath(this.featurestoreController.getOfflineFeaturestoreDbName(project)), featurestoreDbSpaceQuotaInMb);
        }
    }

    public void setPaymentType(Project project, PaymentType paymentType) {
        project.setPaymentType(paymentType);
        this.projectFacade.mergeProject(project);
        this.projectFacade.flushEm();
    }

    public QuotasDTO getQuotas(Integer projectId) {
        Project project = this.projectFacade.find(projectId);
        return this.getQuotasInternal(project);
    }

    public QuotasDTO getQuotasInternal(Project project) {
        HdfsDirectoryWithQuotaFeature dbInodeAttrs;
        List datasets;
        Long hdfsQuota = -1L;
        Long hdfsUsage = -1L;
        Long hdfsNsQuota = -1L;
        Long hdfsNsCount = -1L;
        Long dbhdfsQuota = -1L;
        Long dbhdfsUsage = -1L;
        Long dbhdfsNsQuota = -1L;
        Long dbhdfsNsCount = -1L;
        Long fshdfsQuota = -1L;
        Long fshdfsUsage = -1L;
        Long fshdfsNsQuota = -1L;
        Long fshdfsNsCount = -1L;
        Integer kafkaQuota = project.getKafkaMaxNumTopics();
        Float yarnRemainingQuota = Float.valueOf(0.0f);
        Float yarnTotalQuota = Float.valueOf(0.0f);
        YarnProjectsQuota yarnQuota = this.yarnProjectsQuotaFacade.findByProjectName(project.getName());
        if (yarnQuota == null) {
            LOGGER.log(Level.SEVERE, "Cannot find YARN quota information for project: " + project.getName());
        } else {
            yarnRemainingQuota = Float.valueOf(yarnQuota.getQuotaRemaining());
            yarnTotalQuota = Float.valueOf(yarnQuota.getTotal());
        }
        HdfsDirectoryWithQuotaFeature projectInodeAttrs = this.hdfsDirectoryWithQuotaFeatureFacade.getByInodeId(project.getInode().getId());
        if (projectInodeAttrs == null) {
            LOGGER.log(Level.SEVERE, "Cannot find HDFS quota information for project: " + project.getName());
        } else {
            hdfsQuota = projectInodeAttrs.getSsquota().longValue();
            hdfsUsage = projectInodeAttrs.getStorageSpace().longValue();
            hdfsNsQuota = projectInodeAttrs.getNsquota().longValue();
            hdfsNsCount = projectInodeAttrs.getNscount().longValue();
        }
        if (this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.HIVE)) {
            datasets = (List)project.getDatasetCollection();
            for (Dataset ds : datasets) {
                if (ds.getDsType() != DatasetType.HIVEDB) continue;
                dbInodeAttrs = this.hdfsDirectoryWithQuotaFeatureFacade.getByInodeId(ds.getInodeId());
                if (dbInodeAttrs == null) {
                    LOGGER.log(Level.SEVERE, "Cannot find HiveDB quota information for project: " + project.getName());
                    continue;
                }
                dbhdfsQuota = dbInodeAttrs.getSsquota().longValue();
                dbhdfsUsage = dbInodeAttrs.getStorageSpace().longValue();
                dbhdfsNsQuota = dbInodeAttrs.getNsquota().longValue();
                dbhdfsNsCount = dbInodeAttrs.getNscount().longValue();
            }
        }
        if (this.projectServicesFacade.isServiceEnabledForProject(project, ProjectServiceEnum.FEATURESTORE)) {
            datasets = (List)project.getDatasetCollection();
            for (Dataset ds : datasets) {
                if (ds.getDsType() != DatasetType.FEATURESTORE) continue;
                dbInodeAttrs = this.hdfsDirectoryWithQuotaFeatureFacade.getByInodeId(ds.getInodeId());
                if (dbInodeAttrs == null) {
                    LOGGER.log(Level.SEVERE, "Cannot find FeaturestoreDb quota information for project: " + project.getName());
                    continue;
                }
                fshdfsQuota = dbInodeAttrs.getSsquota().longValue();
                fshdfsUsage = dbInodeAttrs.getStorageSpace().longValue();
                fshdfsNsQuota = dbInodeAttrs.getNsquota().longValue();
                fshdfsNsCount = dbInodeAttrs.getNscount().longValue();
            }
        }
        return new QuotasDTO(yarnRemainingQuota, yarnTotalQuota, hdfsQuota, hdfsUsage, hdfsNsQuota, hdfsNsCount, dbhdfsQuota, dbhdfsUsage, dbhdfsNsQuota, dbhdfsNsCount, fshdfsQuota, fshdfsUsage, fshdfsNsQuota, fshdfsNsCount, kafkaQuota);
    }

    public void removeMemberFromTeam(Project project, Users user, String toRemoveEmail) throws UserException, ProjectException, ServiceException, IOException, GenericException, JobException, HopsSecurityException, TensorBoardException, FeaturestoreException {
        Users userToBeRemoved = this.userFacade.findByEmail(toRemoveEmail);
        if (userToBeRemoved == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE, "user: " + userToBeRemoved.getEmail());
        }
        this.removeMemberFromTeam(project, userToBeRemoved);
        this.logActivity(" removed team member " + userToBeRemoved.getEmail(), user, project, ActivityFlag.MEMBER);
    }

    public void removeMemberFromTeam(Project project, Users userToBeRemoved) throws ProjectException, ServiceException, IOException, GenericException, JobException, HopsSecurityException, TensorBoardException, FeaturestoreException {
        ProjectTeam projectTeam = this.projectTeamFacade.findProjectTeam(project, userToBeRemoved);
        if (projectTeam == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.TEAM_MEMBER_NOT_FOUND, Level.FINE, "project: " + project + ", user: " + userToBeRemoved.getEmail());
        }
        if (project.getOwner().equals((Object)userToBeRemoved)) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_OWNER_NOT_ALLOWED, Level.FINE);
        }
        this.projectTeamFacade.removeProjectTeam(project, userToBeRemoved);
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, userToBeRemoved);
        YarnClientWrapper yarnClientWrapper = this.ycs.getYarnClientSuper(this.settings.getConfiguration());
        YarnClient client = yarnClientWrapper.getYarnClient();
        try {
            HashSet<String> hdfsUsers = new HashSet<String>();
            hdfsUsers.add(hdfsUser);
            List projectsApps = client.getApplications(null, hdfsUsers, null, EnumSet.of(YarnApplicationState.ACCEPTED, YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.RUNNING, YarnApplicationState.SUBMITTED));
            JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUser);
            if (jupyterProject != null) {
                this.jupyterController.shutdown(project, hdfsUser, userToBeRemoved, jupyterProject.getSecret(), jupyterProject.getCid(), jupyterProject.getPort());
            }
            this.tensorBoardController.cleanup(project, userToBeRemoved);
            List<Jobs> running = this.jobFacade.getRunningJobs(project, hdfsUser);
            if (running != null && !running.isEmpty()) {
                for (Jobs job : running) {
                    this.executionController.stop(job);
                }
            }
            for (ApplicationReport appReport : projectsApps) {
                FinalApplicationStatus finalState = appReport.getFinalApplicationStatus();
                while (finalState.equals((Object)FinalApplicationStatus.UNDEFINED)) {
                    client.killApplication(appReport.getApplicationId());
                    appReport = client.getApplicationReport(appReport.getApplicationId());
                    finalState = appReport.getFinalApplicationStatus();
                }
                YarnLogUtil.waitForLogAggregation(client, appReport.getApplicationId());
            }
        }
        catch (IOException | InterruptedException | YarnException e) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.KILL_MEMBER_JOBS, Level.SEVERE, "project: " + project + ", user: " + userToBeRemoved, e.getMessage(), e);
        }
        finally {
            this.ycs.closeYarnClient(yarnClientWrapper);
        }
        if (this.projectServiceFacade.isServiceEnabledForProject(project, ProjectServiceEnum.FEATURESTORE)) {
            Featurestore featurestore = this.featurestoreController.getProjectFeaturestore(project);
            this.onlineFeaturestoreController.removeOnlineFeaturestoreUser(featurestore, userToBeRemoved);
        }
        this.kafkaController.removeProjectMemberFromTopics(project, userToBeRemoved);
        this.certificateMaterializer.forceRemoveLocalMaterial(userToBeRemoved.getUsername(), project.getName(), null, false);
        try {
            this.certificatesController.revokeUserSpecificCertificates(project, userToBeRemoved);
        }
        catch (HopsSecurityException ex) {
            if (ex.getErrorCode() != RESTCodes.SecurityErrorCode.CERTIFICATE_NOT_FOUND) {
                LOGGER.log(Level.SEVERE, "Could not delete certificates when removing member " + userToBeRemoved.getUsername() + " from project " + project.getName() + ". Manual cleanup is needed!!!", ex);
                throw ex;
            }
        }
        catch (GenericException | IOException ex) {
            LOGGER.log(Level.SEVERE, "Could not delete certificates when removing member " + userToBeRemoved.getUsername() + " from project " + project.getName() + ". Manual cleanup is needed!!!", ex);
            throw ex;
        }
        this.hdfsUsersController.removeMember(projectTeam);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateMemberRole(Project project, Users opsOwner, String toUpdateEmail, String newRole) throws UserException, ProjectException, FeaturestoreException, IOException {
        Users user = this.userFacade.findByEmail(toUpdateEmail);
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE, "user: " + toUpdateEmail);
        }
        this.updateMemberRole(project, user, newRole);
        this.logActivity(" changed the role of " + toUpdateEmail, opsOwner, project, ActivityFlag.MEMBER);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateMemberRole(Project project, Users user, String newRole) throws ProjectException, FeaturestoreException, IOException {
        if (project.getOwner().equals((Object)user)) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_OWNER_ROLE_NOT_ALLOWED, Level.FINE, "project: " + project.getName());
        }
        ProjectTeam projectTeam = this.projectTeamFacade.findProjectTeam(project, user);
        if (projectTeam == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.TEAM_MEMBER_NOT_FOUND, Level.FINE, "project: " + project.getName() + ", user: " + user.getUsername());
        }
        if (newRole == null || newRole.isEmpty() || !newRole.equals("Data owner") && !newRole.equals("Data scientist")) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.ROLE_NOT_SET, Level.FINE, "Role not set or not supported role=" + newRole);
        }
        if (projectTeam.getTeamRole().equals(newRole)) {
            return;
        }
        projectTeam.setTeamRole(newRole);
        projectTeam.setTimestamp(new Date());
        this.projectTeamFacade.update(projectTeam);
        this.hdfsUsersController.changeMemberRole(projectTeam);
        if (this.projectServiceFacade.isServiceEnabledForProject(project, ProjectServiceEnum.FEATURESTORE)) {
            Featurestore featurestore = this.featurestoreController.getProjectFeaturestore(project);
            this.onlineFeaturestoreController.updateUserOnlineFeatureStoreDB(user, featurestore, newRole);
        }
    }

    public List<ProjectTeam> findProjectByUser(String email) {
        Users user = this.userFacade.findByEmail(email);
        return this.projectTeamFacade.findActiveByMember(user);
    }

    public List<String> findProjectNamesByUser(String email, boolean ignoreCase) {
        Users user = this.userFacade.findByEmail(email);
        List<ProjectTeam> projectTeams = this.projectTeamFacade.findActiveByMember(user);
        ArrayList<String> projects = null;
        if (projectTeams != null && projectTeams.size() > 0) {
            projects = new ArrayList<String>();
            for (ProjectTeam team : projectTeams) {
                if (ignoreCase) {
                    projects.add(team.getProject().getName().toLowerCase());
                    continue;
                }
                projects.add(team.getProject().getName());
            }
        }
        return projects;
    }

    public List<ProjectTeam> findProjectTeamById(Integer projectID) {
        Project project = this.projectFacade.find(projectID);
        return this.projectTeamFacade.findMembersByProject(project);
    }

    public void logActivity(String activityPerformed, Users performedBy, Project performedOn, ActivityFlag flag) {
        this.activityFacade.persistActivity(activityPerformed, performedOn, performedBy, flag);
    }

    public String addTourFilesToProject(String username, Project project, DistributedFileSystemOps dfso, DistributedFileSystemOps udfso, TourProjectType projectType, ProvTypeDTO projectProvCore) throws DatasetException, HopsSecurityException, ProjectException, JobException, GenericException, ServiceException {
        String tourFilesDataset = "TestJob";
        Users user = this.userFacade.findByEmail(username);
        if (null != projectType) {
            String projectPath = Utils.getProjectPath(project.getName());
            switch (projectType) {
                case SPARK: {
                    this.datasetController.createDataset(user, project, tourFilesDataset, "files for guide projects", -1, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.DATASET), false, DatasetAccessPermission.EDITABLE, dfso);
                    String exampleDir = this.settings.getSparkDir() + "/examples/jars" + "/";
                    try {
                        File dir = new File(exampleDir);
                        File[] file = dir.listFiles((dir1, name) -> name.matches("spark-examples(.*).jar"));
                        if (file.length == 0) {
                            throw new IllegalStateException("No spark-examples*.jar was found in " + dir.getAbsolutePath());
                        }
                        if (file.length > 1) {
                            LOGGER.log(Level.WARNING, "More than one spark-examples*.jar found in {0}.", dir.getAbsolutePath());
                        }
                        String hdfsJarPath = projectPath + tourFilesDataset + "/spark-examples.jar";
                        udfso.copyToHDFSFromLocal(false, file[0].getAbsolutePath(), hdfsJarPath);
                        String datasetGroup = this.hdfsUsersController.getHdfsGroupName(project, tourFilesDataset);
                        String userHdfsName = this.hdfsUsersController.getHdfsUserName(project, user);
                        udfso.setPermission(new Path(hdfsJarPath), udfso.getParentPermission(new Path(hdfsJarPath)));
                        udfso.setOwner(new Path(projectPath + tourFilesDataset + "/spark-examples.jar"), userHdfsName, datasetGroup);
                        break;
                    }
                    catch (IOException ex) {
                        throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_TOUR_FILES_ERROR, Level.SEVERE, "project: " + project.getName(), ex.getMessage(), (Throwable)ex);
                    }
                }
                case KAFKA: {
                    this.datasetController.createDataset(user, project, tourFilesDataset, "files for guide projects", -1, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.DATASET), false, DatasetAccessPermission.EDITABLE, dfso);
                    String kafkaExampleSrc = "/user/" + this.settings.getSparkUser() + "/" + this.settings.getHopsExamplesSparkFilename();
                    String kafkaExampleDst = projectPath + tourFilesDataset + "/" + this.settings.getHopsExamplesSparkFilename();
                    try {
                        udfso.copyInHdfs(new Path(kafkaExampleSrc), new Path(kafkaExampleDst));
                        String datasetGroup = this.hdfsUsersController.getHdfsGroupName(project, tourFilesDataset);
                        String userHdfsName = this.hdfsUsersController.getHdfsUserName(project, user);
                        udfso.setPermission(new Path(kafkaExampleDst), udfso.getParentPermission(new Path(kafkaExampleDst)));
                        udfso.setOwner(new Path(kafkaExampleDst), userHdfsName, datasetGroup);
                        break;
                    }
                    catch (IOException ex) {
                        throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_TOUR_FILES_ERROR, Level.SEVERE, "project: " + project.getName(), ex.getMessage(), (Throwable)ex);
                    }
                }
                case ML: {
                    tourFilesDataset = "TourData";
                    this.datasetController.createDataset(user, project, tourFilesDataset, "sample training data for notebooks", -1, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.DATASET), false, DatasetAccessPermission.EDITABLE, dfso);
                    String DLDataSrc = "/user/" + this.settings.getHdfsSuperUser() + "/" + "tensorflow_demo/data" + "/*";
                    String DLDataDst = projectPath + "TourData";
                    String DLNotebooksSrc = "/user/" + this.settings.getHdfsSuperUser() + "/" + "tensorflow_demo/notebooks";
                    String DLNotebooksDst = projectPath + "Jupyter";
                    try {
                        udfso.copyInHdfs(new Path(DLDataSrc), new Path(DLDataDst));
                        String datasetGroup = this.hdfsUsersController.getHdfsGroupName(project, "TourData");
                        String userHdfsName = this.hdfsUsersController.getHdfsUserName(project, user);
                        Inode tourDs = this.inodeController.getInodeAtPath(DLDataDst);
                        this.datasetController.recChangeOwnershipAndPermission(new Path(DLDataDst), FsPermission.createImmutable((short)tourDs.getPermission()), userHdfsName, datasetGroup, dfso, udfso);
                        udfso.copyInHdfs(new Path(DLNotebooksSrc + "/*"), new Path(DLNotebooksDst));
                        datasetGroup = this.hdfsUsersController.getHdfsGroupName(project, "Jupyter");
                        Inode jupyterDS = this.inodeController.getInodeAtPath(DLNotebooksDst);
                        this.datasetController.recChangeOwnershipAndPermission(new Path(DLNotebooksDst), FsPermission.createImmutable((short)jupyterDS.getPermission()), userHdfsName, datasetGroup, dfso, udfso);
                        break;
                    }
                    catch (IOException ex) {
                        throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_TOUR_FILES_ERROR, Level.SEVERE, "project: " + project.getName(), ex.getMessage(), (Throwable)ex);
                    }
                }
                case FS: {
                    this.datasetController.createDataset(user, project, tourFilesDataset, "files for guide projects", -1, Provenance.getDatasetProvCore(projectProvCore, Provenance.MLType.DATASET), false, DatasetAccessPermission.EDITABLE, dfso);
                    String featurestoreExampleJarSrc = "/user/" + this.settings.getSparkUser() + "/" + this.settings.getHopsExamplesFeaturestoreTourFilename();
                    String featurestoreExampleJarDst = projectPath + tourFilesDataset + "/" + this.settings.getHopsExamplesFeaturestoreTourFilename();
                    String featurestoreExampleDataSrc = "/user/" + this.settings.getHdfsSuperUser() + "/" + "featurestore_demo" + "/data";
                    String featurestoreExampleDataDst = projectPath + tourFilesDataset;
                    try {
                        udfso.copyInHdfs(new Path(featurestoreExampleJarSrc), new Path(featurestoreExampleJarDst));
                        String datasetGroup = this.hdfsUsersController.getHdfsGroupName(project, tourFilesDataset);
                        String userHdfsName = this.hdfsUsersController.getHdfsUserName(project, user);
                        udfso.setPermission(new Path(featurestoreExampleJarDst), udfso.getParentPermission(new Path(featurestoreExampleJarDst)));
                        udfso.setOwner(new Path(featurestoreExampleJarDst), userHdfsName, datasetGroup);
                        udfso.copyInHdfs(new Path(featurestoreExampleDataSrc), new Path(featurestoreExampleDataDst));
                        datasetGroup = this.hdfsUsersController.getHdfsGroupName(project, tourFilesDataset);
                        userHdfsName = this.hdfsUsersController.getHdfsUserName(project, user);
                        Inode featurestoreDataDst = this.inodeController.getInodeAtPath(featurestoreExampleDataDst);
                        this.datasetController.recChangeOwnershipAndPermission(new Path(featurestoreExampleDataDst), FsPermission.createImmutable((short)featurestoreDataDst.getPermission()), userHdfsName, datasetGroup, dfso, udfso);
                        String featurestoreExampleNotebooksSrc = "/user/" + this.settings.getHdfsSuperUser() + "/" + "featurestore_demo" + "/notebooks";
                        String featurestoreExampleNotebooksDst = projectPath + "Jupyter";
                        udfso.copyInHdfs(new Path(featurestoreExampleNotebooksSrc + "/*"), new Path(featurestoreExampleNotebooksDst));
                        datasetGroup = this.hdfsUsersController.getHdfsGroupName(project, "Jupyter");
                        Inode featurestoreNotebooksDst = this.inodeController.getInodeAtPath(featurestoreExampleNotebooksDst);
                        this.datasetController.recChangeOwnershipAndPermission(new Path(featurestoreExampleNotebooksDst), FsPermission.createImmutable((short)featurestoreNotebooksDst.getPermission()), userHdfsName, datasetGroup, dfso, udfso);
                    }
                    catch (IOException ex) {
                        throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_TOUR_FILES_ERROR, Level.SEVERE, "project: " + project.getName(), ex.getMessage(), (Throwable)ex);
                    }
                    SparkJobConfiguration sparkJobConfiguration = new SparkJobConfiguration();
                    sparkJobConfiguration.setAmQueue("default");
                    sparkJobConfiguration.setAmMemory(1024);
                    sparkJobConfiguration.setAmVCores(1);
                    sparkJobConfiguration.setAppPath("hdfs://" + featurestoreExampleJarDst);
                    sparkJobConfiguration.setMainClass("io.hops.examples.featurestore_tour.Main");
                    sparkJobConfiguration.setDefaultArgs("--input TestJob/data");
                    sparkJobConfiguration.setExecutorInstances(1);
                    sparkJobConfiguration.setExecutorCores(1);
                    sparkJobConfiguration.setExecutorMemory(2024);
                    sparkJobConfiguration.setExecutorGpus(0);
                    sparkJobConfiguration.setDynamicAllocationEnabled(true);
                    sparkJobConfiguration.setDynamicAllocationMinExecutors(1);
                    sparkJobConfiguration.setDynamicAllocationMaxExecutors(3);
                    sparkJobConfiguration.setDynamicAllocationInitialExecutors(1);
                    sparkJobConfiguration.setAppName("featurestore_tour_job");
                    sparkJobConfiguration.setLocalResources(new LocalResourceDTO[0]);
                    Jobs job = this.jobController.putJob(user, project, null, (JobConfiguration)sparkJobConfiguration);
                    this.activityFacade.persistActivity(" created a new job named " + job.getName(), project, user, ActivityFlag.SERVICE);
                    this.executionController.start(job, "--input " + tourFilesDataset + "/data", user);
                    this.activityFacade.persistActivity(" ran a job named " + job.getName(), project, user, ActivityFlag.SERVICE);
                    break;
                }
            }
        }
        return tourFilesDataset;
    }

    public List<YarnPriceMultiplicator> getYarnMultiplicators() {
        ArrayList<YarnPriceMultiplicator> multiplicators = new ArrayList<YarnPriceMultiplicator>(this.yarnProjectsQuotaFacade.getMultiplicators());
        if (multiplicators.isEmpty()) {
            YarnPriceMultiplicator multiplicator = new YarnPriceMultiplicator();
            multiplicator.setMultiplicator(1.0f);
            multiplicator.setId("-1");
            multiplicators.add(multiplicator);
        }
        return multiplicators;
    }

    public void logProject(Project project, OperationType type) {
        this.operationsLogFacade.persist(new OperationsLog(project, type));
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeAnacondaEnv(Project project) {
        this.environmentController.removeEnvironment(project);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeJupyter(Project project) throws ServiceException {
        this.jupyterController.removeJupyter(project);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeTensorBoard(Project project) throws TensorBoardException {
        this.tensorBoardController.removeProject(project);
    }

    public void addKibana(Project project, Users user) throws ProjectException {
        String projectName = project.getName().toLowerCase();
        try {
            this.elasticController.createIndexPattern(project, user, projectName + "_logs-*");
            this.elasticController.createIndexPattern(project, user, project.getName().toLowerCase() + "_beamjobserver-*");
            this.elasticController.createIndexPattern(project, user, project.getName().toLowerCase() + "_beamsdkworker-*");
        }
        catch (ElasticException e) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_KIBANA_CREATE_INDEX_ERROR, Level.SEVERE, "Could provision project on Kibana. Contact an administrator if problem persists. Reason: " + e.getUsrMsg(), e.getDevMsg(), (Throwable)e);
        }
    }

    public void removeElasticsearch(Project project) throws ServiceException, ElasticException {
        List<ProjectServiceEnum> projectServices = this.projectServicesFacade.findEnabledServicesForProject(project);
        String projectName = project.getName().toLowerCase();
        if (projectServices.contains(ProjectServiceEnum.JOBS) || projectServices.contains(ProjectServiceEnum.JUPYTER) || projectServices.contains(ProjectServiceEnum.SERVING)) {
            this.elasticController.deleteProjectIndices(project);
            LOGGER.log(Level.FINE, "removeElasticsearch-1:{0}", projectName);
            this.elasticController.deleteProjectSavedObjects(projectName);
        }
    }

    private AccessCredentialsDTO getAccessCredentials(Project project, Users user) throws IOException, CryptoPasswordNotFoundException {
        this.certificateMaterializer.materializeCertificatesLocal(user.getUsername(), project.getName());
        CertificateMaterializer.CryptoMaterial material = this.certificateMaterializer.getUserMaterial(user.getUsername(), project.getName());
        String keyStore = Base64.encodeBase64String((byte[])material.getKeyStore().array());
        String trustStore = Base64.encodeBase64String((byte[])material.getTrustStore().array());
        String certPwd = new String(material.getPassword());
        return new AccessCredentialsDTO("jks", keyStore, trustStore, certPwd);
    }

    public AccessCredentialsDTO credentials(Integer projectId, Users user) throws ProjectException, DatasetException {
        Project project = this.findProjectById(projectId);
        try {
            AccessCredentialsDTO accessCredentialsDTO = this.getAccessCredentials(project, user);
            return accessCredentialsDTO;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new DatasetException(RESTCodes.DatasetErrorCode.DOWNLOAD_ERROR, Level.SEVERE, "projectId: " + projectId, ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
        }
    }

    public void adminProjectUpdate(Project newProjectState, QuotasDTO quotas) throws ProjectException {
        Project currentProject = this.projectFacade.findByName(newProjectState.getName());
        if (currentProject == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE);
        }
        if (newProjectState.getArchived() != null && currentProject.getArchived() != newProjectState.getArchived()) {
            if (newProjectState.getArchived().booleanValue()) {
                this.projectFacade.archiveProject(currentProject);
            } else {
                this.projectFacade.unarchiveProject(currentProject);
            }
        }
        if (newProjectState.getPaymentType() != null && newProjectState.getPaymentType() != currentProject.getPaymentType()) {
            this.setPaymentType(currentProject, newProjectState.getPaymentType());
        }
        if (quotas != null) {
            QuotasDTO currentQuotas = this.getQuotasInternal(currentProject);
            boolean quotaChanged = false;
            try (DistributedFileSystemOps dfso = this.dfs.getDfsOps();){
                if (!(quotas.getHdfsQuotaInBytes() == null || quotas.getHdfsNsQuota() == null || quotas.getHdfsQuotaInBytes().equals(currentQuotas.getHdfsQuotaInBytes()) && quotas.getHdfsNsQuota().equals(currentQuotas.getHdfsNsQuota()))) {
                    dfso.setHdfsQuotaBytes(new Path(Utils.getProjectPath(currentProject.getName())), quotas.getHdfsNsQuota(), quotas.getHdfsQuotaInBytes());
                    quotaChanged = true;
                }
                if (!(quotas.getHiveHdfsQuotaInBytes() == null || quotas.getHiveHdfsNsQuota() == null || !this.projectServicesFacade.isServiceEnabledForProject(currentProject, ProjectServiceEnum.HIVE) || quotas.getHiveHdfsQuotaInBytes().equals(currentQuotas.getHiveHdfsQuotaInBytes()) && quotas.getHiveHdfsNsQuota().equals(currentQuotas.getHiveHdfsNsQuota()))) {
                    dfso.setHdfsQuotaBytes(this.hiveController.getDbPath(currentProject.getName()), quotas.getHiveHdfsNsQuota(), quotas.getHiveHdfsQuotaInBytes());
                    quotaChanged = true;
                }
                if (!(quotas.getFeaturestoreHdfsQuotaInBytes() == null || quotas.getFeaturestoreHdfsNsQuota() == null || !this.projectServicesFacade.isServiceEnabledForProject(currentProject, ProjectServiceEnum.FEATURESTORE) || quotas.getFeaturestoreHdfsQuotaInBytes().equals(currentQuotas.getFeaturestoreHdfsQuotaInBytes()) && quotas.getFeaturestoreHdfsNsQuota().equals(currentQuotas.getFeaturestoreHdfsNsQuota()))) {
                    dfso.setHdfsQuotaBytes(this.hiveController.getDbPath(this.featurestoreController.getOfflineFeaturestoreDbName(newProjectState)), quotas.getFeaturestoreHdfsNsQuota(), quotas.getFeaturestoreHdfsQuotaInBytes());
                    quotaChanged = true;
                }
            }
            if (quotas.getYarnQuotaInSecs() != null && !quotas.getYarnQuotaInSecs().equals(currentQuotas.getYarnQuotaInSecs())) {
                this.yarnProjectsQuotaFacade.changeYarnQuota(currentProject.getName(), quotas.getYarnQuotaInSecs().floatValue());
                quotaChanged = true;
            }
            if (quotas.getKafkaMaxNumTopics() != null) {
                this.projectFacade.changeKafkaQuota(currentProject, quotas.getKafkaMaxNumTopics());
                quotaChanged = true;
            }
            if (quotaChanged) {
                this.projectFacade.setTimestampQuotaUpdate(currentProject, new Date());
            }
        }
    }

    private class CleanupLogger {
        private final String projectName;
        private final StringBuilder successLog;
        private final StringBuilder errorLog;

        private CleanupLogger(String projectName) {
            this.projectName = projectName;
            this.successLog = new StringBuilder();
            this.errorLog = new StringBuilder();
        }

        private void logError(String message) {
            this.log(this.errorLog, "*** ERROR ***", message);
        }

        private void logSuccess(String message) {
            this.log(this.successLog, "*** SUCCESS ***", message);
        }

        private void log(StringBuilder log, String summary, String message) {
            LocalDateTime now = DateUtils.getNow();
            log.append("<").append(now.format(DateTimeFormatter.ISO_DATE_TIME)).append(">").append(summary).append(message).append(" *").append(this.projectName).append("*").append("\n");
        }

        private StringBuilder getSuccessLog() {
            return this.successLog;
        }

        private StringBuilder getErrorLog() {
            return this.errorLog;
        }
    }

    private static class InsecureHostnameVerifier
    implements HostnameVerifier {
        static InsecureHostnameVerifier INSTANCE = new InsecureHostnameVerifier();

        InsecureHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession ssls) {
            return true;
        }
    }
}

