/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.agent.AgentController;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.python.PythonEnvironment;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class EnvironmentController {
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private Settings settings;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private AgentController agentController;
    @EJB
    private LibraryController libraryController;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private LibraryFacade libraryFacade;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    private static final Logger LOGGER = Logger.getLogger(EnvironmentController.class.getName());

    private void checkCondaSyncFinished(Project project) throws PythonException {
        ArrayList<CondaStatus> statuses = new ArrayList<CondaStatus>();
        statuses.add(CondaStatus.NEW);
        statuses.add(CondaStatus.ONGOING);
        statuses.add(CondaStatus.FAILED);
        List<CondaCommands> syncCommands = this.condaCommandFacade.findByStatusAndCondaOpAndProject(statuses, CondaOp.SYNC_BASE_ENV, project);
        if (!syncCommands.isEmpty()) {
            Optional<CondaCommands> ongoingSyncCommand = syncCommands.stream().filter(d -> d.getStatus().name().equals(CondaStatus.NEW.name()) || d.getStatus().name().equals(CondaStatus.ONGOING.name())).findFirst();
            if (ongoingSyncCommand.isPresent()) {
                throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_INITIALIZING, Level.FINE);
            }
            Optional<CondaCommands> failedSyncCommand = syncCommands.stream().filter(d -> d.getStatus().name().equals(CondaStatus.FAILED.name())).findFirst();
            if (failedSyncCommand.isPresent()) {
                throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_FAILED_INITIALIZATION, Level.FINE);
            }
        }
    }

    public void checkCondaEnabled(Project project, String pythonVersion, boolean syncMustBeFinished) throws PythonException {
        if (project.getPythonEnvironment() == null || !pythonVersion.equals(project.getPythonEnvironment().getPythonVersion())) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
        if (syncMustBeFinished) {
            this.checkCondaSyncFinished(project);
        }
    }

    public void checkCondaEnvExists(Project project, Users user) throws PythonException {
        if (project.getPythonEnvironment() == null) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
        if (Strings.isNullOrEmpty((String)project.getDockerImage()) || project.getDockerImage().equals(this.settings.getBaseDockerImagePythonName())) {
            this.createProjectDockerImage(project, user);
        }
    }

    public Project updateInstalledDependencies(Project project) throws ServiceException {
        try {
            Collection<PythonDep> projectDeps = this.libraryController.listLibraries(this.projectUtils.getFullDockerImageName(project, false));
            projectDeps = this.libraryController.persistAndMarkImmutable(projectDeps);
            project = this.libraryController.syncProjectPythonDepsWithEnv(project, projectDeps);
            project = this.libraryController.addOngoingOperations(project);
            return project;
        }
        catch (ServiceDiscoveryException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_DISCOVERY_ERROR, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void createProjectDockerImage(Project project, Users user) {
        ArrayList<CondaStatus> statuses = new ArrayList<CondaStatus>();
        statuses.add(CondaStatus.NEW);
        statuses.add(CondaStatus.ONGOING);
        if (!this.condaCommandFacade.findByStatusAndCondaOpAndProject(statuses, CondaOp.CREATE, project).isEmpty()) {
            LOGGER.log(Level.INFO, "There is already a " + CondaOp.CREATE.name() + " operation for this project.");
            return;
        }
        this.condaEnvironmentOp(CondaOp.CREATE, project.getPythonEnvironment().getPythonVersion(), project, user, project.getPythonEnvironment().getPythonVersion(), null, false);
        if (project.getPythonEnvironment() == null) {
            PythonEnvironment pythonEnvironment = new PythonEnvironment();
            pythonEnvironment.setPythonVersion(this.settings.getDockerBaseImagePythonVersion());
            pythonEnvironment.setProjectId(project.getId().intValue());
            project.setPythonEnvironment(pythonEnvironment);
        }
        project.setDockerImage(this.settings.getBaseDockerImagePythonName());
        this.projectFacade.update(project);
        this.projectFacade.flushEm();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String createProjectDockerImageFromImport(String importPath, boolean installJupyter, Users user, Project project) throws PythonException, ServiceException {
        if (project.getPythonEnvironment() != null) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_ALREADY_INITIALIZED, Level.FINE);
        }
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        String importContent = this.validateImportFile(new Path(importPath), username);
        if (!importPath.endsWith(".yml") && !importPath.endsWith("/requirements.txt")) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_FILE_INVALID, Level.FINE);
        }
        String pythonVersion = this.findPythonVersion(importContent);
        if (Strings.isNullOrEmpty((String)pythonVersion)) {
            pythonVersion = this.settings.getDockerBaseImagePythonVersion();
        }
        this.condaEnvironmentOp(CondaOp.IMPORT, pythonVersion, project, user, pythonVersion, importPath, installJupyter);
        PythonEnvironment pythonEnvironment = new PythonEnvironment();
        pythonEnvironment.setPythonVersion(pythonVersion);
        pythonEnvironment.setProjectId(project.getId().intValue());
        project.setPythonEnvironment(pythonEnvironment);
        this.projectFacade.update(project);
        return pythonVersion;
    }

    public void removeEnvironment(Project project) {
        this.commandsController.deleteCommandsForProject(project);
        project.setPythonDepCollection(new ArrayList());
        this.condaEnvironmentRemove(project, project.getOwner());
        project.setPythonEnvironment(null);
        project.setDockerImage(this.settings.getBaseNonPythonDockerImage());
        this.projectFacade.update(project);
        this.projectFacade.flushEm();
    }

    private void condaEnvironmentOp(CondaOp op, String pythonVersion, Project proj, Users user, String arg, String environmentFile, Boolean installJupyter) {
        if (this.projectUtils.isReservedProjectName(proj.getName())) {
            throw new IllegalStateException("Tried to execute a conda env op on a reserved project name");
        }
        CondaCommands cc = new CondaCommands(this.settings.getAnacondaUser(), user, op, CondaStatus.NEW, CondaInstallType.ENVIRONMENT, proj, pythonVersion, "", "defaults", new Date(), arg, environmentFile, installJupyter);
        this.condaCommandFacade.save(cc);
    }

    public void condaEnvironmentRemove(Project project, Users user) {
        if (Strings.isNullOrEmpty((String)project.getDockerImage()) || this.projectUtils.dockerImageIsPreinstalled(project.getDockerImage())) {
            LOGGER.log(Level.INFO, "Will not remove conda env " + project.getDockerImage() + " for project: " + project.getName());
            return;
        }
        ArrayList<CondaStatus> statuses = new ArrayList<CondaStatus>();
        statuses.add(CondaStatus.NEW);
        statuses.add(CondaStatus.ONGOING);
        if (!this.condaCommandFacade.findByStatusAndCondaOpAndProject(statuses, CondaOp.REMOVE, project).isEmpty()) {
            LOGGER.log(Level.INFO, "There is already a " + CondaOp.REMOVE.name() + " operation for this project.");
            return;
        }
        this.condaEnvironmentOp(CondaOp.REMOVE, "", project, user, project.getDockerImage(), null, false);
    }

    public String findPythonVersion(String ymlFile) throws PythonException {
        String foundVersion = null;
        Pattern urlPattern = Pattern.compile("(- python=(\\d+.\\d+))");
        Matcher urlMatcher = urlPattern.matcher(ymlFile);
        if (!urlMatcher.find()) {
            return null;
        }
        foundVersion = urlMatcher.group(2);
        return foundVersion;
    }

    public String[] exportEnv(Project project, Users user, String projectRelativeExportPath) throws PythonException {
        if (project.getPythonEnvironment() == null) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
        Date date = new Date();
        long exportTime = date.getTime();
        String ymlPath = projectRelativeExportPath + "/environment_" + exportTime + ".yml";
        this.condaEnvironmentOp(CondaOp.EXPORT, project.getPythonEnvironment().getPythonVersion(), project, user, ymlPath, null, false);
        return new String[]{ymlPath};
    }

    public Project createEnv(Project project, Users user) throws PythonException {
        ArrayList<CondaStatus> statuses = new ArrayList<CondaStatus>();
        statuses.add(CondaStatus.NEW);
        statuses.add(CondaStatus.ONGOING);
        if (!this.condaCommandFacade.findByStatusAndCondaOpAndProject(statuses, CondaOp.CREATE, project).isEmpty()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_INITIALIZING, Level.INFO);
        }
        if (project.getPythonEnvironment() != null) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_ALREADY_INITIALIZED, Level.FINE);
        }
        PythonEnvironment pythonEnvironment = new PythonEnvironment();
        pythonEnvironment.setPythonVersion(this.settings.getDockerBaseImagePythonVersion());
        pythonEnvironment.setProjectId(project.getId().intValue());
        project.setPythonEnvironment(pythonEnvironment);
        project.setDockerImage(this.settings.getBaseDockerImagePythonName());
        CondaCommands cc = new CondaCommands(this.settings.getAnacondaUser(), user, CondaOp.SYNC_BASE_ENV, CondaStatus.NEW, CondaInstallType.ENVIRONMENT, project, this.settings.getDockerBaseImagePythonVersion(), null, null, new Date(), null, null, Boolean.valueOf(false));
        this.condaCommandFacade.save(cc);
        return this.projectFacade.update(project);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateImportFile(Path fullPath, String username) throws ServiceException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            long fileSize = udfso.getFileStatus(fullPath).getLen();
            if (fileSize >= (long)this.settings.getMaxEnvYmlByteSize()) throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML_SIZE, Level.WARNING);
            byte[] ymlFileInBytes = new byte[(int)fileSize];
            try (DataInputStream dis = new DataInputStream((InputStream)udfso.open(fullPath));){
                dis.readFully(ymlFileInBytes, 0, (int)fileSize);
                String ymlFileContents = new String(ymlFileInBytes);
                ymlFileContents = Arrays.stream(ymlFileContents.split(System.lineSeparator())).filter(line -> !line.contains("jupyterlab-git")).collect(Collectors.joining(System.lineSeparator()));
                udfso.rm(fullPath, false);
                udfso.create(fullPath, ymlFileContents);
                String string = ymlFileContents;
                return string;
            }
            {
                catch (IOException ex) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_FROM_YML_ERROR, Level.SEVERE, "path: " + fullPath, ex.getMessage(), (Throwable)ex);
                }
            }
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void uploadYmlInProject(Project project, Users user, String environmentYml, String relativePath) throws ServiceException {
        DistributedFileSystemOps udfso = null;
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        try {
            udfso = this.dfs.getDfsOps(hdfsUser);
            Path projectYmlPath = new Path(Utils.getProjectPath(project.getName()) + "/" + relativePath);
            udfso.create(projectYmlPath, environmentYml);
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_EXPORT_ERROR, Level.SEVERE, "path: " + relativePath, ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public String getPipConflicts(Project project) throws ServiceDiscoveryException, IOException, PythonException {
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("check").addCommand(this.projectUtils.getFullDockerImageName(project, false)).redirectErrorStream(true).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
        if (processResult.getExitCode() == 0) {
            return null;
        }
        if (processResult.getStdout() != null && (processResult.getStdout().contains("which is not installed") || processResult.getStdout().contains("has requirement"))) {
            return processResult.getStdout();
        }
        throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_PIP_CHECK_FAILED, Level.SEVERE, "Failed to run pip check: " + (Strings.isNullOrEmpty((String)processResult.getStdout()) ? "" : processResult.getStdout()));
    }
}

