/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.util.ConfigurationUtil;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.templates.ConfigProperty;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.flink.FlinkJobConfiguration;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FlinkConfigurationUtil
extends ConfigurationUtil {
    @Override
    public Map<String, String> setFrameworkProperties(Project project, JobConfiguration jobConfiguration, Settings settings, String hdfsUser, Map<String, String> extraJavaOptions, String kafkaBrokersString, String hopsworksRestEndpoint, ServiceDiscoveryController serviceDiscoveryController) throws IOException {
        FlinkJobConfiguration flinkJobConfiguration = (FlinkJobConfiguration)jobConfiguration;
        HashMap<String, ConfigProperty> flinkProps = new HashMap<String, ConfigProperty>();
        flinkProps.put("log4j.configuration", new ConfigProperty("log4j.configuration", HopsUtils.IGNORE, settings.getFlinkConfDir() + "log4j.properties"));
        flinkProps.put("log4j.properties", new ConfigProperty("log4j.properties", HopsUtils.IGNORE, settings.getFlinkConfDir() + "log4j.properties"));
        flinkProps.put("state.checkpoints.dir", new ConfigProperty("state.checkpoints.dir", HopsUtils.OVERWRITE, "hdfs://" + Utils.getProjectPath(project.getName()) + "Resources" + "/flink"));
        if (extraJavaOptions == null) {
            extraJavaOptions = new HashMap<String, String>();
        }
        extraJavaOptions.put("log4j.configuration", settings.getFlinkConfDir() + "log4j.properties");
        extraJavaOptions.put("log4j.properties", settings.getFlinkConfDir() + "log4j.properties");
        extraJavaOptions.put("hopsworks.restendpoint", hopsworksRestEndpoint);
        extraJavaOptions.put("hopsutil.insecure", String.valueOf(settings.isHopsUtilInsecure()));
        extraJavaOptions.put("server.truststore", "server.truststore");
        extraJavaOptions.put("hopsworks.elastic.endpoint", settings.getElasticRESTEndpoint());
        extraJavaOptions.put("hopsworks.projectid", Integer.toString(project.getId()));
        extraJavaOptions.put("hopsworks.projectname", project.getName());
        extraJavaOptions.put("hopsworks.projectuser", hdfsUser);
        extraJavaOptions.put("hopsworks.kafka.brokeraddress", kafkaBrokersString);
        extraJavaOptions.put("hopsworks.job.type", jobConfiguration.getJobType().name());
        if (jobConfiguration.getAppName() != null) {
            extraJavaOptions.put("hopsworks.job.name", jobConfiguration.getAppName());
        }
        StringBuilder extraJavaOptionsSb = new StringBuilder();
        for (String key : extraJavaOptions.keySet()) {
            extraJavaOptionsSb.append(" -D").append(key).append("=").append(extraJavaOptions.get(key));
        }
        flinkProps.put("env.java.opts", new ConfigProperty("env.java.opts", HopsUtils.APPEND_SPACE, extraJavaOptionsSb.toString()));
        Map<String, String> validatedFlinkProperties = HopsUtils.parseUserProperties(flinkJobConfiguration.getProperties());
        return HopsUtils.mergeHopsworksAndUserParams(flinkProps, validatedFlinkProperties);
    }
}

