/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.elastic;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHits;
import org.elasticsearch.search.SearchHit;

public class ElasticHitsHandlerImpl<R, S>
implements ElasticHits.Handler<R, S> {
    private final ElasticHits.Parser<R> parser;
    private Try<S> state;
    private final ElasticHits.Merger<R, S> stateMerger;

    public ElasticHitsHandlerImpl(ElasticHits.Parser<R> parser, S state, ElasticHits.Merger<R, S> stateMerger) {
        this.parser = parser;
        this.state = Try.apply(() -> state);
        this.stateMerger = stateMerger;
    }

    @Override
    public Try<S> apply(SearchHit[] hits) {
        for (SearchHit hit : hits) {
            this.state = this.state.flatMap(s -> ((Try)this.parser.apply(hit)).flatMap(r -> (Try)this.stateMerger.apply(r, s)));
        }
        return this.state;
    }
}

