/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.ops;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.ops.ProvLinks;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.javatuples.Pair;

public class ProvLinksParamBuilder {
    boolean appIdDefined = false;
    boolean inArtifactDefined = false;
    boolean outArtifactDefined = false;
    Map<ProvParser.Field, ProvParser.FilterVal> inFilterBy = new HashMap<ProvParser.Field, ProvParser.FilterVal>();
    Map<ProvParser.Field, ProvParser.FilterVal> outFilterBy = new HashMap<ProvParser.Field, ProvParser.FilterVal>();
    Pair<Integer, Integer> pagination = null;
    boolean fullLink = true;

    public ProvLinksParamBuilder filterByFields(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<ProvLinks.Field, Object> filter = ProvLinks.extractFilter(param);
            this.filterBy((ProvLinks.Field)filter.getValue0(), filter.getValue1());
        }
        return this;
    }

    public void outFilterByField(ProvLinks.FieldsPF field, Object val) throws ProvenanceException {
        switch (field) {
            case APP_ID: {
                this.appIdDefined = true;
                ProvLinks.filterBySanityCheck(this.outFilterBy, field);
                ProvParser.addToFilters(this.outFilterBy, field, val);
                break;
            }
            case IN_ARTIFACT: {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "cannot modify IN_ARTIFACT in refine out query");
            }
            case OUT_ARTIFACT: {
                this.outArtifactDefined = true;
                ProvLinks.filterBySanityCheck(this.outFilterBy, field);
                ProvParser.addToFilters(this.outFilterBy, field, val);
                break;
            }
        }
    }

    public void inFilterByField(ProvLinks.FieldsPF field, Object val) throws ProvenanceException {
        switch (field) {
            case APP_ID: {
                this.appIdDefined = true;
                ProvLinks.filterBySanityCheck(this.inFilterBy, field);
                ProvParser.addToFilters(this.inFilterBy, field, val);
                break;
            }
            case IN_ARTIFACT: {
                this.inArtifactDefined = true;
                ProvLinks.filterBySanityCheck(this.inFilterBy, field);
                ProvParser.addToFilters(this.inFilterBy, field, val);
                break;
            }
            case OUT_ARTIFACT: {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "cannot modify OUT_ARTIFACT in refine in query");
            }
            default: {
                ProvLinks.filterBySanityCheck(this.inFilterBy, field);
                ProvParser.addToFilters(this.inFilterBy, field, val);
            }
        }
    }

    private void filterBy(ProvLinks.Field field, Object val) throws ProvenanceException {
        if (field instanceof ProvLinks.FieldsPF) {
            ProvLinks.FieldsPF fieldPF = (ProvLinks.FieldsPF)field;
            switch (fieldPF) {
                case APP_ID: {
                    this.appIdDefined = true;
                    ProvLinks.filterBySanityCheck(this.inFilterBy, field);
                    ProvParser.addToFilters(this.inFilterBy, field, val);
                    ProvLinks.filterBySanityCheck(this.outFilterBy, field);
                    ProvParser.addToFilters(this.outFilterBy, field, val);
                    break;
                }
                case IN_ARTIFACT: {
                    this.inArtifactDefined = true;
                    ProvLinks.filterBySanityCheck(this.inFilterBy, field);
                    ProvParser.addToFilters(this.inFilterBy, field, val);
                    break;
                }
                case IN_TYPE: {
                    ProvLinks.filterBySanityCheck(this.inFilterBy, field);
                    ProvParser.addToFilters(this.inFilterBy, field, val);
                    break;
                }
                case OUT_ARTIFACT: {
                    this.outArtifactDefined = true;
                    ProvLinks.filterBySanityCheck(this.outFilterBy, field);
                    ProvParser.addToFilters(this.outFilterBy, field, val);
                    break;
                }
                case OUT_TYPE: {
                    ProvLinks.filterBySanityCheck(this.outFilterBy, field);
                    ProvParser.addToFilters(this.outFilterBy, field, val);
                    break;
                }
                default: {
                    ProvLinks.filterBySanityCheck(this.inFilterBy, field);
                    ProvParser.addToFilters(this.inFilterBy, field, val);
                    ProvLinks.filterBySanityCheck(this.outFilterBy, field);
                    ProvParser.addToFilters(this.outFilterBy, field, val);
                }
            }
        }
    }

    public ProvLinksParamBuilder onlyApps(boolean enabled) throws ProvenanceException {
        if (enabled) {
            this.onlyApps();
        }
        return this;
    }

    public ProvLinksParamBuilder onlyApps() throws ProvenanceException {
        ProvParser.addToFilters(this.inFilterBy, ProvLinks.FieldsPF.ONLY_APPS, "none");
        ProvParser.addToFilters(this.outFilterBy, ProvLinks.FieldsPF.ONLY_APPS, "none");
        return this;
    }

    public ProvLinksParamBuilder paginate(Integer offset, Integer limit) {
        this.pagination = Pair.with((Object)offset, (Object)limit);
        return this;
    }

    public ProvLinksParamBuilder linkType(boolean fullLink) {
        this.fullLink = fullLink;
        return this;
    }

    public boolean isAppIdDefined() {
        return this.appIdDefined;
    }

    public boolean isInArtifactDefined() {
        return this.inArtifactDefined;
    }

    public boolean isOutArtifactDefined() {
        return this.outArtifactDefined;
    }

    public Map<ProvParser.Field, ProvParser.FilterVal> getInFilterBy() {
        return this.inFilterBy;
    }

    public Map<ProvParser.Field, ProvParser.FilterVal> getOutFilterBy() {
        return this.outFilterBy;
    }

    public Pair<Integer, Integer> getPagination() {
        return this.pagination;
    }

    public boolean isFullLink() {
        return this.fullLink;
    }
}

