/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.inference;

import io.hops.common.Pair;
import io.hops.hopsworks.common.serving.inference.LocalhostSkLearnInferenceController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.InferenceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class InferenceHttpClient {
    @EJB
    private Settings settings;
    private static final Logger logger = Logger.getLogger(LocalhostSkLearnInferenceController.class.getName());
    private CloseableHttpClient httpClient = null;
    private PoolingHttpClientConnectionManager cm = null;

    @PostConstruct
    public void init() {
        this.cm = new PoolingHttpClientConnectionManager(30L, TimeUnit.SECONDS);
        int poolSize = this.settings.getServingConnectionPoolSize();
        int maxRouteConnections = this.settings.getServingMaxRouteConnections();
        this.cm.setMaxTotal(poolSize);
        this.cm.setDefaultMaxPerRoute(maxRouteConnections);
        logger.log(Level.FINE, "Creating connection pool for Model Serving of size " + poolSize + " and max connections per route " + maxRouteConnections);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.cm).build();
    }

    public CloseableHttpResponse execute(HttpPost request, HttpContext httpContext) throws InferenceException {
        try {
            return this.httpClient.execute((HttpUriRequest)request, httpContext);
        }
        catch (IOException e) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.REQUEST_ERROR, Level.INFO, null, e.getMessage(), (Throwable)e);
        }
    }

    public Pair<Integer, String> handleInferenceResponse(CloseableHttpResponse response) throws InferenceException {
        try {
            if (response == null) {
                throw new InferenceException(RESTCodes.InferenceErrorCode.EMPTY_RESPONSE, Level.INFO, "Received null response");
            }
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity == null) {
                throw new InferenceException(RESTCodes.InferenceErrorCode.EMPTY_RESPONSE, Level.INFO, "Received null response");
            }
            try {
                String responseStr = EntityUtils.toString((HttpEntity)httpEntity);
                EntityUtils.consume((HttpEntity)httpEntity);
                Pair pair = new Pair((Object)response.getStatusLine().getStatusCode(), (Object)responseStr);
                return pair;
            }
            catch (IOException e) {
                throw new InferenceException(RESTCodes.InferenceErrorCode.ERROR_READING_RESPONSE, Level.INFO, "", e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, "Error closing response", ioe);
            }
        }
    }

    @PreDestroy
    public void preDestroy() {
        if (this.cm != null) {
            this.cm.close();
        }
    }
}

