/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.elastic;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.state.ProvStateParamBuilder;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.javatuples.Pair;

public class ElasticHelper {
    public static QueryBuilder fullTextSearch(String key, String term) {
        return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)key, (Object)term.toLowerCase())).should((QueryBuilder)QueryBuilders.prefixQuery((String)key, (String)term.toLowerCase())).should((QueryBuilder)QueryBuilders.fuzzyQuery((String)key, (String)term.toLowerCase())).should((QueryBuilder)QueryBuilders.wildcardQuery((String)key, (String)String.format("*%s*", term.toLowerCase())));
    }

    public static void checkPagination(Integer offset, Integer limit, long defaultPageSize) throws ElasticException {
        if (offset == null) {
            offset = 0;
        }
        if (offset < 0) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "malformed - offset cannot be negative");
        }
        if (limit != null && (0 > limit || (long)limit.intValue() > defaultPageSize)) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "malformed - limit not between 0 and ELASTIC_DEFAULT_SCROLL_PAGE_SIZE:" + defaultPageSize);
        }
    }

    public static CheckedSupplier<SearchRequest, ProvenanceException> scrollingSearchRequest(String index, int pageSize) {
        return () -> {
            SearchRequest sr = new SearchRequest(new String[]{index}).scroll(TimeValue.timeValueMinutes((long)1L));
            sr.source().size(pageSize);
            return sr;
        };
    }

    public static CheckedSupplier<SearchRequest, ProvenanceException> baseSearchRequest(String index, int pageSize) {
        return () -> {
            SearchRequest sr = new SearchRequest(new String[]{index});
            sr.source().size(pageSize);
            return sr;
        };
    }

    public static CheckedSupplier<SearchRequest, ProvenanceException> countSearchRequest(String index) {
        return () -> {
            SearchRequest sr = new SearchRequest(new String[]{index});
            sr.source().size(0);
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withPagination(Integer offset, Integer limit, long defaultPageSize) {
        return sr -> {
            try {
                ElasticHelper.checkPagination(offset, limit, defaultPageSize);
            }
            catch (ElasticException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "query with malformed pagination", "query with malformed pagination", (Throwable)e);
            }
            if (offset != null) {
                sr.source().from(offset.intValue());
            }
            if (limit != null) {
                sr.source().size(limit.intValue());
            }
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withFileStateOrder(List<Pair<ProvParser.Field, SortOrder>> fileStateSortBy, List<ProvStateParamBuilder.SortE> xattrSortBy) {
        return sr -> {
            for (Object sb : fileStateSortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)((ProvParser.Field)sb.getValue0()).elasticFieldName()).order((SortOrder)sb.getValue1()));
            }
            for (Object sb : xattrSortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)sb.key).order(sb.order));
            }
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withFileOpsOrder(List<Pair<ProvParser.Field, SortOrder>> fileOpsSortBy) {
        return sr -> {
            for (Pair sb : fileOpsSortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)((ProvParser.Field)sb.getValue0()).elasticFieldName()).order((SortOrder)sb.getValue1()));
            }
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withAggregations(List<AggregationBuilder> aggregationBuilder) {
        return sr -> {
            if (!aggregationBuilder.isEmpty()) {
                for (AggregationBuilder builder : aggregationBuilder) {
                    sr.source().aggregation(builder);
                }
            }
            return sr;
        };
    }

    public static BoolQueryBuilder filterByBasicFields(BoolQueryBuilder query, Map<ProvParser.Field, ProvParser.FilterVal> filters) throws ProvenanceException {
        for (ProvParser.FilterVal fieldFilters : filters.values()) {
            query.must(fieldFilters.query());
        }
        return query;
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> sortBy(List<Pair<ProvParser.Field, SortOrder>> sortBy) {
        return sr -> {
            for (Pair sb : sortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)((ProvParser.Field)sb.getValue0()).elasticFieldName()).order((SortOrder)sb.getValue1()));
            }
            return sr;
        };
    }

    public static boolean indexNotFound(Throwable t) {
        if (t instanceof IndexNotFoundException) {
            return true;
        }
        if (t instanceof ElasticsearchStatusException) {
            ElasticsearchStatusException e = (ElasticsearchStatusException)t;
            return e.status().equals((Object)RestStatus.NOT_FOUND);
        }
        return false;
    }
}

