/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import io.hops.hopsworks.common.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.featurestore.feature.TrainingDatasetFeatureDTO;
import io.hops.hopsworks.common.featurestore.query.QueryDTO;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsConfigDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.split.TrainingDatasetSplitDTO;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TrainingDatasetDTO
extends FeaturestoreEntityDTO {
    private String dataFormat;
    private Boolean coalesce;
    private TrainingDatasetType trainingDatasetType;
    private List<TrainingDatasetSplitDTO> splits = new ArrayList<TrainingDatasetSplitDTO>();
    private Long seed = null;
    private FeaturestoreStorageConnectorDTO storageConnector;
    private Long inodeId;
    private QueryDTO queryDTO;
    private Boolean fromQuery;
    private List<TrainingDatasetFeatureDTO> features;

    public TrainingDatasetDTO() {
    }

    public TrainingDatasetDTO(TrainingDataset trainingDataset) {
        super(trainingDataset.getFeaturestore().getId(), trainingDataset.getName(), trainingDataset.getCreated(), trainingDataset.getCreator(), trainingDataset.getVersion(), trainingDataset.getId(), new StatisticsConfigDTO(trainingDataset.getStatisticsConfig()));
        this.setDescription(trainingDataset.getDescription());
        this.dataFormat = trainingDataset.getDataFormat();
        this.coalesce = trainingDataset.getCoalesce();
        this.trainingDatasetType = trainingDataset.getTrainingDatasetType();
        this.splits = trainingDataset.getSplits().stream().map(tds -> new TrainingDatasetSplitDTO(tds.getName(), tds.getPercentage())).collect(Collectors.toList());
        this.seed = trainingDataset.getSeed();
        this.fromQuery = trainingDataset.isQuery();
    }

    @XmlElement
    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Boolean getCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(Boolean coalesce) {
        this.coalesce = coalesce;
    }

    public FeaturestoreStorageConnectorDTO getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(FeaturestoreStorageConnectorDTO storageConnector) {
        this.storageConnector = storageConnector;
    }

    public Long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(Long inodeId) {
        this.inodeId = inodeId;
    }

    @XmlElement
    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    @XmlElement
    public List<TrainingDatasetSplitDTO> getSplits() {
        return this.splits;
    }

    public void setSplits(List<TrainingDatasetSplitDTO> splits) {
        this.splits = splits;
    }

    @XmlElement
    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public QueryDTO getQueryDTO() {
        return this.queryDTO;
    }

    public void setQueryDTO(QueryDTO queryDTO) {
        this.queryDTO = queryDTO;
    }

    public List<TrainingDatasetFeatureDTO> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<TrainingDatasetFeatureDTO> features) {
        this.features = features;
    }

    public Boolean getFromQuery() {
        return this.fromQuery;
    }

    public void setFromQuery(Boolean fromQuery) {
        this.fromQuery = fromQuery;
    }

    @Override
    public String toString() {
        return "TrainingDatasetDTO{dataFormat='" + this.dataFormat + '\'' + ", trainingDatasetType=" + this.trainingDatasetType + ", splits=" + this.splits + ", seed=" + this.seed + ", inodeId=" + this.inodeId + '}';
    }
}

