/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.security.MasterPasswordChangeResult;
import io.hops.hopsworks.common.security.MasterPasswordHandler;
import io.hops.hopsworks.exceptions.EncryptionMasterPasswordException;
import io.hops.hopsworks.persistence.entity.certificates.UserCerts;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PSUserCertsMasterPasswordHandler
implements MasterPasswordHandler {
    private final Logger LOGGER = Logger.getLogger(PSUserCertsMasterPasswordHandler.class.getName());
    @EJB
    private UserFacade userFacade;
    @EJB
    private CertsFacade certsFacade;

    @Override
    public void pre() {
    }

    @Override
    public MasterPasswordChangeResult perform(String oldMasterPassword, String newMasterPassword) {
        StringBuilder successLog = new StringBuilder();
        successLog.append("Performing change of master password for PSU certificates\n");
        HashMap<String, String> oldPasswords4Rollback = new HashMap<String, String>();
        List<UserCerts> allPSCerts = this.certsFacade.findAllUserCerts();
        String mapKey = null;
        try {
            this.LOGGER.log(Level.INFO, "Updating PSU certs with new Hopsworks master encryption password");
            for (UserCerts psCert : allPSCerts) {
                mapKey = psCert.getUserCertsPK().getProjectname() + "__" + psCert.getUserCertsPK().getUsername();
                String oldPassword = psCert.getUserKeyPwd();
                oldPasswords4Rollback.putIfAbsent(mapKey, oldPassword);
                Users user = this.userFacade.findByUsername(psCert.getUserCertsPK().getUsername());
                if (user == null) {
                    throw new Exception("Could not find Hopsworks user for certificate " + mapKey);
                }
                String newEncCertPassword = this.getNewUserPassword(user.getPassword(), oldPassword, oldMasterPassword, newMasterPassword);
                psCert.setUserKeyPwd(newEncCertPassword);
                this.certsFacade.update(psCert);
                successLog.append("Updated certificate: ").append(mapKey).append("\n");
            }
            return new MasterPasswordChangeResult(successLog, oldPasswords4Rollback, null);
        }
        catch (Exception ex) {
            String errorMsg = "Something went wrong while updating master encryption password for Project Specific User certificates. PSU certificate provoked the error was: " + mapKey;
            this.LOGGER.log(Level.SEVERE, errorMsg + " rolling back...", ex);
            return new MasterPasswordChangeResult(oldPasswords4Rollback, new EncryptionMasterPasswordException(errorMsg));
        }
    }

    @Override
    public void rollback(MasterPasswordChangeResult result) {
        HashMap items2rollback = (HashMap)result.getRollbackItems();
        this.LOGGER.log(Level.INFO, "Rolling back PSU certificates");
        for (Map.Entry oldPassword : items2rollback.entrySet()) {
            String key = (String)oldPassword.getKey();
            String value = (String)oldPassword.getValue();
            String[] project__username = key.split("__", 2);
            UserCerts userCerts = this.certsFacade.findUserCert(project__username[0], project__username[1]);
            userCerts.setUserKeyPwd(value);
            this.certsFacade.update(userCerts);
        }
    }

    @Override
    public void post() {
    }
}

