/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.library;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.environment.DockerRegistryMngr;
import io.hops.hopsworks.common.python.environment.EnvironmentController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.jupyter.config.GitBackend;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LibraryInstaller {
    private static final Logger LOG = Logger.getLogger(LibraryInstaller.class.getName());
    private static final Comparator<CondaCommands> ASC_COMPARATOR = new CommandsComparator<CondaCommands>();
    private final AtomicInteger registryGCCycles = new AtomicInteger();
    private String prog;
    private String anaconda_dir;
    private String anaconda_project_dir;
    @Resource
    private TimerService timerService;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private LibraryController libraryController;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private EnvironmentController environmentController;
    @EJB
    private Settings settings;
    @Inject
    private DockerRegistryMngr registry;
    private ManagedExecutorService executorService;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private SecretsController secretsController;
    @EJB
    private HdfsUsersController hdfsUsersController;

    @PostConstruct
    public void init() {
        this.prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        this.anaconda_dir = this.settings.getAnacondaDir();
        this.anaconda_project_dir = this.anaconda_dir + "/envs/" + this.settings.getCurrentCondaEnvironment();
        List<CondaCommands> allOngoing = this.condaCommandFacade.findByStatus(CondaStatus.ONGOING);
        allOngoing.forEach(cc -> {
            cc.setStatus(CondaStatus.FAILED);
            cc.setErrorMsg("Could not run conda command due to internal server error. Please try again.");
            this.condaCommandFacade.update(cc);
        });
        try {
            this.executorService = (ManagedExecutorService)InitialContext.doLookup("concurrent/condaExecutorService");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error looking up for the condaExecutorService", e);
        }
        this.schedule();
    }

    private void schedule() {
        this.timerService.createSingleActionTimer(1000L, new TimerConfig((Serializable)((Object)"python library installer"), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void isAlive() {
        try {
            LOG.log(Level.FINE, "isAlive-start: " + System.currentTimeMillis());
            this.registryGCCycles.incrementAndGet();
            List<CondaCommands> allCondaCommandsOngoing = this.condaCommandFacade.findByStatus(CondaStatus.ONGOING);
            if (this.registryGCCycles.get() % 10 == 0 && allCondaCommandsOngoing.isEmpty()) {
                this.registryGCCycles.set(0);
                try {
                    LOG.log(Level.FINE, "registryGC-start: " + System.currentTimeMillis());
                    this.registry.gc();
                    LOG.log(Level.FINE, "registryGC-stop: " + System.currentTimeMillis());
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Could not run conda remove commands", ex);
                }
            } else {
                Map<Project, List<CondaCommands>> allCondaCommandsNewByProject = this.getCondaCommandsByProject(this.condaCommandFacade.findByStatus(CondaStatus.NEW));
                Map<Project, List<CondaCommands>> allCondaCommandsOngoingByProject = this.getCondaCommandsByProject(this.condaCommandFacade.findByStatus(CondaStatus.ONGOING));
                LOG.log(Level.FINE, "allCondaCommandsOngoingByProject:" + allCondaCommandsOngoingByProject);
                for (Project project : allCondaCommandsNewByProject.keySet()) {
                    if (!allCondaCommandsOngoingByProject.containsKey(project)) {
                        try {
                            this.executorService.submit(() -> this.condaCommandHandler((List)allCondaCommandsNewByProject.get(project)));
                        }
                        catch (Exception ex) {
                            LOG.log(Level.WARNING, "Could not run conda commands for project: " + project, ex);
                        }
                        continue;
                    }
                    LOG.log(Level.FINE, "Project " + project.getName() + " is already processing a conda command, skipping...");
                }
            }
        }
        finally {
            LOG.log(Level.FINE, "isAlive-stop: " + System.currentTimeMillis());
            this.schedule();
        }
    }

    private void condaCommandHandler(List<CondaCommands> projectCondaCommands) {
        projectCondaCommands.sort(ASC_COMPARATOR);
        for (CondaCommands cc : projectCondaCommands) {
            if (cc.getOp() == CondaOp.REMOVE) continue;
            try {
                try {
                    this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.ONGOING, cc.getArg(), cc.getOp());
                    switch (cc.getOp()) {
                        case CREATE: 
                        case IMPORT: {
                            this.createNewImage(cc);
                            break;
                        }
                        case INSTALL: {
                            this.installLibrary(cc);
                            break;
                        }
                        case UNINSTALL: {
                            this.uninstallLibrary(cc);
                            break;
                        }
                        case EXPORT: {
                            this.exportLibraries(cc);
                            break;
                        }
                        case SYNC_BASE_ENV: {
                            this.syncBaseLibraries(cc);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("conda command unknown: " + cc.getOp());
                        }
                    }
                }
                catch (Throwable ex) {
                    LOG.log(Level.WARNING, "Could not execute command with ID: " + cc.getId(), ex);
                    this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.FAILED, cc.getArg(), cc.getOp(), ex.toString());
                    continue;
                }
                this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.SUCCESS, cc.getArg(), cc.getOp());
            }
            catch (ProjectException | ServiceException ex) {
                LOG.log(Level.WARNING, "Could not update command with ID: " + cc.getId(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewImage(CondaCommands cc) throws IOException, ServiceDiscoveryException {
        File baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        try {
            File home = new File(System.getProperty("user.home"));
            File condarc = new File(home, ".condarc");
            File pip = new File(home, ".pip");
            FileUtils.copyFileToDirectory((File)condarc, (File)baseDir);
            FileUtils.copyDirectoryToDirectory((File)pip, (File)baseDir);
            File dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));){
                String baseImage = this.projectUtils.getFullBaseImageName();
                if (!Strings.isNullOrEmpty((String)cc.getEnvironmentFile()) && !cc.getInstallJupyter().booleanValue()) {
                    baseImage = baseImage.replace(this.settings.getBaseDockerImagePythonName(), this.settings.getBaseNonPythonDockerImage());
                }
                writer.write("# syntax=docker/dockerfile:experimental");
                writer.newLine();
                writer.write("FROM " + baseImage);
                writer.newLine();
                if (!Strings.isNullOrEmpty((String)cc.getEnvironmentFile())) {
                    writer.write("RUN rm -f /root/.condarc");
                    writer.newLine();
                    String environmentFilePath = cc.getEnvironmentFile();
                    String environmentFile = FilenameUtils.getName((String)environmentFilePath);
                    writer.write("COPY .condarc .pip " + environmentFile + " /root/");
                    writer.newLine();
                    this.copyCondaArtifactToLocal(environmentFilePath, baseDir + File.separator + environmentFile);
                    if (environmentFilePath.endsWith(".yml")) {
                        if (cc.getInstallJupyter().booleanValue()) {
                            writer.write("RUN conda env update -f /root/" + environmentFile + " -n " + this.settings.getCurrentCondaEnvironment());
                        } else {
                            writer.write("RUN conda env create -f /root/" + environmentFile + " -p " + this.anaconda_project_dir);
                        }
                    } else if (environmentFilePath.endsWith("/requirements.txt")) {
                        if (cc.getInstallJupyter().booleanValue()) {
                            writer.write("RUN pip install -r /root/" + environmentFile);
                        } else {
                            writer.write("RUN conda create -y -p " + this.anaconda_project_dir + " python=" + this.settings.getDockerBaseImagePythonVersion() + " && pip install -r /root/" + environmentFile);
                        }
                    }
                    writer.write(" && " + this.getCleanupCommand() + " && " + this.anaconda_dir + "/bin/conda list -n " + this.settings.getCurrentCondaEnvironment());
                }
            }
            Project project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
            String initialDockerImage = this.projectUtils.getInitialDockerImageName(project);
            LOG.log(Level.FINEST, "project-initialDockerImage:" + initialDockerImage);
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + initialDockerImage).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(1L, TimeUnit.HOURS).build();
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
            project.setDockerImage(initialDockerImage);
            project = this.projectFacade.update(project);
            this.projectFacade.flushEm();
            this.setPipConflicts(project);
            this.environmentController.updateInstalledDependencies(project);
        }
        catch (ProjectException | PythonException | ServiceException e) {
            LOG.log(Level.SEVERE, "Failed to persist python deps", e);
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    private String getCleanupCommand() {
        return this.anaconda_dir + "/bin/conda clean -afy && rm -rf ~/.cache && rm -rf /usr/local/share/.cache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installLibrary(CondaCommands cc) throws IOException, ServiceException, ServiceDiscoveryException, ProjectException, UserException, PythonException {
        File baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        Project project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
        try {
            File home = new File(System.getProperty("user.home"));
            File condarc = new File(home, ".condarc");
            File pip = new File(home, ".pip");
            FileUtils.copyFileToDirectory((File)condarc, (File)baseDir);
            FileUtils.copyDirectoryToDirectory((File)pip, (File)baseDir);
            File dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
            String apiToken = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));){
                writer.write("# syntax=docker/dockerfile:experimental");
                writer.newLine();
                writer.write("FROM " + this.projectUtils.getFullDockerImageName(project, false));
                writer.newLine();
                writer.write("RUN --mount=type=bind,source=.condarc,target=/root/.condarc --mount=type=bind,source=.pip,target=/root/.pip ");
                switch (cc.getInstallType()) {
                    case CONDA: {
                        String condaLib = cc.getVersion().equals("UNKNOWN") ? cc.getLib() : cc.getLib() + "=" + cc.getVersion();
                        writer.write(this.anaconda_dir + "/bin/conda install -y -n " + this.settings.getCurrentCondaEnvironment() + " -c " + cc.getChannelUrl() + " " + condaLib);
                        break;
                    }
                    case PIP: {
                        String pipLib = cc.getVersion().equals("UNKNOWN") ? cc.getLib() : cc.getLib() + "==" + cc.getVersion();
                        writer.write(this.anaconda_project_dir + "/bin/pip install --upgrade " + pipLib);
                        break;
                    }
                    case EGG: {
                        String eggName = cc.getLib();
                        String localEggPath = baseDir + File.separator + eggName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localEggPath);
                        writer.write("--mount=type=bind,source=" + eggName + ",target=/root/" + eggName + " ");
                        writer.write(this.anaconda_project_dir + "/bin/easy_install --upgrade /root/" + eggName);
                        break;
                    }
                    case WHEEL: {
                        String wheelName = cc.getLib();
                        String localWheelPath = baseDir + File.separator + wheelName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localWheelPath);
                        writer.write("--mount=type=bind,source=" + wheelName + ",target=/root/" + wheelName + " ");
                        writer.write(this.anaconda_project_dir + "/bin/pip install --upgrade /root/" + wheelName);
                        break;
                    }
                    case REQUIREMENTS_TXT: {
                        String requirementsName = cc.getLib();
                        String localRequirementsName = baseDir + File.separator + requirementsName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localRequirementsName);
                        writer.write("--mount=type=bind,source=" + requirementsName + ",target=/root/" + requirementsName + " ");
                        writer.write(this.anaconda_project_dir + "/bin/pip install -r /root/" + requirementsName);
                        break;
                    }
                    case ENVIRONMENT_YAML: {
                        String environmentsName = cc.getLib();
                        String localEnvironmentsName = baseDir + File.separator + environmentsName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localEnvironmentsName);
                        writer.write("--mount=type=bind,source=" + environmentsName + ",target=/root/" + environmentsName + " ");
                        writer.write(this.anaconda_dir + "/bin/conda env update -f /root/" + environmentsName + " -n " + this.settings.getCurrentCondaEnvironment());
                        break;
                    }
                    case GIT: {
                        if (cc.getGitBackend() != null && cc.getGitApiKeyName() != null) {
                            apiToken = this.secretsController.get(cc.getUserId(), cc.getGitApiKeyName()).getPlaintext();
                            URL repoUrl = new URL(cc.getArg());
                            if (cc.getGitBackend().equals((Object)GitBackend.GITHUB)) {
                                writer.write(this.anaconda_project_dir + "/bin/pip install --upgrade 'git+https://" + apiToken + ":x-oauth-basic@" + repoUrl.getHost() + repoUrl.getPath() + "'");
                                break;
                            }
                            if (!cc.getGitBackend().equals((Object)GitBackend.GITLAB)) break;
                            writer.write(this.anaconda_project_dir + "/bin/pip install --upgrade 'git+https://oauth2:" + apiToken + "@" + repoUrl.getHost() + repoUrl.getPath() + "'");
                            break;
                        }
                        writer.write(this.anaconda_project_dir + "/bin/pip install --upgrade 'git+" + cc.getArg() + "'");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
                    }
                }
                writer.write(" && " + this.getCleanupCommand() + " && " + this.anaconda_dir + "/bin/conda list -n " + this.settings.getCurrentCondaEnvironment());
            }
            String nextDockerImageName = this.getNextDockerImageName(project);
            LOG.log(Level.FINEST, "project-nextDockerImageName:" + nextDockerImageName);
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + nextDockerImageName).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(1L, TimeUnit.HOURS).build();
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg;
                if (cc.getInstallType().equals((Object)CondaInstallType.GIT) && !Strings.isNullOrEmpty((String)apiToken)) {
                    String stderr;
                    errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode();
                    String stdout = processResult.getStdout();
                    if (stdout != null) {
                        errorMsg = errorMsg + " out: " + stdout.replaceAll(apiToken, cc.getGitApiKeyName() + "_token");
                    }
                    if ((stderr = processResult.getStderr()) != null) {
                        errorMsg = errorMsg + "\n err: " + stderr.replaceAll(apiToken, cc.getGitApiKeyName() + "_token");
                    }
                    errorMsg = errorMsg + "||\n";
                    throw new IOException(errorMsg);
                }
                errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
            project.setDockerImage(nextDockerImageName);
            project = this.projectFacade.update(project);
            this.projectFacade.flushEm();
            this.setPipConflicts(project);
            this.environmentController.updateInstalledDependencies(project);
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void uninstallLibrary(CondaCommands cc) throws IOException, ServiceDiscoveryException, ProjectException, ServiceException, PythonException {
        baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        try {
            dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
            home = new File(System.getProperty("user.home"));
            FileUtils.copyFileToDirectory((File)new File(home, ".condarc"), (File)baseDir);
            FileUtils.copyDirectoryToDirectory((File)new File(home, ".pip"), (File)baseDir);
            writer = new BufferedWriter(new FileWriter(dockerFile));
            var6_6 = null;
            try {
                writer.write("# syntax=docker/dockerfile:experimental");
                writer.newLine();
                writer.write("FROM " + this.projectUtils.getFullDockerImageName(cc.getProjectId(), false) + "\n");
                writer.newLine();
                writer.write("RUN --mount=type=bind,source=.condarc,target=/root/.condarc --mount=type=bind,source=.pip,target=/root/.pip ");
                switch (1.$SwitchMap$io$hops$hopsworks$persistence$entity$python$CondaInstallType[cc.getInstallType().ordinal()]) {
                    case 1: {
                        writer.write(this.anaconda_dir + "/bin/conda remove -y -n " + this.settings.getCurrentCondaEnvironment() + " " + cc.getLib() + " || true\n");
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        writer.write(this.anaconda_project_dir + "/bin/pip uninstall -y " + cc.getLib() + " || true\n");
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
                    }
                }
            }
            catch (Throwable var7_8) {
                var6_6 = var7_8;
                throw var7_8;
            }
            finally {
                if (writer != null) {
                    if (var6_6 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable var7_7) {
                            var6_6.addSuppressed(var7_7);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow((Supplier<ProjectException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$uninstallLibrary$6(io.hops.hopsworks.persistence.entity.python.CondaCommands ), ()Lio/hops/hopsworks/exceptions/ProjectException;)((CondaCommands)cc));
            nextDockerImageName = this.getNextDockerImageName(project);
            processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + nextDockerImageName).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(10L, TimeUnit.MINUTES).build();
            processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow((Supplier<ProjectException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$uninstallLibrary$7(io.hops.hopsworks.persistence.entity.python.CondaCommands ), ()Lio/hops/hopsworks/exceptions/ProjectException;)((CondaCommands)cc));
            project.setDockerImage(nextDockerImageName);
            project = this.projectFacade.update(project);
            this.projectFacade.flushEm();
            this.setPipConflicts(project);
            this.environmentController.updateInstalledDependencies(project);
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCondaArtifactToLocal(String source, String destPath) throws IOException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfs.getDfsOps();
            dfso.copyToLocal(source, destPath);
        }
    }

    private void setPipConflicts(Project project) throws IOException, ServiceDiscoveryException, ServiceException, PythonException {
        String[] lines;
        String conflictStr = this.environmentController.getPipConflicts(project);
        if (Strings.isNullOrEmpty((String)conflictStr)) {
            project.getPythonEnvironment().setJupyterConflicts(Boolean.valueOf(false));
            project.getPythonEnvironment().setConflicts(null);
            return;
        }
        ArrayList<String> conflicts = new ArrayList<String>();
        for (String conflictLine : lines = conflictStr.split("\n")) {
            conflicts.add(conflictLine.split("\\s+")[0].trim());
        }
        List intersect = this.settings.getJupyterDependencies().stream().filter(conflicts::contains).collect(Collectors.toList());
        if (conflicts.isEmpty()) {
            project.getPythonEnvironment().setJupyterConflicts(Boolean.valueOf(false));
            project.getPythonEnvironment().setConflicts(null);
        } else {
            project.getPythonEnvironment().setConflicts(conflictStr.substring(0, Math.min(conflictStr.length(), 12000)));
            if (intersect != null && intersect.size() > 0) {
                project.getPythonEnvironment().setJupyterConflicts(Boolean.valueOf(true));
            } else {
                project.getPythonEnvironment().setJupyterConflicts(Boolean.valueOf(false));
            }
        }
    }

    public void exportLibraries(CondaCommands cc) throws IOException, ServiceException, ServiceDiscoveryException, ProjectException {
        Project project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("export").addCommand(this.projectUtils.getFullDockerImageName(project, false)).redirectErrorStream(true).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
        if (processResult.getExitCode() != 0) {
            String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
            throw new IOException(errorMsg);
        }
        this.environmentController.uploadYmlInProject(project, cc.getUserId(), processResult.getStdout(), cc.getArg());
    }

    public void syncBaseLibraries(CondaCommands cc) throws ServiceException, ServiceDiscoveryException, ProjectException {
        Project project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
        Collection<PythonDep> projectDeps = this.libraryController.listLibraries(this.projectUtils.getFullDockerImageName(project, true));
        projectDeps = this.libraryController.persistAndMarkImmutable(projectDeps);
        project.setPythonDepCollection(projectDeps);
        this.projectFacade.update(project);
    }

    private String getNextDockerImageName(Project project) {
        String dockerImage = ProjectUtils.getDockerImageName(project, this.settings, false);
        int indexOfLastDigit = dockerImage.lastIndexOf(".");
        int currentVersion = Integer.parseInt(dockerImage.substring(indexOfLastDigit + 1));
        int nextVersion = currentVersion + 1;
        return dockerImage.substring(0, indexOfLastDigit) + "." + nextVersion;
    }

    private Map<Project, List<CondaCommands>> getCondaCommandsByProject(List<CondaCommands> condaCommands) {
        HashMap<Project, List<CondaCommands>> condaCommandsByProject = new HashMap<Project, List<CondaCommands>>();
        for (CondaCommands condacommand : condaCommands) {
            if (condacommand.getOp() != CondaOp.REMOVE && (condacommand.getProjectId() == null || condacommand.getProjectId().getPythonEnvironment() == null)) {
                LOG.log(Level.FINEST, "Removing condacommand: " + condacommand);
                this.condaCommandFacade.remove(condacommand);
                continue;
            }
            Project project = condacommand.getProjectId();
            if (!condaCommandsByProject.containsKey(project)) {
                condaCommandsByProject.put(project, new ArrayList());
            }
            ((List)condaCommandsByProject.get(project)).add(condacommand);
        }
        return condaCommandsByProject;
    }

    private static /* synthetic */ ProjectException lambda$uninstallLibrary$7(CondaCommands cc) {
        return new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId());
    }

    private static /* synthetic */ ProjectException lambda$uninstallLibrary$6(CondaCommands cc) {
        return new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId());
    }

    private static class CommandsComparator<T>
    implements Comparator<T> {
        private CommandsComparator() {
        }

        @Override
        public int compare(T t, T t1) {
            if (t instanceof CondaCommands && t1 instanceof CondaCommands) {
                return this.condaCommandCompare((CondaCommands)t, (CondaCommands)t1);
            }
            if (t instanceof SystemCommand && t1 instanceof SystemCommand) {
                return this.systemCommandCompare((SystemCommand)t, (SystemCommand)t1);
            }
            return 0;
        }

        private int condaCommandCompare(CondaCommands t, CondaCommands t1) {
            return t.getId().compareTo(t1.getId());
        }

        private int systemCommandCompare(SystemCommand t, SystemCommand t1) {
            return t.getId().compareTo(t1.getId());
        }
    }
}

