/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import io.hops.hopsworks.common.jupyter.CidAndPort;
import io.hops.hopsworks.common.jwt.ServiceJWT;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.nio.file.Path;
import java.time.LocalDateTime;

public final class JupyterJWT
extends ServiceJWT {
    public final CidAndPort pidAndPort;
    public Path tokenFile;

    public JupyterJWT(JupyterJWT jupyterJWT) {
        this(jupyterJWT.project, jupyterJWT.user, jupyterJWT.expiration, jupyterJWT.pidAndPort);
        this.tokenFile = jupyterJWT.tokenFile;
    }

    public JupyterJWT(Project project, Users user, LocalDateTime expiration, CidAndPort pidAndPort) {
        super(project, user, expiration);
        this.pidAndPort = pidAndPort;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JupyterJWT) {
            JupyterJWT other = (JupyterJWT)o;
            return this.user.getUid().equals(other.user.getUid()) && this.project.getId().equals(other.project.getId());
        }
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.project.getName() + "/" + this.user.getUsername() + ")";
    }
}

