/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.redshift;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.redshift.FeaturestoreRedshiftConnectorDTO;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.redshift.FeatureStoreRedshiftConnector;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreRedshiftConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreRedshiftConnectorController.class.getName());
    @EJB
    private SecretsController secretsController;
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private Settings settings;
    @EJB
    private UserFacade userFacade;

    public FeaturestoreRedshiftConnectorDTO getRedshiftConnectorDTO(Users user, FeaturestoreConnector featurestoreConnector) {
        FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO = new FeaturestoreRedshiftConnectorDTO(featurestoreConnector);
        featurestoreRedshiftConnectorDTO.setDatabasePassword(this.getDatabasePassword(featurestoreConnector.getRedshiftConnector(), user));
        return featurestoreRedshiftConnectorDTO;
    }

    public FeatureStoreRedshiftConnector createFeaturestoreRedshiftConnector(Users user, Featurestore featurestore, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO) throws FeaturestoreException, UserException, ProjectException {
        this.verifyCreateDTO(featurestoreRedshiftConnectorDTO);
        FeatureStoreRedshiftConnector featurestoreRedshiftConnector = new FeatureStoreRedshiftConnector();
        featurestoreRedshiftConnector.setClusterIdentifier(featurestoreRedshiftConnectorDTO.getClusterIdentifier());
        featurestoreRedshiftConnector.setDatabaseDriver(featurestoreRedshiftConnectorDTO.getDatabaseDriver());
        featurestoreRedshiftConnector.setDatabaseEndpoint(featurestoreRedshiftConnectorDTO.getDatabaseEndpoint());
        featurestoreRedshiftConnector.setDatabaseName(featurestoreRedshiftConnectorDTO.getDatabaseName());
        featurestoreRedshiftConnector.setDatabasePort(featurestoreRedshiftConnectorDTO.getDatabasePort().intValue());
        featurestoreRedshiftConnector.setTableName(featurestoreRedshiftConnectorDTO.getTableName());
        featurestoreRedshiftConnector.setDatabaseUserName(featurestoreRedshiftConnectorDTO.getDatabaseUserName());
        this.setPassword(user, featurestoreRedshiftConnectorDTO, featurestore, featurestoreRedshiftConnector);
        featurestoreRedshiftConnector.setIamRole(featurestoreRedshiftConnectorDTO.getIamRole());
        featurestoreRedshiftConnector.setAutoCreate(featurestoreRedshiftConnectorDTO.getAutoCreate());
        featurestoreRedshiftConnector.setDatabaseGroup(featurestoreRedshiftConnectorDTO.getDatabaseGroup());
        featurestoreRedshiftConnector.setArguments(featurestoreRedshiftConnectorDTO.getArguments());
        return featurestoreRedshiftConnector;
    }

    private void setPassword(Users user, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO, Featurestore featurestore, FeatureStoreRedshiftConnector featurestoreRedshiftConnector) throws UserException, ProjectException {
        if (!Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            Secret secret = this.secretsController.createSecretForProject(user, this.createSecretName(featurestore, featurestoreRedshiftConnectorDTO.getName()), featurestoreRedshiftConnectorDTO.getDatabasePassword(), featurestore.getProject().getId());
            featurestoreRedshiftConnector.setSecret(secret);
        }
    }

    private String createSecretName(Featurestore featurestore, String connectorName) {
        return "redshift_" + connectorName.replaceAll(" ", "_").toLowerCase() + "_" + featurestore.getId();
    }

    private void verifyCreateDTO(FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getArguments()) && featurestoreRedshiftConnectorDTO.getArguments().length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Redshift connection arguments should not exceed: 2000 characters");
        }
        this.verifyPassword(featurestoreRedshiftConnectorDTO);
    }

    private void verifyPassword(FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO) throws FeaturestoreException {
        this.verifyPassword(featurestoreRedshiftConnectorDTO.getIamRole(), featurestoreRedshiftConnectorDTO.getDatabasePassword());
    }

    private void verifyPassword(String iamRole, String password) throws FeaturestoreException {
        boolean needPassword;
        boolean bl = needPassword = !this.settings.isIAMRoleConfigured() && Strings.isNullOrEmpty((String)iamRole);
        if (needPassword && Strings.isNullOrEmpty((String)password)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database password not set.");
        }
        if (!needPassword && !Strings.isNullOrEmpty((String)password)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database password is not allowed.");
        }
    }

    private void verifyPassword(String iamRole, Secret secret) throws FeaturestoreException {
        boolean needPassword;
        boolean bl = needPassword = !this.settings.isIAMRoleConfigured() && Strings.isNullOrEmpty((String)iamRole);
        if (needPassword && secret == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database password not set.");
        }
        if (!needPassword && secret != null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database password is not allowed.");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeatureStoreRedshiftConnector updateFeaturestoreRedshiftConnector(Users user, Featurestore featurestore, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO, FeatureStoreRedshiftConnector featureStoreRedshiftConnector) throws FeaturestoreException, UserException, ProjectException {
        if (!Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getClusterIdentifier()) && !featurestoreRedshiftConnectorDTO.getClusterIdentifier().equals(featureStoreRedshiftConnector.getClusterIdentifier())) {
            featureStoreRedshiftConnector.setClusterIdentifier(featurestoreRedshiftConnectorDTO.getClusterIdentifier());
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getDatabaseDriver(), featurestoreRedshiftConnectorDTO.getDatabaseDriver())) {
            featureStoreRedshiftConnector.setDatabaseDriver(featurestoreRedshiftConnectorDTO.getDatabaseDriver());
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getDatabaseEndpoint(), featurestoreRedshiftConnectorDTO.getDatabaseEndpoint())) {
            featureStoreRedshiftConnector.setDatabaseEndpoint(featurestoreRedshiftConnectorDTO.getDatabaseEndpoint());
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getDatabaseName(), featurestoreRedshiftConnectorDTO.getDatabaseName())) {
            featureStoreRedshiftConnector.setDatabaseName(featurestoreRedshiftConnectorDTO.getDatabaseName());
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getDatabaseUserName(), featurestoreRedshiftConnectorDTO.getDatabaseUserName())) {
            featureStoreRedshiftConnector.setDatabaseUserName(featurestoreRedshiftConnectorDTO.getDatabaseUserName());
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getDatabaseGroup(), featurestoreRedshiftConnectorDTO.getDatabaseGroup())) {
            featureStoreRedshiftConnector.setDatabaseGroup(featurestoreRedshiftConnectorDTO.getDatabaseGroup());
        }
        if (featurestoreRedshiftConnectorDTO.getAutoCreate() != featureStoreRedshiftConnector.getAutoCreate()) {
            featureStoreRedshiftConnector.setAutoCreate(featurestoreRedshiftConnectorDTO.getAutoCreate());
        }
        if (this.shouldUpdate(featurestoreRedshiftConnectorDTO.getDatabasePort(), featureStoreRedshiftConnector.getDatabasePort())) {
            featureStoreRedshiftConnector.setDatabasePort(featurestoreRedshiftConnectorDTO.getDatabasePort().intValue());
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getTableName(), featurestoreRedshiftConnectorDTO.getTableName())) {
            featureStoreRedshiftConnector.setTableName(featurestoreRedshiftConnectorDTO.getTableName());
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getIamRole(), featurestoreRedshiftConnectorDTO.getIamRole())) {
            featureStoreRedshiftConnector.setIamRole(featurestoreRedshiftConnectorDTO.getIamRole());
        }
        Secret secret = null;
        if (this.shouldUpdate(this.getDatabasePassword(featureStoreRedshiftConnector, user), featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            secret = this.updatePassword(user, featurestoreRedshiftConnectorDTO, featurestore, featureStoreRedshiftConnector);
        }
        if (this.shouldUpdate(featureStoreRedshiftConnector.getArguments(), featurestoreRedshiftConnectorDTO.getArguments())) {
            featureStoreRedshiftConnector.setArguments(featurestoreRedshiftConnectorDTO.getArguments());
        }
        this.verifyPassword(featureStoreRedshiftConnector.getIamRole(), featureStoreRedshiftConnector.getSecret());
        if (featureStoreRedshiftConnector.getSecret() == null && secret != null) {
            this.secretsFacade.deleteSecret(secret.getId());
        }
        return featureStoreRedshiftConnector;
    }

    private Secret updatePassword(Users user, FeaturestoreRedshiftConnectorDTO featurestoreRedshiftConnectorDTO, Featurestore featurestore, FeatureStoreRedshiftConnector featureStoreRedshiftConnector) throws UserException, ProjectException {
        Secret secret = featureStoreRedshiftConnector.getSecret();
        if (secret != null) {
            this.secretsController.checkCanAccessSecret(secret, user);
        }
        if (secret == null && !Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            this.setPassword(user, featurestoreRedshiftConnectorDTO, featurestore, featureStoreRedshiftConnector);
        } else if (!Strings.isNullOrEmpty((String)featurestoreRedshiftConnectorDTO.getDatabasePassword())) {
            try {
                secret.setSecret(this.secretsController.encryptSecret(featurestoreRedshiftConnectorDTO.getDatabasePassword()));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secret.getId().getName(), (Throwable)e);
            }
        } else {
            featureStoreRedshiftConnector.setSecret(null);
        }
        return secret;
    }

    private boolean shouldUpdate(String oldVal, String newVal) {
        return oldVal == null && newVal != null || oldVal != null && !oldVal.equals(newVal);
    }

    private boolean shouldUpdate(Integer oldVal, Integer newVal) {
        return oldVal == null && newVal != null || oldVal != null && !oldVal.equals(newVal);
    }

    private String getDatabasePassword(FeatureStoreRedshiftConnector featureStoreRedshiftConnector, Users user) {
        if (featureStoreRedshiftConnector.getSecret() == null) {
            return null;
        }
        Users owner = (Users)this.userFacade.find(featureStoreRedshiftConnector.getSecret().getId().getUid());
        try {
            return this.secretsController.getShared(user, owner, featureStoreRedshiftConnector.getSecret().getId().getName()).getPlaintext();
        }
        catch (ProjectException | ServiceException | UserException throwable) {
            return "";
        }
    }
}

