/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.livy;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.dao.jobhistory.YarnApplicationstateFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.livy.LivyMsg;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.jobs.history.YarnApplicationstate;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

@Stateless
public class LivyController {
    private static final Logger LOGGER = Logger.getLogger(LivyController.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private ProjectTeamFacade teambean;
    @EJB
    private UserFacade userFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private HdfsUsersController hdfsUserBean;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private YarnApplicationstateFacade appStateBean;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;

    public List<LivyMsg.Session> getLivySessions(Project project) {
        ArrayList<LivyMsg.Session> sessions = new ArrayList<LivyMsg.Session>();
        LivyMsg sessionList = this.getLivySessions();
        if (sessionList == null || sessionList.getSessions() == null || sessionList.getSessions().length == 0) {
            return sessions;
        }
        List<ProjectTeam> projectTeam = this.teambean.findMembersByProject(project);
        for (ProjectTeam member : projectTeam) {
            String hdfsUsername = this.hdfsUserBean.getHdfsUserName(project, member.getUser());
            for (LivyMsg.Session s : sessionList.getSessions()) {
                YarnApplicationstate appStates;
                if (!hdfsUsername.equals(s.getProxyUser()) || (appStates = this.appStateBean.findByAppId(s.getAppId())) == null) continue;
                s.setOwner(member.getUser().getEmail());
                sessions.add(s);
            }
        }
        return sessions;
    }

    public void deleteAllLivySessionsForProject(Project project) {
        List<ProjectTeam> projectTeam = this.teambean.findMembersByProject(project);
        for (ProjectTeam member : projectTeam) {
            String hdfsUsername = this.hdfsUserBean.getHdfsUserName(project, member.getUser());
            this.deleteAllLivySessions(hdfsUsername);
        }
    }

    public List<LivyMsg.Session> getLivySessionsForProjectUser(Project project, Users user) {
        ArrayList<LivyMsg.Session> sessions = new ArrayList<LivyMsg.Session>();
        LivyMsg sessionList = this.getLivySessions();
        if (sessionList == null || sessionList.getSessions() == null || sessionList.getSessions().length == 0) {
            return sessions;
        }
        String hdfsUsername = this.hdfsUserBean.getHdfsUserName(project, user);
        for (LivyMsg.Session s : sessionList.getSessions()) {
            YarnApplicationstate appStates;
            if (!hdfsUsername.equals(s.getProxyUser()) || (appStates = this.appStateBean.findByAppId(s.getAppId())) == null) continue;
            s.setOwner(user.getEmail());
            sessions.add(s);
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LivyMsg.Session getLivySession(int sessionId) {
        LivyMsg.Session session = null;
        try (Client client = ClientBuilder.newClient();){
            String livyUrl = this.getLivyURL();
            WebTarget target = client.target(livyUrl).path("/sessions/" + sessionId);
            session = (LivyMsg.Session)target.request().get(LivyMsg.Session.class);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LivyMsg getLivySessions() {
        LivyMsg livySession = null;
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.getLivyURL()).path("/sessions");
            livySession = (LivyMsg)target.request().get(LivyMsg.class);
        }
        return livySession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteLivySession(int sessionId) {
        Response res;
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.getLivyURL()).path("/sessions/" + sessionId);
            res = target.request().delete();
        }
        return res.getStatus();
    }

    public void deleteAllLivySessions(String hdfsUser) {
        String username = this.hdfsUsersController.getUserName(hdfsUser);
        String projectname = this.hdfsUsersController.getProjectName(hdfsUser);
        Users user = this.userFacade.findByUsername(username);
        Project project = this.projectFacade.findByName(projectname);
        List<LivyMsg.Session> sessions = this.getLivySessionsForProjectUser(project, user);
        for (LivyMsg.Session session : sessions) {
            this.deleteLivySession(session.getId());
        }
    }

    public boolean isLivySessionAlive(int sessionId) {
        LivyMsg.Session session = this.getLivySession(sessionId);
        return session != null;
    }

    private String getLivyURL() throws ServiceDiscoveryException {
        Service livy = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.LIVY);
        return "http://" + livy.getAddress() + ":" + livy.getPort();
    }
}

