/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ProcessDescriptor {
    private final List<String> subcommands;
    private final File cwd;
    private final Map<String, String> env;
    private final long waitTimeout;
    private final TimeUnit timeoutUnit;
    private final boolean redirectErrorStream;
    private final boolean ignoreOutErrStreams;

    private ProcessDescriptor(Builder builder) {
        this.subcommands = builder.subcommands;
        this.cwd = builder.cwd;
        this.env = builder.env;
        this.waitTimeout = builder.waitTimeout;
        this.timeoutUnit = builder.timeoutUnit;
        this.redirectErrorStream = builder.redirectErrorStream;
        this.ignoreOutErrStreams = builder.ignoreOutErrStreams;
    }

    public List<String> getSubcommands() {
        return this.subcommands;
    }

    public File getCwd() {
        return this.cwd;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.env;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    public boolean ignoreOutErrStreams() {
        return this.ignoreOutErrStreams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("COMMAND: ");
        for (String sc : this.subcommands) {
            sb.append(sc).append(" ");
        }
        return sb.toString();
    }

    public static class Builder {
        private final List<String> subcommands;
        private File cwd = null;
        private final Map<String, String> env;
        private long waitTimeout = 20L;
        private TimeUnit timeoutUnit = TimeUnit.SECONDS;
        private boolean redirectErrorStream = false;
        private boolean ignoreOutErrStreams = false;

        public Builder() {
            this.subcommands = new ArrayList<String>();
            this.env = new HashMap<String, String>();
        }

        public Builder addCommand(String subcommand) {
            this.subcommands.add(subcommand);
            return this;
        }

        public Builder addEnvironmentVariable(String key, String value) {
            this.env.put(key, value);
            return this;
        }

        public Builder setCurrentWorkingDirectory(File cwd) {
            this.cwd = cwd;
            return this;
        }

        public Builder setWaitTimeout(long waitTimeout, TimeUnit timeoutUnit) {
            this.waitTimeout = waitTimeout;
            this.timeoutUnit = timeoutUnit;
            return this;
        }

        public Builder redirectErrorStream(boolean redirectErrorStream) {
            this.redirectErrorStream = redirectErrorStream;
            return this;
        }

        public Builder ignoreOutErrStreams(boolean ignoreOutErrStreams) {
            this.ignoreOutErrStreams = ignoreOutErrStreams;
            if (ignoreOutErrStreams) {
                this.redirectErrorStream = true;
            }
            return this;
        }

        public ProcessDescriptor build() {
            if (this.subcommands.isEmpty()) {
                throw new IllegalArgumentException("Commands cannot be empty");
            }
            return new ProcessDescriptor(this);
        }
    }
}

