/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset.util;

import io.hops.hopsworks.common.api.ResourceRequest;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWithFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.dataset.util.DatasetPath;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class DatasetHelper {
    private static final Logger LOGGER = Logger.getLogger(DatasetHelper.class.getName());
    private static final int MAX_INODES_TOBE_RETURNED = 10000;
    @EJB
    private DatasetSharedWithFacade datasetSharedWithFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private InodeController inodeController;
    @EJB
    private Settings settings;

    public DatasetPath getNewDatasetPath(Project project, String path, DatasetType datasetType) throws DatasetException {
        DatasetPath datasetPath;
        String rootDir = datasetType == null ? (path.startsWith(this.settings.getHiveWarehouse()) ? this.settings.getHiveWarehouse() : "Projects") : (datasetType.equals((Object)DatasetType.DATASET) ? "Projects" : this.settings.getHiveWarehouse());
        try {
            datasetPath = new DatasetPath(project, path, rootDir);
        }
        catch (UnsupportedEncodingException e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.PATH_ENCODING_NOT_SUPPORTED, Level.FINE);
        }
        return datasetPath;
    }

    public DatasetPath getDatasetPathFromAbsolute(Project project, String path) throws DatasetException {
        return this.getDatasetPath(project, path, null);
    }

    public DatasetPath getDatasetPath(Project project, String path, DatasetType datasetType) throws DatasetException {
        DatasetPath datasetPath = this.getNewDatasetPath(project, path, datasetType);
        Dataset dataset = this.datasetController.getByProjectAndFullPath(project, datasetPath.getDatasetFullPath().toString());
        datasetPath.setDataset(dataset);
        if (dataset != null && dataset.isShared(project)) {
            DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset);
            datasetPath.setDatasetSharedWith(datasetSharedWith);
        }
        if (datasetPath.isTopLevelDataset()) {
            datasetPath.setInode(datasetPath.getDataset().getInode());
        } else {
            datasetPath.setInode(this.inodeController.getInodeAtPath(datasetPath.getDataset().getInode(), datasetPath.getDatasetFullPath().depth(), datasetPath.getDatasetRelativePath()));
        }
        return datasetPath;
    }

    public DatasetPath getDatasetPathIfFileExist(Project project, String path, DatasetType datasetType) throws DatasetException {
        DatasetPath datasetPath = this.getDatasetPath(project, path, datasetType);
        this.checkFileExist(datasetPath);
        return datasetPath;
    }

    public void checkFileExist(DatasetPath datasetPath) throws DatasetException {
        if (datasetPath.getInode() == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.PATH_NOT_FOUND, Level.FINE);
        }
    }

    public void checkResourceRequestLimit(ResourceRequest resourceRequest, int childrenNum) {
        int limit = 10000;
        if (childrenNum > limit && (resourceRequest.getLimit() == 0 || resourceRequest.getLimit() > limit)) {
            resourceRequest.setLimit(limit);
        }
    }

    public void checkIfDatasetExists(Project project, DatasetPath datasetPath) throws DatasetException {
        this.datasetController.getByProjectAndFullPath(project, datasetPath.getDatasetFullPath().toString());
    }

    public boolean isBasicDatasetProjectParent(Project project, DatasetPath datasetPath) {
        String basicDataset = "/Projects/" + project.getName();
        String datasetFullPath = datasetPath.getFullPath().toString();
        return datasetFullPath.startsWith(basicDataset);
    }
}

