/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.elastic.ElasticClientController;
import io.hops.hopsworks.common.elastic.ElasticUtils;
import io.hops.hopsworks.common.elastic.FeaturestoreDocType;
import io.hops.hopsworks.common.elastic.KibanaClient;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeaturestoreXAttrsConstants;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.javatuples.Pair;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ElasticController {
    @EJB
    private Settings settings;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private KibanaClient kibanaClient;
    @EJB
    private ElasticClientController elasticClientCtrl;
    private static final Logger LOG = Logger.getLogger(ElasticController.class.getName());

    public SearchHit[] globalSearchHighLevel(String searchTerm) throws ServiceException, ElasticException {
        if (!this.elasticClientCtrl.mngIndexExists("projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        LOG.log(Level.FINE, "Found elastic index, now executing the query.");
        SearchResponse response = this.executeSearchQuery(this.globalSearchQuery(searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            if (response.getHits().getHits().length > 0) {
                return response.getHits().getHits();
            }
            return new SearchHit[0];
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public SearchHit[] projectSearchHighLevel(Integer projectId, String searchTerm) throws ServiceException, ElasticException {
        if (!this.elasticClientCtrl.mngIndexExists("projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        SearchResponse response = this.executeSearchQuery(this.projectSearchQuery(projectId, searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            SearchHit[] hits = new SearchHit[]{};
            if (response.getHits().getHits().length > 0) {
                hits = response.getHits().getHits();
            }
            this.projectSearchInSharedDatasets(projectId, searchTerm, hits);
            return hits;
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public SearchHit[] datasetSearchHighLevel(Integer projectId, String datasetName, String searchTerm) throws ServiceException, ElasticException {
        Project project;
        if (!this.elasticClientCtrl.mngIndexExists("projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        String dsName = datasetName;
        if (datasetName.contains("::")) {
            String[] sharedDS = datasetName.split("::");
            dsName = sharedDS[1];
            project = this.projectFacade.findByName(sharedDS[0]);
        } else {
            project = this.projectFacade.find(projectId);
        }
        Dataset dataset = this.datasetController.getByProjectAndDsName(project, null, dsName);
        long datasetId = dataset.getInodeId();
        SearchResponse response = this.executeSearchQuery(this.datasetSearchQuery(datasetId, searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            if (response.getHits().getHits().length > 0) {
                return response.getHits().getHits();
            }
            return new SearchHit[0];
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public Map<FeaturestoreDocType, SearchResponse> featurestoreSearch(FeaturestoreDocType docType, String searchTerm, int from, int size) throws ElasticException, ServiceException {
        if (!this.elasticClientCtrl.mngIndexExists("featurestore")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: featurestore");
        }
        HashMap<FeaturestoreDocType, SearchResponse> result = new HashMap<FeaturestoreDocType, SearchResponse>();
        switch (docType) {
            case FEATUREGROUP: {
                QueryBuilder fgQB = this.featuregroupQueryB(searchTerm);
                SearchResponse response = this.executeSearchQuery(fgQB, this.featuregroupHighlighter(), from, size);
                this.checkResponse(fgQB, response);
                result.put(FeaturestoreDocType.FEATUREGROUP, response);
                break;
            }
            case TRAININGDATASET: {
                QueryBuilder tdQB = this.trainingdatasetQueryB(searchTerm);
                SearchResponse response = this.executeSearchQuery(tdQB, this.trainingDatasetHighlighter(), from, size);
                this.checkResponse(tdQB, response);
                result.put(FeaturestoreDocType.TRAININGDATASET, response);
                break;
            }
            case FEATURE: {
                QueryBuilder fQB = this.featureQueryB(searchTerm);
                SearchResponse response = this.executeSearchQuery(fQB, this.featureHighlighter(), 0, 10000);
                this.checkResponse(fQB, response);
                result.put(FeaturestoreDocType.FEATURE, response);
                break;
            }
            case ALL: {
                LinkedList<Pair<QueryBuilder, HighlightBuilder>> qbs = new LinkedList<Pair<QueryBuilder, HighlightBuilder>>();
                QueryBuilder fgQB = this.featuregroupQueryB(searchTerm);
                qbs.add(Pair.with((Object)fgQB, (Object)this.featuregroupHighlighter()));
                QueryBuilder tdQB = this.trainingdatasetQueryB(searchTerm);
                qbs.add(Pair.with((Object)tdQB, (Object)this.trainingDatasetHighlighter()));
                QueryBuilder fQB = this.featureQueryB(searchTerm);
                qbs.add(Pair.with((Object)fQB, (Object)this.featureHighlighter()));
                MultiSearchResponse response = this.executeSearchQuery(qbs, from, size);
                this.checkResponse(fgQB, response.getResponses()[0].getResponse());
                result.put(FeaturestoreDocType.FEATUREGROUP, response.getResponses()[0].getResponse());
                this.checkResponse(fgQB, response.getResponses()[1].getResponse());
                result.put(FeaturestoreDocType.TRAININGDATASET, response.getResponses()[1].getResponse());
                this.checkResponse(fgQB, response.getResponses()[2].getResponse());
                result.put(FeaturestoreDocType.FEATURE, response.getResponses()[2].getResponse());
            }
        }
        return result;
    }

    public Map<FeaturestoreDocType, SearchResponse> featurestoreSearch(String searchTerm, Map<FeaturestoreDocType, Set<Integer>> docProjectIds, int from, int size) throws ElasticException, ServiceException {
        if (!this.elasticClientCtrl.mngIndexExists("featurestore")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: featurestore");
        }
        QueryBuilder fgQB = null;
        QueryBuilder tdQB = null;
        QueryBuilder fQB = null;
        LinkedList<Pair<QueryBuilder, HighlightBuilder>> qbs = new LinkedList<Pair<QueryBuilder, HighlightBuilder>>();
        if (docProjectIds.containsKey((Object)FeaturestoreDocType.FEATUREGROUP)) {
            fgQB = this.addProjectToQuery(this.featuregroupQueryB(searchTerm), docProjectIds.get((Object)FeaturestoreDocType.FEATUREGROUP));
            qbs.add((Pair<QueryBuilder, HighlightBuilder>)Pair.with((Object)fgQB, (Object)this.featuregroupHighlighter()));
        }
        if (docProjectIds.containsKey((Object)FeaturestoreDocType.TRAININGDATASET)) {
            tdQB = this.addProjectToQuery(this.trainingdatasetQueryB(searchTerm), docProjectIds.get((Object)FeaturestoreDocType.TRAININGDATASET));
            qbs.add((Pair<QueryBuilder, HighlightBuilder>)Pair.with((Object)tdQB, (Object)this.trainingDatasetHighlighter()));
        }
        if (docProjectIds.containsKey((Object)FeaturestoreDocType.FEATURE)) {
            fQB = this.addProjectToQuery(this.featureQueryB(searchTerm), docProjectIds.get((Object)FeaturestoreDocType.FEATURE));
            qbs.add((Pair<QueryBuilder, HighlightBuilder>)Pair.with((Object)fQB, (Object)this.featureHighlighter()));
        }
        MultiSearchResponse response = this.executeSearchQuery(qbs, from, size);
        HashMap<FeaturestoreDocType, SearchResponse> result = new HashMap<FeaturestoreDocType, SearchResponse>();
        int idx = 0;
        if (docProjectIds.containsKey((Object)FeaturestoreDocType.FEATUREGROUP)) {
            this.checkResponse(fgQB, response.getResponses()[idx].getResponse());
            result.put(FeaturestoreDocType.FEATUREGROUP, response.getResponses()[idx].getResponse());
            ++idx;
        }
        if (docProjectIds.containsKey((Object)FeaturestoreDocType.TRAININGDATASET)) {
            this.checkResponse(tdQB, response.getResponses()[idx].getResponse());
            result.put(FeaturestoreDocType.TRAININGDATASET, response.getResponses()[idx].getResponse());
            ++idx;
        }
        if (docProjectIds.containsKey((Object)FeaturestoreDocType.FEATURE)) {
            this.checkResponse(fQB, response.getResponses()[idx].getResponse());
            result.put(FeaturestoreDocType.FEATURE, response.getResponses()[idx].getResponse());
            ++idx;
        }
        return result;
    }

    private QueryBuilder addProjectToQuery(QueryBuilder qb, Set<Integer> projectIds) {
        return QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"project_id", projectIds)).must(qb);
    }

    private void checkResponse(QueryBuilder qb, SearchResponse response) throws ElasticException {
        if (response == null || response.status().getStatus() != 200) {
            LOG.log(Level.FINE, "error while executing query:{0} response is:{1}", new Object[]{qb, response == null ? null : Integer.valueOf(response.status().getStatus())});
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.WARNING, "Error while executing elastic query");
        }
    }

    public void createIndexPattern(Project project, Users user, String pattern) throws ProjectException, ElasticException {
        JSONObject resp = this.kibanaClient.createIndexPattern(user, project, KibanaClient.KibanaType.IndexPattern, pattern);
        if (!(resp.has("updated_at") || resp.has("statusCode") && resp.get("statusCode").toString().equals("409"))) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_KIBANA_CREATE_INDEX_ERROR, Level.SEVERE, null, "project: " + project.getName() + ", resp: " + resp.toString(2), null);
        }
    }

    public void deleteProjectIndices(Project project) throws ElasticException {
        String[] indices;
        for (String index : indices = this.elasticClientCtrl.mngIndicesGet(project.getName() + "_(((logs|serving|" + "_beamsdkworker-*" + "|" + "_beamjobserver-*" + ")-\\d{4}.\\d{2}.\\d{2}))")) {
            try {
                this.elasticClientCtrl.mngIndexDelete(index);
            }
            catch (ElasticException e) {
                LOG.log(Level.SEVERE, "Could not delete project index:{0}", index);
            }
        }
    }

    public void deleteProjectSavedObjects(String project) throws ElasticException {
        if (!this.settings.isKibanaMultiTenancyEnabled().booleanValue()) {
            throw new UnsupportedOperationException("Only multitenant kibana setup supported.");
        }
        this.elasticClientCtrl.mngIndexDelete(ElasticUtils.getAllKibanaTenantIndex(project.toLowerCase()));
    }

    private SearchHit[] projectSearchInSharedDatasets(Integer projectId, String searchTerm, SearchHit[] elasticHits) throws ElasticException {
        Project project = this.projectFacade.find(projectId);
        Collection datasetSharedWithCollection = project.getDatasetSharedWithCollection();
        for (DatasetSharedWith ds : datasetSharedWithCollection) {
            long datasetId = ds.getDataset().getInode().getId();
            elasticHits = this.executeProjectSearchQuery(this.searchSpecificDataset(datasetId, searchTerm), elasticHits);
            elasticHits = this.executeProjectSearchQuery(this.datasetSearchQuery(datasetId, searchTerm), elasticHits);
        }
        return elasticHits;
    }

    private SearchHit[] executeProjectSearchQuery(QueryBuilder query, SearchHit[] elasticHits) throws ElasticException {
        SearchResponse response = this.executeSearchQuery(query);
        if (response.status().getStatus() == 200 && response.getHits().getHits().length > 0) {
            SearchHit[] hits = response.getHits().getHits();
            elasticHits = (SearchHit[])Stream.concat(Arrays.stream(elasticHits), Arrays.stream(hits)).toArray(SearchHit[]::new);
        }
        return elasticHits;
    }

    private SearchResponse executeSearchQuery(QueryBuilder query) throws ElasticException {
        return this.executeSearchQuery("projects", query);
    }

    private SearchResponse executeSearchQuery(String index, QueryBuilder query) throws ElasticException {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sb = new SearchSourceBuilder();
        sb.query(query);
        searchRequest.source(sb);
        return this.elasticClientCtrl.baseSearch(searchRequest);
    }

    private SearchResponse executeSearchQuery(QueryBuilder query, HighlightBuilder highlighter, int from, int size) throws ElasticException {
        SearchRequest searchRequest = new SearchRequest(new String[]{"featurestore"});
        SearchSourceBuilder sb = new SearchSourceBuilder().query(query).highlighter(highlighter).from(from).size(size);
        searchRequest.source(sb);
        return this.elasticClientCtrl.baseSearch(searchRequest);
    }

    private MultiSearchResponse executeSearchQuery(List<Pair<QueryBuilder, HighlightBuilder>> searchQB, int from, int size) throws ElasticException {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (Pair<QueryBuilder, HighlightBuilder> qb : searchQB) {
            SearchRequest searchRequest = new SearchRequest(new String[]{"featurestore"});
            SearchSourceBuilder sb = new SearchSourceBuilder().query((QueryBuilder)qb.getValue0()).highlighter((HighlightBuilder)qb.getValue1()).from(from).size(size);
            searchRequest.source(sb);
            multiSearchRequest.add(searchRequest);
        }
        return this.elasticClientCtrl.multiSearch(multiSearchRequest);
    }

    private QueryBuilder searchSpecificDataset(Long datasetId, String searchTerm) {
        MatchQueryBuilder dataset = QueryBuilders.matchQuery((String)"_id", (Object)datasetId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        return QueryBuilders.boolQuery().must((QueryBuilder)dataset).must(nameDescQuery);
    }

    private QueryBuilder globalSearchQuery(String searchTerm) {
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndProjectsQuery = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "proj"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)onlyDatasetsAndProjectsQuery).must(nameDescQuery);
        return query;
    }

    private QueryBuilder projectSearchQuery(Integer projectId, String searchTerm) {
        TermQueryBuilder projectIdQuery = QueryBuilders.termQuery((String)"project_id", (Object)projectId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndInodes = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "inode"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)projectIdQuery).must((QueryBuilder)onlyDatasetsAndInodes).must(nameDescQuery);
        return query;
    }

    private QueryBuilder datasetSearchQuery(long datasetId, String searchTerm) {
        TermQueryBuilder datasetIdQuery = QueryBuilders.termQuery((String)"dataset_id", (long)datasetId);
        QueryBuilder query = this.getNameDescriptionMetadataQuery(searchTerm);
        TermQueryBuilder onlyInodes = QueryBuilders.termQuery((String)"doc_type", (String)"inode");
        BoolQueryBuilder cq = QueryBuilders.boolQuery().must((QueryBuilder)datasetIdQuery).must((QueryBuilder)onlyInodes).must(query);
        return cq;
    }

    private QueryBuilder featuregroupQueryB(String searchTerm) {
        BoolQueryBuilder termQuery = QueryBuilders.boolQuery().should(this.getNameQuery(searchTerm)).should(this.getDescriptionQuery(searchTerm)).should(this.getMetadataQuery(searchTerm));
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)FeaturestoreDocType.FEATUREGROUP.toString().toLowerCase())).must((QueryBuilder)termQuery);
        return query;
    }

    private QueryBuilder trainingdatasetQueryB(String searchTerm) {
        BoolQueryBuilder termQuery = QueryBuilders.boolQuery().should(this.getNameQuery(searchTerm)).should(this.getDescriptionQuery(searchTerm)).should(this.getMetadataQuery(searchTerm));
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)FeaturestoreDocType.TRAININGDATASET.toString().toLowerCase())).must((QueryBuilder)termQuery);
        return query;
    }

    private QueryBuilder featureQueryB(String searchTerm) {
        String key1 = FeaturestoreXAttrsConstants.getFeaturestoreElasticKey("fg_features") + ".*";
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)FeaturestoreDocType.FEATUREGROUP.toString().toLowerCase())).must(this.getXAttrQuery(key1, searchTerm));
        return query;
    }

    private HighlightBuilder featuregroupHighlighter() {
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(new HighlightBuilder.Field("name"));
        hb.field(new HighlightBuilder.Field(FeaturestoreXAttrsConstants.getFeaturestoreElasticKey("description")));
        hb.field(new HighlightBuilder.Field("xattr.*"));
        return hb;
    }

    private HighlightBuilder trainingDatasetHighlighter() {
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(new HighlightBuilder.Field("name"));
        hb.field(new HighlightBuilder.Field(FeaturestoreXAttrsConstants.getFeaturestoreElasticKey("description")));
        hb.field(new HighlightBuilder.Field("xattr.*"));
        return hb;
    }

    private HighlightBuilder featureHighlighter() {
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(new HighlightBuilder.Field(FeaturestoreXAttrsConstants.getFeaturestoreElasticKey("fg_features") + ".*"));
        return hb;
    }

    private QueryBuilder getNameDescriptionMetadataQuery(String searchTerm) {
        QueryBuilder nameQuery = this.getNameQuery(searchTerm);
        QueryBuilder descriptionQuery = this.getDescriptionQuery(searchTerm);
        QueryBuilder metadataQuery = this.getMetadataQuery(searchTerm);
        BoolQueryBuilder textCondition = QueryBuilders.boolQuery().should(nameQuery).should(descriptionQuery).should(metadataQuery);
        return textCondition;
    }

    private QueryBuilder getNameQuery(String searchTerm) {
        PrefixQueryBuilder namePrefixMatch = QueryBuilders.prefixQuery((String)"name", (String)searchTerm);
        MatchPhraseQueryBuilder namePhraseMatch = QueryBuilders.matchPhraseQuery((String)"name", (Object)searchTerm);
        FuzzyQueryBuilder nameFuzzyQuery = QueryBuilders.fuzzyQuery((String)"name", (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)"name", (String)String.format("*%s*", searchTerm));
        BoolQueryBuilder nameQuery = QueryBuilders.boolQuery().should((QueryBuilder)namePrefixMatch).should((QueryBuilder)namePhraseMatch).should((QueryBuilder)nameFuzzyQuery).should((QueryBuilder)wildCardQuery);
        return nameQuery;
    }

    private QueryBuilder getDescriptionQuery(String searchTerm) {
        PrefixQueryBuilder descriptionPrefixMatch = QueryBuilders.prefixQuery((String)"description", (String)searchTerm);
        TermsQueryBuilder descriptionMatch = QueryBuilders.termsQuery((String)"description", (String[])new String[]{searchTerm});
        MatchPhraseQueryBuilder descriptionPhraseMatch = QueryBuilders.matchPhraseQuery((String)"description", (Object)searchTerm);
        FuzzyQueryBuilder descriptionFuzzyQuery = QueryBuilders.fuzzyQuery((String)"description", (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)"description", (String)String.format("*%s*", searchTerm));
        BoolQueryBuilder descriptionQuery = QueryBuilders.boolQuery().should((QueryBuilder)descriptionPrefixMatch).should((QueryBuilder)descriptionMatch).should((QueryBuilder)descriptionPhraseMatch).should((QueryBuilder)descriptionFuzzyQuery).should((QueryBuilder)wildCardQuery);
        return descriptionQuery;
    }

    private QueryBuilder getMetadataQuery(String searchTerm) {
        return this.getXAttrQuery("xattr.*", searchTerm);
    }

    private QueryBuilder getXAttrQuery(String key, String searchTerm) {
        QueryStringQueryBuilder metadataQuery = QueryBuilders.queryStringQuery((String)String.format("*%s*", searchTerm)).lenient(Boolean.TRUE).field(key);
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"xattr", (QueryBuilder)metadataQuery, (ScoreMode)ScoreMode.Avg);
        return nestedQuery;
    }
}

