/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidation;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.Name;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.Predicate;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.ValidationRule;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class RuleFacade
extends AbstractFacade<ValidationRule> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public RuleFacade() {
        super(ValidationRule.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public ValidationRule findById(int id) {
        return (ValidationRule)this.em.find(ValidationRule.class, (Object)id);
    }

    public AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort) {
        String queryStr = this.buildQuery("SELECT vr FROM ValidationRule vr ", filter, sort, null);
        String queryCountStr = this.buildQuery("SELECT COUNT(vr.id) FROM ValidationRule vr ", filter, sort, null);
        TypedQuery query = this.em.createQuery(queryStr, ValidationRule.class);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, ValidationRule.class);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo findByName(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, Name name) {
        String queryStr = this.buildQuery("SELECT vr FROM ValidationRule vr ", filters, sorts, "vr.name = :name ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT vr.id) FROM ValidationRule vr ", filters, sorts, "vr.name = :name ");
        TypedQuery query = this.em.createQuery(queryStr, Jobs.class).setParameter("name", (Object)name);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Jobs.class).setParameter("name", (Object)name);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public Optional<ValidationRule> findByName(Name name) {
        try {
            return Optional.of(this.em.createNamedQuery("ValidationRule.findByName", ValidationRule.class).setParameter("name", (Object)name).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public ValidationRule findByNameAndPredicate(Name name, Predicate predicate) {
        try {
            return (ValidationRule)this.em.createNamedQuery("ValidationRule.findByNameAndPredicate", ValidationRule.class).setParameter("name", (Object)name).setParameter("predicate", (Object)predicate).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static enum Sorts {
        NAME("NAME", "vr.name ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

