/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.search;

import io.hops.hopsworks.common.elastic.ElasticClientController;
import io.hops.hopsworks.common.util.Settings;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class PyPiLibraryElasticIndexer {
    @EJB
    private ElasticClientController elasticClientCtrl;
    @EJB
    private Settings settings;
    @Resource
    private TimerService timerService;
    private boolean isIndexed = false;
    private static final Logger LOGGER = Logger.getLogger(PyPiLibraryElasticIndexer.class.getName());

    public boolean isIndexed() {
        return this.isIndexed;
    }

    @PostConstruct
    public void init() {
        this.scheduleTimer(0L);
    }

    private void scheduleTimer(long duration) {
        this.timerService.createSingleActionTimer(duration, new TimerConfig((Serializable)((Object)"PyPi Search Indexer"), false));
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void execute(Timer timer) {
        long errorRescheduleTimeout = 300000L;
        LOGGER.log(Level.INFO, "Running PyPi Indexer");
        try {
            ClusterHealthResponse clusterHealthResponse = this.elasticClientCtrl.clusterHealthGet();
            GetIndexTemplatesResponse templateResponse = this.elasticClientCtrl.templateGet("pypi_libraries");
            if (clusterHealthResponse.getStatus().equals((Object)ClusterHealthStatus.RED)) {
                this.scheduleTimer(errorRescheduleTimeout);
                LOGGER.log(Level.INFO, "Elastic currently down, rescheduling indexing for pypi libraries");
                return;
            }
            if (templateResponse.getIndexTemplates().isEmpty()) {
                this.scheduleTimer(errorRescheduleTimeout);
                LOGGER.log(Level.INFO, "Elastic template pypi_libraries currently missing, rescheduling indexing for pypi libraries");
                return;
            }
        }
        catch (Exception e) {
            this.scheduleTimer(errorRescheduleTimeout);
            LOGGER.log(Level.SEVERE, "Exception occurred trying to index pypi libraries, rescheduling timer", e);
            return;
        }
        try {
            GetAliasesResponse pypiAlias = this.elasticClientCtrl.getAliases("pypi_libraries");
            if (!pypiAlias.getAliases().isEmpty()) {
                this.isIndexed = true;
            }
            String[] indicesToDelete = this.elasticClientCtrl.mngIndicesGet("pypi_libraries_\\d+");
            String newIndex = "pypi_libraries_" + System.currentTimeMillis();
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(newIndex);
            this.elasticClientCtrl.mngIndexCreate(createIndexRequest);
            Element body = Jsoup.connect((String)this.settings.getPyPiSimpleEndpoint()).maxBodySize(0).get().body();
            Elements elements = body.getElementsByTag("a");
            int bulkSize = 100;
            int currentBulkSize = 0;
            int currentId = 0;
            BulkRequest bulkRequest = new BulkRequest();
            LOGGER.log(Level.INFO, "Starting to index libraries from pypi simple index");
            for (Element library : elements) {
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(newIndex)).id(String.valueOf(currentId)).source(XContentFactory.jsonBuilder().startObject().field("library", library.text()).endObject());
                bulkRequest.add(indexRequest);
                ++currentId;
                if (++currentBulkSize != 100) continue;
                this.elasticClientCtrl.bulkUpdateDoc(bulkRequest);
                bulkRequest = new BulkRequest();
                currentBulkSize = 0;
            }
            if (bulkRequest.numberOfActions() > 0) {
                this.elasticClientCtrl.bulkUpdateDoc(bulkRequest);
            }
            if (pypiAlias.getAliases().isEmpty()) {
                this.elasticClientCtrl.createAlias("pypi_libraries", newIndex);
            } else {
                String currentSearchIndex = (String)pypiAlias.getAliases().keySet().iterator().next();
                this.elasticClientCtrl.aliasSwitchIndex("pypi_libraries", currentSearchIndex, newIndex);
            }
            this.isIndexed = true;
            LOGGER.log(Level.INFO, "Finished indexing");
            for (String index : indicesToDelete) {
                DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest().indices(new String[]{index});
                this.elasticClientCtrl.mngIndexDelete(deleteIndexRequest);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Indexing pypi libraries failed", ex);
            this.scheduleTimer(errorRescheduleTimeout);
            return;
        }
        String rawInterval = this.settings.getPyPiIndexerTimerInterval();
        Long intervalValue = this.settings.getConfTimeValue(rawInterval);
        TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
        this.scheduleTimer(intervalTimeunit.toMillis(intervalValue));
    }
}

