/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureGroupValidation;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureGroupCommitFacade
extends AbstractFacade<FeatureGroupCommit> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureGroupCommitFacade() {
        super(FeatureGroupCommit.class);
    }

    public void createFeatureGroupCommit(FeatureGroupCommit featureGroupCommit) {
        this.em.persist((Object)featureGroupCommit);
        this.em.flush();
    }

    public Optional<FeatureGroupCommit> findClosestDateCommit(Integer featureGroupId, Long commitTimestamp) {
        Timestamp requestedPointInTime = new Timestamp(commitTimestamp);
        TypedQuery fgcQuery = this.em.createNamedQuery("FeatureGroupCommit.findByLatestCommittedOn", FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId).setParameter("requestedPointInTime", (Object)requestedPointInTime);
        try {
            return Optional.of((FeatureGroupCommit)fgcQuery.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeatureGroupCommit> findLatestDateCommit(Integer featureGroupId) {
        TypedQuery fgcQuery = this.em.createNamedQuery("FeatureGroupCommit.findLatestCommit", FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        try {
            return Optional.of((FeatureGroupCommit)fgcQuery.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo getCommitDetailsByDate(Integer featureGroupId, Integer limit, Integer offset, Set<? extends AbstractFacade.SortBy> sort, Set<? extends AbstractFacade.FilterBy> filters) {
        String queryStr = this.buildQuery("SELECT fgc FROM FeatureGroupCommit fgc ", filters, sort, "fgc.featureGroupCommitPK.featureGroupId = :featureGroupId");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        String queryCountStr = this.buildQuery("SELECT COUNT(fgc.featureGroupCommitPK.commitId) FROM FeatureGroupCommit fgc ", filters, sort, "fgc.featureGroupCommitPK.featureGroupId = :featureGroupId");
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo getCommitDetails(Integer featureGroupId, Integer limit, Integer offset, Set<? extends AbstractFacade.SortBy> sort) {
        String queryStr = this.buildQuery("SELECT fgc FROM FeatureGroupCommit fgc ", null, sort, "fgc.featureGroupCommitPK.featureGroupId = :featureGroupId");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        String queryCountStr = this.buildQuery("SELECT COUNT(fgc.featureGroupCommitPK.commitId) FROM FeatureGroupCommit fgc ", null, sort, "fgc.featureGroupCommitPK.featureGroupId = :featureGroupId");
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureGroupCommit.class).setParameter("featureGroupId", (Object)featureGroupId);
        query.setFirstResult(offset.intValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public Optional<FeatureGroupCommit> findByValidation(FeatureGroupValidation featureGroupValidation) {
        TypedQuery fgcQuery = this.em.createNamedQuery("FeatureGroupCommit.findByValidation", FeatureGroupCommit.class).setParameter("validation", (Object)featureGroupValidation);
        try {
            return Optional.of((FeatureGroupCommit)fgcQuery.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case COMMITED_ON_EQ: 
            case COMMITED_ON_LTOEQ: 
            case COMMITED_ON_LT: 
            case COMMITED_ON_GT: 
            case COMMITED_ON_GTOEQ: {
                if (Strings.isNullOrEmpty((String)filterBy.getParam()) || filterBy.getParam().equalsIgnoreCase("null")) break;
                Timestamp date = new Timestamp(Long.parseLong(filterBy.getParam()));
                q.setParameter(filterBy.getField(), (Object)date);
                break;
            }
        }
    }

    public static enum Filters {
        COMMITED_ON_EQ("COMMITED_ON_EQ", "fgc.committedOn = :committedOn ", "committedOn", " "),
        COMMITED_ON_GT("COMMITED_ON_GT", "fgc.committedOn > :committedOn ", "committedOn", " "),
        COMMITED_ON_GTOEQ("COMMITED_ON_GTOEQ", "fgc.committedOn => :committedOn ", "committedOn", " "),
        COMMITED_ON_LT("COMMITED_ON_LT", "fgc.committedOn < :committedOn ", "committedOn", " "),
        COMMITED_ON_LTOEQ("COMMITED_ON_LTOEQ", "fgc.committedOn <= :committedOn ", "committedOn", " ");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        COMMITTED_ON("COMMITTED_ON", " fgc.committedOn ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String toString() {
            return this.value;
        }
    }
}

